/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.tapestry5.ioc.IdMatcher;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.internal.IdMatcherImpl;
import org.apache.tapestry5.ioc.internal.OrIdMatcher;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassFactory;

public class AbstractServiceInstrumenter {
    protected final Method method;
    protected final IdMatcher idMatcher;
    protected final String[] constraints;
    protected final ClassFactory classFactory;

    public AbstractServiceInstrumenter(Method method, String[] patterns, String[] constraints, ClassFactory classFactory) {
        this.method = method;
        this.classFactory = classFactory;
        assert (patterns != null);
        List<IdMatcher> matchers = CollectionFactory.newList();
        for (String pattern : patterns) {
            IdMatcherImpl matcher = new IdMatcherImpl(pattern);
            matchers.add(matcher);
        }
        this.idMatcher = new OrIdMatcher(matchers);
        this.constraints = constraints != null ? constraints : new String[]{};
    }

    public String toString() {
        return InternalUtils.asString(this.method, this.classFactory);
    }

    public String[] getConstraints() {
        return this.constraints;
    }

    public boolean matches(ServiceDef serviceDef) {
        String serviceId = serviceDef.getServiceId();
        return this.idMatcher.matches(serviceId);
    }
}

