/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.ioc.AdvisorDef;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.ModuleBuilderSource;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.ObjectProvider;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.ServiceAdvisor;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.ServiceDecorator;
import org.apache.tapestry5.ioc.ServiceLifecycle;
import org.apache.tapestry5.ioc.ServiceLifecycle2;
import org.apache.tapestry5.ioc.annotations.Local;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.def.ContributionDef2;
import org.apache.tapestry5.ioc.def.DecoratorDef;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.def.ServiceDef2;
import org.apache.tapestry5.ioc.def.StartupDef;
import org.apache.tapestry5.ioc.internal.EagerLoadServiceProxy;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.InternalRegistry;
import org.apache.tapestry5.ioc.internal.MappedConfigurationOverride;
import org.apache.tapestry5.ioc.internal.Module;
import org.apache.tapestry5.ioc.internal.ModuleImpl;
import org.apache.tapestry5.ioc.internal.NullAnnotationProvider;
import org.apache.tapestry5.ioc.internal.OrderedConfigurationOverride;
import org.apache.tapestry5.ioc.internal.PerThreadOperationTracker;
import org.apache.tapestry5.ioc.internal.ReloadableObjectCreator;
import org.apache.tapestry5.ioc.internal.SerializationSupport;
import org.apache.tapestry5.ioc.internal.ServiceActivityTracker;
import org.apache.tapestry5.ioc.internal.ServiceActivityTrackerImpl;
import org.apache.tapestry5.ioc.internal.ServiceProxyProvider;
import org.apache.tapestry5.ioc.internal.ServiceResourcesImpl;
import org.apache.tapestry5.ioc.internal.SingletonServiceLifecycle;
import org.apache.tapestry5.ioc.internal.ValidatingConfigurationWrapper;
import org.apache.tapestry5.ioc.internal.ValidatingMappedConfigurationWrapper;
import org.apache.tapestry5.ioc.internal.ValidatingOrderedConfigurationWrapper;
import org.apache.tapestry5.ioc.internal.services.PerthreadManagerImpl;
import org.apache.tapestry5.ioc.internal.services.RegistryShutdownHubImpl;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InjectionResources;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.MapInjectionResources;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.internal.util.Orderer;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.MasterObjectProvider;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.apache.tapestry5.ioc.services.ServiceActivityScoreboard;
import org.apache.tapestry5.ioc.services.ServiceLifecycleSource;
import org.apache.tapestry5.ioc.services.Status;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.ioc.services.TapestryIOCModule;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.services.UpdateListenerHub;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryImpl
implements Registry,
InternalRegistry,
ServiceProxyProvider {
    private static final String SYMBOL_SOURCE_SERVICE_ID = "SymbolSource";
    private static final String REGISTRY_SHUTDOWN_HUB_SERVICE_ID = "RegistryShutdownHub";
    static final String PERTHREAD_MANAGER_SERVICE_ID = "PerthreadManager";
    private static final String SERVICE_ACTIVITY_SCOREBOARD_SERVICE_ID = "ServiceActivityScoreboard";
    private static final Set<Class> BUILTIN = CollectionFactory.newSet();
    static final String CLASS_FACTORY_SERVICE_ID = "ClassFactory";
    static final String LOGGER_SOURCE_SERVICE_ID = "LoggerSource";
    private final OneShotLock lock = new OneShotLock();
    private final OneShotLock eagerLoadLock = new OneShotLock();
    private final Map<String, Object> builtinServices = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, Class> builtinTypes = CollectionFactory.newCaseInsensitiveMap();
    private final RegistryShutdownHubImpl registryShutdownHub;
    private final LoggerSource loggerSource;
    private final Map<String, Module> serviceIdToModule = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, ServiceLifecycle2> lifecycles = CollectionFactory.newCaseInsensitiveMap();
    private final PerthreadManager perthreadManager;
    private final ClassFactory classFactory;
    private final ServiceActivityTracker tracker;
    private SymbolSource symbolSource;
    private final Map<Module, Set<ServiceDef2>> moduleToServiceDefs = CollectionFactory.newMap();
    private final Map<Class, List<ServiceDef2>> markerToServiceDef = CollectionFactory.newMap();
    private final Set<ServiceDef2> allServiceDefs = CollectionFactory.newSet();
    private final OperationTracker operationTracker;

    public RegistryImpl(Collection<ModuleDef> moduleDefs, ClassFactory classFactory, LoggerSource loggerSource) {
        this.loggerSource = loggerSource;
        this.operationTracker = new PerThreadOperationTracker(loggerSource.getLogger(Registry.class));
        final ServiceActivityTrackerImpl scoreboardAndTracker = new ServiceActivityTrackerImpl();
        this.tracker = scoreboardAndTracker;
        this.classFactory = classFactory;
        Logger logger = this.loggerForBuiltinService(PERTHREAD_MANAGER_SERVICE_ID);
        this.perthreadManager = new PerthreadManagerImpl(logger);
        logger = this.loggerForBuiltinService(REGISTRY_SHUTDOWN_HUB_SERVICE_ID);
        this.registryShutdownHub = new RegistryShutdownHubImpl(logger);
        this.lifecycles.put("singleton", new SingletonServiceLifecycle());
        this.registryShutdownHub.addRegistryShutdownListener(new RegistryShutdownListener(){

            public void registryDidShutdown() {
                scoreboardAndTracker.shutdown();
            }
        });
        for (ModuleDef def : moduleDefs) {
            logger = this.loggerSource.getLogger(def.getLoggerName());
            ModuleImpl module = new ModuleImpl(this, this.tracker, def, classFactory, logger);
            Set moduleServiceDefs = CollectionFactory.newSet();
            for (String serviceId : def.getServiceIds()) {
                ServiceDef2 serviceDef = module.getServiceDef(serviceId);
                moduleServiceDefs.add(serviceDef);
                this.allServiceDefs.add(serviceDef);
                Module existing = this.serviceIdToModule.get(serviceId);
                if (existing != null) {
                    throw new RuntimeException(IOCMessages.serviceIdConflict(serviceId, existing.getServiceDef(serviceId), serviceDef));
                }
                this.serviceIdToModule.put(serviceId, module);
                this.tracker.define(serviceDef, Status.DEFINED);
                for (Class marker : serviceDef.getMarkers()) {
                    InternalUtils.addToMapList(this.markerToServiceDef, marker, serviceDef);
                }
            }
            this.moduleToServiceDefs.put(module, moduleServiceDefs);
        }
        this.addBuiltin(SERVICE_ACTIVITY_SCOREBOARD_SERVICE_ID, ServiceActivityScoreboard.class, scoreboardAndTracker);
        this.addBuiltin(LOGGER_SOURCE_SERVICE_ID, LoggerSource.class, this.loggerSource);
        this.addBuiltin(CLASS_FACTORY_SERVICE_ID, ClassFactory.class, this.classFactory);
        this.addBuiltin(PERTHREAD_MANAGER_SERVICE_ID, PerthreadManager.class, this.perthreadManager);
        this.addBuiltin(REGISTRY_SHUTDOWN_HUB_SERVICE_ID, RegistryShutdownHub.class, this.registryShutdownHub);
        this.validateContributeDefs(moduleDefs);
        scoreboardAndTracker.startup();
        SerializationSupport.setProvider(this);
    }

    private void validateContributeDefs(Collection<ModuleDef> moduleDefs) {
        for (ModuleDef module : moduleDefs) {
            Set<ContributionDef> contributionDefs = module.getContributionDefs();
            for (ContributionDef cd : contributionDefs) {
                String serviceId = cd.getServiceId();
                ContributionDef2 cd2 = InternalUtils.toContributionDef2(cd);
                if (cd2.getServiceId() != null) {
                    if (this.serviceIdToModule.containsKey(serviceId)) continue;
                    throw new IllegalArgumentException(IOCMessages.contributionForNonexistentService(cd));
                }
                if (this.isContributionForExistentService(module, cd2)) continue;
                throw new IllegalArgumentException(IOCMessages.contributionForUnqualifiedService(cd2));
            }
        }
    }

    private boolean isContributionForExistentService(ModuleDef moduleDef, final ContributionDef2 cd) {
        final HashSet<Class> contributionMarkers = new HashSet<Class>(cd.getMarkers());
        boolean localOnly = contributionMarkers.contains(Local.class);
        Flow serviceDefs = localOnly ? this.getLocalServiceDefs(moduleDef) : F.flow(this.allServiceDefs);
        contributionMarkers.retainAll(this.getMarkerAnnotations());
        contributionMarkers.remove(Local.class);
        Flow filtered = serviceDefs.filter(new Predicate<ServiceDef2>(){

            public boolean accept(ServiceDef2 object) {
                return object.getServiceInterface().equals(cd.getServiceInterface());
            }
        }.and((Predicate)new Predicate<ServiceDef2>(){

            public boolean accept(ServiceDef2 serviceDef) {
                return serviceDef.getMarkers().containsAll(contributionMarkers);
            }
        }));
        return !filtered.isEmpty();
    }

    private Flow<ServiceDef2> getLocalServiceDefs(final ModuleDef moduleDef) {
        return F.flow(moduleDef.getServiceIds()).map((Mapper)new Mapper<String, ServiceDef2>(){

            public ServiceDef2 map(String value) {
                return InternalUtils.toServiceDef2(moduleDef.getServiceDef(value));
            }
        });
    }

    @Override
    public void performRegistryStartup() {
        this.eagerLoadLock.lock();
        List<EagerLoadServiceProxy> proxies = CollectionFactory.newList();
        for (Module m : this.moduleToServiceDefs.keySet()) {
            m.collectEagerLoadServices(proxies);
        }
        for (EagerLoadServiceProxy proxy : proxies) {
            proxy.eagerLoadService();
        }
        this.getService("RegistryStartup", Runnable.class).run();
        this.invokeStartups();
        this.cleanupThread();
    }

    private void invokeStartups() {
        for (Module m : this.moduleToServiceDefs.keySet()) {
            Logger logger = this.loggerSource.getLogger(m.getLoggerName());
            for (StartupDef sd : m.getStartupDefs()) {
                try {
                    sd.startup(m, this, this, logger);
                }
                catch (RuntimeException e) {
                    logger.error(ServiceMessages.startupFailure(e));
                }
            }
        }
    }

    @Override
    public Logger getServiceLogger(String serviceId) {
        Module module = this.serviceIdToModule.get(serviceId);
        assert (module != null);
        return this.loggerSource.getLogger(module.getLoggerName() + "." + serviceId);
    }

    private Logger loggerForBuiltinService(String serviceId) {
        return this.loggerSource.getLogger(TapestryIOCModule.class + "." + serviceId);
    }

    private <T> void addBuiltin(final String serviceId, final Class<T> serviceInterface, T service) {
        this.builtinTypes.put(serviceId, serviceInterface);
        this.builtinServices.put(serviceId, service);
        ServiceDef2 serviceDef = new ServiceDef2(){

            @Override
            public ObjectCreator createServiceCreator(ServiceBuilderResources resources) {
                return null;
            }

            @Override
            public Set<Class> getMarkers() {
                return BUILTIN;
            }

            @Override
            public String getServiceId() {
                return serviceId;
            }

            @Override
            public Class getServiceInterface() {
                return serviceInterface;
            }

            @Override
            public String getServiceScope() {
                return "singleton";
            }

            @Override
            public boolean isEagerLoad() {
                return false;
            }

            @Override
            public boolean isPreventDecoration() {
                return true;
            }
        };
        for (Class marker : serviceDef.getMarkers()) {
            InternalUtils.addToMapList(this.markerToServiceDef, marker, serviceDef);
            this.allServiceDefs.add(serviceDef);
        }
        this.tracker.define(serviceDef, Status.BUILTIN);
    }

    @Override
    public synchronized void shutdown() {
        this.lock.lock();
        this.registryShutdownHub.fireRegistryDidShutdown();
        SerializationSupport.clearProvider(this);
    }

    @Override
    public <T> T getService(String serviceId, Class<T> serviceInterface) {
        this.lock.check();
        T result = this.checkForBuiltinService(serviceId, serviceInterface);
        if (result != null) {
            return result;
        }
        Module containingModule = this.locateModuleForService(serviceId);
        return containingModule.getService(serviceId, serviceInterface);
    }

    private <T> T checkForBuiltinService(String serviceId, Class<T> serviceInterface) {
        Object service = this.builtinServices.get(serviceId);
        if (service == null) {
            return null;
        }
        try {
            return serviceInterface.cast(service);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException(IOCMessages.serviceWrongInterface(serviceId, this.builtinTypes.get(serviceId), serviceInterface));
        }
    }

    @Override
    public void cleanupThread() {
        this.lock.check();
        this.perthreadManager.cleanup();
    }

    private Module locateModuleForService(String serviceId) {
        Module module = this.serviceIdToModule.get(serviceId);
        if (module == null) {
            throw new UnknownValueException(String.format("Service id '%s' is not defined by any module.", serviceId), new AvailableValues("Defined service ids", this.serviceIdToModule));
        }
        return module;
    }

    @Override
    public <T> Collection<T> getUnorderedConfiguration(ServiceDef serviceDef, Class<T> objectType) {
        this.lock.check();
        List result = CollectionFactory.newList();
        for (Module m : this.moduleToServiceDefs.keySet()) {
            this.addToUnorderedConfiguration(result, objectType, serviceDef, m);
        }
        return result;
    }

    @Override
    public <T> List<T> getOrderedConfiguration(ServiceDef serviceDef, Class<T> objectType) {
        this.lock.check();
        String serviceId = serviceDef.getServiceId();
        Logger logger = this.getServiceLogger(serviceId);
        Orderer<6> orderer = new Orderer<6>(logger);
        Map<String, OrderedConfigurationOverride<T>> overrides = CollectionFactory.newCaseInsensitiveMap();
        for (Module m : this.moduleToServiceDefs.keySet()) {
            this.addToOrderedConfiguration(orderer, overrides, objectType, serviceDef, m);
        }
        if (serviceId.equals("MasterObjectProvider")) {
            ObjectProvider contribution = new ObjectProvider(){

                @Override
                public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
                    return (T)RegistryImpl.this.findServiceByMarkerAndType(objectType, annotationProvider, null);
                }
            };
            orderer.add("ServiceByMarker", contribution, new String[0]);
        }
        for (OrderedConfigurationOverride override : overrides.values()) {
            override.apply();
        }
        return orderer.getOrdered();
    }

    @Override
    public <K, V> Map<K, V> getMappedConfiguration(ServiceDef serviceDef, Class<K> keyType, Class<V> objectType) {
        this.lock.check();
        Map<K, V> result = this.newConfigurationMap(keyType);
        Map<K, V> keyToContribution = this.newConfigurationMap(keyType);
        Map<K, V> overrides = this.newConfigurationMap(keyType);
        for (Module m : this.moduleToServiceDefs.keySet()) {
            this.addToMappedConfiguration(result, overrides, keyToContribution, keyType, objectType, serviceDef, m);
        }
        for (MappedConfigurationOverride override : overrides.values()) {
            override.apply();
        }
        return result;
    }

    private <K, V> Map<K, V> newConfigurationMap(Class<K> keyType) {
        if (keyType.equals(String.class)) {
            Map result = CollectionFactory.newCaseInsensitiveMap();
            return result;
        }
        return CollectionFactory.newMap();
    }

    private <K, V> void addToMappedConfiguration(Map<K, V> map, Map<K, MappedConfigurationOverride<K, V>> overrides, Map<K, ContributionDef> keyToContribution, Class<K> keyClass, Class<V> valueType, ServiceDef serviceDef, final Module module) {
        String serviceId = serviceDef.getServiceId();
        Set<ContributionDef2> contributions = module.getContributorDefsForService(serviceDef);
        if (contributions.isEmpty()) {
            return;
        }
        Logger logger = this.getServiceLogger(serviceId);
        boolean debug = logger.isDebugEnabled();
        final ServiceResourcesImpl resources = new ServiceResourcesImpl(this, module, serviceDef, this.classFactory, logger);
        for (final ContributionDef2 def : contributions) {
            final ValidatingMappedConfigurationWrapper<K, V> validating = new ValidatingMappedConfigurationWrapper<K, V>(valueType, resources, map, overrides, serviceId, def, keyClass, keyToContribution);
            String description = IOCMessages.invokingMethod(def);
            if (debug) {
                logger.debug(description);
            }
            this.operationTracker.run(description, new Runnable(){

                public void run() {
                    def.contribute((ModuleBuilderSource)module, resources, validating);
                }
            });
        }
    }

    private <T> void addToUnorderedConfiguration(Collection<T> collection, Class<T> valueType, ServiceDef serviceDef, final Module module) {
        String serviceId = serviceDef.getServiceId();
        Set<ContributionDef2> contributions = module.getContributorDefsForService(serviceDef);
        if (contributions.isEmpty()) {
            return;
        }
        Logger logger = this.getServiceLogger(serviceId);
        boolean debug = logger.isDebugEnabled();
        final ServiceResourcesImpl resources = new ServiceResourcesImpl(this, module, serviceDef, this.classFactory, logger);
        for (final ContributionDef2 def : contributions) {
            final ValidatingConfigurationWrapper<T> validating = new ValidatingConfigurationWrapper<T>(valueType, resources, collection, serviceId);
            String description = IOCMessages.invokingMethod(def);
            if (debug) {
                logger.debug(description);
            }
            this.operationTracker.run(description, new Runnable(){

                public void run() {
                    def.contribute((ModuleBuilderSource)module, resources, validating);
                }
            });
        }
    }

    private <T> void addToOrderedConfiguration(Orderer<T> orderer, Map<String, OrderedConfigurationOverride<T>> overrides, Class<T> valueType, ServiceDef serviceDef, final Module module) {
        String serviceId = serviceDef.getServiceId();
        Set<ContributionDef2> contributions = module.getContributorDefsForService(serviceDef);
        if (contributions.isEmpty()) {
            return;
        }
        Logger logger = this.getServiceLogger(serviceId);
        boolean debug = logger.isDebugEnabled();
        final ServiceResourcesImpl resources = new ServiceResourcesImpl(this, module, serviceDef, this.classFactory, logger);
        for (final ContributionDef2 def : contributions) {
            final ValidatingOrderedConfigurationWrapper<T> validating = new ValidatingOrderedConfigurationWrapper<T>(valueType, resources, orderer, overrides, def, serviceId);
            String description = IOCMessages.invokingMethod(def);
            if (debug) {
                logger.debug(description);
            }
            this.operationTracker.run(description, new Runnable(){

                public void run() {
                    def.contribute((ModuleBuilderSource)module, resources, validating);
                }
            });
        }
    }

    @Override
    public <T> T getService(Class<T> serviceInterface) {
        this.lock.check();
        List<String> serviceIds = this.findServiceIdsForInterface(serviceInterface);
        if (serviceIds == null) {
            serviceIds = Collections.emptyList();
        }
        switch (serviceIds.size()) {
            case 0: {
                throw new RuntimeException(IOCMessages.noServiceMatchesType(serviceInterface));
            }
            case 1: {
                String serviceId = serviceIds.get(0);
                return this.getService(serviceId, serviceInterface);
            }
        }
        Collections.sort(serviceIds);
        throw new RuntimeException(IOCMessages.manyServiceMatches(serviceInterface, serviceIds));
    }

    private List<String> findServiceIdsForInterface(Class serviceInterface) {
        List<String> result = CollectionFactory.newList();
        for (Module module : this.moduleToServiceDefs.keySet()) {
            result.addAll(module.findServiceIdsForInterface(serviceInterface));
        }
        for (Map.Entry entry : this.builtinServices.entrySet()) {
            if (!serviceInterface.isInstance(entry.getValue())) continue;
            result.add((String)entry.getKey());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public ServiceLifecycle2 getServiceLifecycle(String scope) {
        this.lock.check();
        ServiceLifecycle result = this.lifecycles.get(scope);
        if (result == null) {
            ServiceLifecycleSource source = this.getService("ServiceLifecycleSource", ServiceLifecycleSource.class);
            result = source.get(scope);
        }
        if (result == null) {
            throw new RuntimeException(IOCMessages.unknownScope(scope));
        }
        return InternalUtils.toServiceLifecycle2(result);
    }

    @Override
    public List<ServiceDecorator> findDecoratorsForService(ServiceDef serviceDef) {
        this.lock.check();
        assert (serviceDef != null);
        Logger logger = this.getServiceLogger(serviceDef.getServiceId());
        Orderer<ServiceDecorator> orderer = new Orderer<ServiceDecorator>(logger);
        for (Module module : this.moduleToServiceDefs.keySet()) {
            Set<DecoratorDef> decoratorDefs = module.findMatchingDecoratorDefs(serviceDef);
            if (decoratorDefs.isEmpty()) continue;
            ServiceResourcesImpl resources = new ServiceResourcesImpl(this, module, serviceDef, this.classFactory, logger);
            for (DecoratorDef decoratorDef : decoratorDefs) {
                ServiceDecorator decorator = decoratorDef.createDecorator(module, resources);
                orderer.add(decoratorDef.getDecoratorId(), decorator, decoratorDef.getConstraints());
            }
        }
        return orderer.getOrdered();
    }

    @Override
    public List<ServiceAdvisor> findAdvisorsForService(ServiceDef serviceDef) {
        this.lock.check();
        assert (serviceDef != null);
        Logger logger = this.getServiceLogger(serviceDef.getServiceId());
        Orderer<ServiceAdvisor> orderer = new Orderer<ServiceAdvisor>(logger);
        for (Module module : this.moduleToServiceDefs.keySet()) {
            Set<AdvisorDef> advisorDefs = module.findMatchingServiceAdvisors(serviceDef);
            if (advisorDefs.isEmpty()) continue;
            ServiceResourcesImpl resources = new ServiceResourcesImpl(this, module, serviceDef, this.classFactory, logger);
            for (AdvisorDef advisorDef : advisorDefs) {
                ServiceAdvisor advisor = advisorDef.createAdvisor(module, resources);
                orderer.add(advisorDef.getAdvisorId(), advisor, advisorDef.getConstraints());
            }
        }
        return orderer.getOrdered();
    }

    @Override
    public ClassFab newClass(Class serviceInterface) {
        this.lock.check();
        return this.classFactory.newClass(serviceInterface);
    }

    @Override
    public <T> T getObject(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator, Module localModule) {
        this.lock.check();
        AnnotationProvider effectiveProvider = annotationProvider != null ? annotationProvider : new NullAnnotationProvider();
        T result = this.findServiceByMarkerAndType(objectType, annotationProvider, localModule);
        if (result != null) {
            return result;
        }
        MasterObjectProvider masterProvider = this.getService("MasterObjectProvider", MasterObjectProvider.class);
        return masterProvider.provide(objectType, effectiveProvider, locator, true);
    }

    private Collection<ServiceDef2> filterByType(Class<?> objectType, Collection<ServiceDef2> serviceDefs) {
        Set<ServiceDef2> result = CollectionFactory.newSet();
        for (ServiceDef2 sd : serviceDefs) {
            if (!objectType.isAssignableFrom(sd.getServiceInterface())) continue;
            result.add(sd);
        }
        return result;
    }

    private <T> T findServiceByMarkerAndType(Class<T> objectType, AnnotationProvider provider, Module localModule) {
        if (provider == null) {
            return null;
        }
        boolean localOnly = localModule != null && provider.getAnnotation(Local.class) != null;
        Set<ServiceDef2> matches = CollectionFactory.newSet();
        matches.addAll(this.filterByType(objectType, localOnly ? this.moduleToServiceDefs.get(localModule) : this.allServiceDefs));
        List<Class> markers = CollectionFactory.newList();
        if (localOnly) {
            markers.add(Local.class);
        }
        for (Class marker : this.markerToServiceDef.keySet()) {
            if (provider.getAnnotation(marker) == null) continue;
            markers.add(marker);
            matches = RegistryImpl.intersection(matches, (Collection)this.markerToServiceDef.get(marker));
        }
        if (markers.isEmpty()) {
            return null;
        }
        switch (matches.size()) {
            case 1: {
                ServiceDef def = (ServiceDef)matches.iterator().next();
                return this.getService(def.getServiceId(), objectType);
            }
            case 0: {
                throw new RuntimeException(IOCMessages.noServicesMatchMarker(objectType, markers));
            }
        }
        throw new RuntimeException(IOCMessages.manyServicesMatchMarker(objectType, markers, matches));
    }

    private static <T> Set<T> intersection(Set<T> set, Collection<T> filter) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        Set result = CollectionFactory.newSet();
        for (T elem : filter) {
            if (!set.contains(elem)) continue;
            result.add(elem);
        }
        return result;
    }

    @Override
    public <T> T getObject(Class<T> objectType, AnnotationProvider annotationProvider) {
        return this.getObject(objectType, annotationProvider, this, null);
    }

    @Override
    public void addRegistryShutdownListener(RegistryShutdownListener listener) {
        this.lock.check();
        this.registryShutdownHub.addRegistryShutdownListener(listener);
    }

    @Override
    public String expandSymbols(String input) {
        this.lock.check();
        if (!InternalUtils.containsSymbols(input)) {
            return input;
        }
        return this.getSymbolSource().expandSymbols(input);
    }

    private synchronized SymbolSource getSymbolSource() {
        if (this.symbolSource == null) {
            this.symbolSource = this.getService(SYMBOL_SOURCE_SERVICE_ID, SymbolSource.class);
        }
        return this.symbolSource;
    }

    @Override
    public <T> T autobuild(String description, final Class<T> clazz) {
        return this.invoke(description, new Invokable<T>(){

            @Override
            public T invoke() {
                return RegistryImpl.this.autobuild(clazz);
            }
        });
    }

    @Override
    public <T> T autobuild(final Class<T> clazz) {
        assert (clazz != null);
        final Constructor constructor = InternalUtils.findAutobuildConstructor(clazz);
        if (constructor == null) {
            throw new RuntimeException(IOCMessages.noAutobuildConstructor(clazz));
        }
        Map<Class, Object> resourcesMap = CollectionFactory.newMap();
        resourcesMap.put(OperationTracker.class, this);
        final MapInjectionResources resources = new MapInjectionResources(resourcesMap);
        Invokable operation = new Invokable<T>(){

            @Override
            public T invoke() {
                InternalUtils.validateConstructorForAutobuild(constructor);
                Object result = RegistryImpl.this.invokeConstructor(constructor, resources);
                InternalUtils.injectIntoFields(result, RegistryImpl.this, resources, RegistryImpl.this);
                return clazz.cast(result);
            }
        };
        T result = this.invoke("Autobuilding instance of class " + clazz.getName(), operation);
        InternalUtils.invokePostInjectionMethods(result, this, resources, this);
        return result;
    }

    @Override
    public <T> T proxy(Class<T> interfaceClass, Class<? extends T> implementationClass) {
        return this.proxy(interfaceClass, implementationClass, this);
    }

    @Override
    public <T> T proxy(Class<T> interfaceClass, Class<? extends T> implementationClass, ObjectLocator locator) {
        assert (interfaceClass != null);
        assert (implementationClass != null);
        if (InternalUtils.isLocalFile(implementationClass)) {
            return this.createReloadingProxy(interfaceClass, implementationClass, locator);
        }
        return this.createNonReloadingProxy(interfaceClass, implementationClass, locator);
    }

    private <T> T createNonReloadingProxy(Class<T> interfaceClass, final Class<? extends T> implementationClass, final ObjectLocator locator) {
        final ObjectCreator autobuildCreator = new ObjectCreator(){

            public Object createObject() {
                return locator.autobuild(implementationClass);
            }
        };
        ObjectCreator justInTime = new ObjectCreator(){
            private Object delegate;

            public synchronized Object createObject() {
                if (this.delegate == null) {
                    this.delegate = autobuildCreator.createObject();
                }
                return this.delegate;
            }
        };
        return this.classFactory.createProxy(interfaceClass, implementationClass, justInTime, String.format("<Autobuild proxy %s(%s)>", implementationClass.getName(), interfaceClass.getName()));
    }

    private <T> T createReloadingProxy(Class<T> interfaceClass, Class<? extends T> implementationClass, ObjectLocator locator) {
        ReloadableObjectCreator creator = new ReloadableObjectCreator(implementationClass.getClassLoader(), implementationClass.getName(), this.loggerSource.getLogger(implementationClass), this, locator);
        this.getService(UpdateListenerHub.class).addUpdateListener(creator);
        return this.classFactory.createProxy(interfaceClass, implementationClass, creator, String.format("<Autoreload proxy %s(%s)>", implementationClass.getName(), interfaceClass.getName()));
    }

    @Override
    public Object provideServiceProxy(String serviceId) {
        return this.getService(serviceId, Object.class);
    }

    @Override
    public void run(String description, Runnable operation) {
        this.operationTracker.run(description, operation);
    }

    @Override
    public <T> T invoke(String description, Invokable<T> operation) {
        return this.operationTracker.invoke(description, operation);
    }

    private Object invokeConstructor(final Constructor constructor, final InjectionResources resources) {
        final String description = this.classFactory.getConstructorLocation(constructor).toString();
        return this.invoke("Invoking " + description, new Invokable<Object>(){

            @Override
            public Object invoke() {
                Throwable failure;
                try {
                    Object[] parameters = InternalUtils.calculateParametersForConstructor(constructor, RegistryImpl.this, resources, RegistryImpl.this);
                    return constructor.newInstance(parameters);
                }
                catch (InvocationTargetException ite) {
                    failure = ite.getTargetException();
                }
                catch (Exception ex) {
                    failure = ex;
                }
                throw new RuntimeException(IOCMessages.autobuildConstructorError(description, failure), failure);
            }
        });
    }

    @Override
    public Set<Class> getMarkerAnnotations() {
        return this.markerToServiceDef.keySet();
    }

    static {
        BUILTIN.add(Builtin.class);
    }
}

