/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.ServiceBindingOptions;
import org.apache.tapestry5.ioc.ServiceBuilder;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.annotations.EagerLoad;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.ioc.annotations.PreventServiceDecoration;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.annotations.ServiceId;
import org.apache.tapestry5.ioc.internal.ConstructorServiceCreator;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.ObjectCreatorSource;
import org.apache.tapestry5.ioc.internal.ReloadableObjectCreatorSource;
import org.apache.tapestry5.ioc.internal.ServiceDefAccumulator;
import org.apache.tapestry5.ioc.internal.ServiceDefImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.apache.tapestry5.ioc.services.ClassFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBinderImpl
implements ServiceBinder,
ServiceBindingOptions {
    private final OneShotLock lock = new OneShotLock();
    private final Method bindMethod;
    private final ServiceDefAccumulator accumulator;
    private final ClassFactory classFactory;
    private final Set<Class> defaultMarkers;
    private final boolean moduleDefaultPreventDecoration;
    private String serviceId;
    private Class serviceInterface;
    private Class serviceImplementation;
    private final Set<Class> markers = CollectionFactory.newSet();
    private ObjectCreatorSource source;
    private boolean eagerLoad;
    private String scope;
    private boolean preventDecoration;
    private boolean preventReloading;

    public ServiceBinderImpl(ServiceDefAccumulator accumulator, Method bindMethod, ClassFactory classFactory, Set<Class> defaultMarkers, boolean moduleDefaultPreventDecoration) {
        this.accumulator = accumulator;
        this.bindMethod = bindMethod;
        this.classFactory = classFactory;
        this.defaultMarkers = defaultMarkers;
        this.moduleDefaultPreventDecoration = moduleDefaultPreventDecoration;
        this.clear();
    }

    public void finish() {
        this.lock.lock();
        this.flush();
    }

    protected void flush() {
        if (this.serviceInterface == null) {
            return;
        }
        if (this.source == null) {
            this.source = this.createObjectCreatorSourceFromImplementationClass();
        }
        Set<Class> markers = CollectionFactory.newSet(this.defaultMarkers);
        markers.addAll(this.markers);
        ServiceDefImpl serviceDef = new ServiceDefImpl(this.serviceInterface, this.serviceImplementation, this.serviceId, markers, this.scope, this.eagerLoad, this.preventDecoration, this.source);
        this.accumulator.addServiceDef(serviceDef);
        this.clear();
    }

    private void clear() {
        this.serviceId = null;
        this.serviceInterface = null;
        this.serviceImplementation = null;
        this.source = null;
        this.markers.clear();
        this.eagerLoad = false;
        this.scope = null;
        this.preventDecoration = this.moduleDefaultPreventDecoration;
        this.preventReloading = false;
    }

    private ObjectCreatorSource createObjectCreatorSourceFromImplementationClass() {
        if (!this.preventReloading && this.isProxiable() && this.reloadableScope() && InternalUtils.isLocalFile(this.serviceImplementation)) {
            return this.createReloadableConstructorBasedObjectCreatorSource();
        }
        return this.createStandardConstructorBasedObjectCreatorSource();
    }

    private boolean isProxiable() {
        return this.serviceInterface.isInterface();
    }

    private boolean reloadableScope() {
        return this.scope.equalsIgnoreCase("singleton");
    }

    private ObjectCreatorSource createStandardConstructorBasedObjectCreatorSource() {
        final Constructor constructor = InternalUtils.findAutobuildConstructor(this.serviceImplementation);
        if (constructor == null) {
            throw new RuntimeException(IOCMessages.noConstructor(this.serviceImplementation, this.serviceId));
        }
        return new ObjectCreatorSource(){

            public ObjectCreator constructCreator(ServiceBuilderResources resources) {
                return new ConstructorServiceCreator(resources, this.getDescription(), constructor);
            }

            public String getDescription() {
                return String.format("%s via %s", ServiceBinderImpl.this.classFactory.getConstructorLocation(constructor), ServiceBinderImpl.this.classFactory.getMethodLocation(ServiceBinderImpl.this.bindMethod));
            }
        };
    }

    private ObjectCreatorSource createReloadableConstructorBasedObjectCreatorSource() {
        return new ReloadableObjectCreatorSource(this.classFactory, this.bindMethod, this.serviceInterface, this.serviceImplementation, this.eagerLoad);
    }

    @Override
    public <T> ServiceBindingOptions bind(Class<T> serviceClass) {
        if (serviceClass.isInterface()) {
            try {
                String expectedImplName = serviceClass.getName() + "Impl";
                ClassLoader classLoader = this.classFactory.getClassLoader();
                Class<?> implementationClass = classLoader.loadClass(expectedImplName);
                if (!implementationClass.isInterface() && serviceClass.isAssignableFrom(implementationClass)) {
                    return this.bind(serviceClass, implementationClass);
                }
                throw new RuntimeException(IOCMessages.noServiceMatchesType(serviceClass));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(IOCMessages.noConventionServiceImplementationFound(serviceClass));
            }
        }
        return this.bind(serviceClass, serviceClass);
    }

    @Override
    public <T> ServiceBindingOptions bind(Class<T> serviceInterface, final ServiceBuilder<T> builder) {
        assert (serviceInterface != null);
        assert (builder != null);
        this.lock.check();
        this.flush();
        this.serviceInterface = serviceInterface;
        this.scope = "singleton";
        this.serviceId = serviceInterface.getSimpleName();
        this.source = new ObjectCreatorSource(){

            public ObjectCreator constructCreator(final ServiceBuilderResources resources) {
                return new ObjectCreator(){

                    public Object createObject() {
                        return builder.buildService(resources);
                    }
                };
            }

            public String getDescription() {
                return ServiceBinderImpl.this.classFactory.getMethodLocation(ServiceBinderImpl.this.bindMethod).toString();
            }
        };
        return this;
    }

    @Override
    public <T> ServiceBindingOptions bind(Class<T> serviceInterface, Class<? extends T> serviceImplementation) {
        assert (serviceInterface != null);
        assert (serviceImplementation != null);
        this.lock.check();
        this.flush();
        this.serviceInterface = serviceInterface;
        this.serviceImplementation = serviceImplementation;
        this.eagerLoad = serviceImplementation.getAnnotation(EagerLoad.class) != null;
        ServiceId serviceIdAnnotation = serviceImplementation.getAnnotation(ServiceId.class);
        this.serviceId = serviceIdAnnotation != null ? serviceIdAnnotation.value() : serviceInterface.getSimpleName();
        Scope scope = serviceImplementation.getAnnotation(Scope.class);
        this.scope = scope != null ? scope.value() : "singleton";
        Marker marker = serviceImplementation.getAnnotation(Marker.class);
        if (marker != null) {
            InternalUtils.validateMarkerAnnotations(marker.value());
            this.markers.addAll(Arrays.asList(marker.value()));
        }
        this.preventDecoration |= serviceImplementation.getAnnotation(PreventServiceDecoration.class) != null;
        return this;
    }

    @Override
    public ServiceBindingOptions eagerLoad() {
        this.lock.check();
        this.eagerLoad = true;
        return this;
    }

    @Override
    public ServiceBindingOptions preventDecoration() {
        this.lock.check();
        this.preventDecoration = true;
        return this;
    }

    @Override
    public ServiceBindingOptions preventReloading() {
        this.lock.check();
        this.preventReloading = true;
        return this;
    }

    @Override
    public ServiceBindingOptions withId(String id) {
        assert (InternalUtils.isNonBlank(id));
        this.lock.check();
        this.serviceId = id;
        return this;
    }

    @Override
    public ServiceBindingOptions scope(String scope) {
        assert (InternalUtils.isNonBlank(scope));
        this.lock.check();
        this.scope = scope;
        return this;
    }

    @Override
    public <T extends Annotation> ServiceBindingOptions withMarker(Class<T> ... marker) {
        this.lock.check();
        InternalUtils.validateMarkerAnnotations(marker);
        this.markers.addAll(Arrays.asList(marker));
        return this;
    }
}

