/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.ioc.internal.services.ExceptionAnalysisImpl;
import org.apache.tapestry5.ioc.internal.services.ExceptionInfoImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry5.ioc.services.ExceptionAnalysis;
import org.apache.tapestry5.ioc.services.ExceptionAnalyzer;
import org.apache.tapestry5.ioc.services.ExceptionInfo;
import org.apache.tapestry5.ioc.services.PropertyAccess;

public class ExceptionAnalyzerImpl
implements ExceptionAnalyzer {
    private final PropertyAccess propertyAccess;
    private final Set<String> throwableProperties;

    public ExceptionAnalyzerImpl(PropertyAccess propertyAccess) {
        this.propertyAccess = propertyAccess;
        this.throwableProperties = CollectionFactory.newSet(this.propertyAccess.getAdapter(Throwable.class).getPropertyNames());
    }

    public ExceptionAnalysis analyze(Throwable rootException) {
        List<ExceptionInfo> list = CollectionFactory.newList();
        ExceptionInfo previousInfo = null;
        for (Throwable t = rootException; t != null; t = t.getCause()) {
            ExceptionInfo info = this.extractInfo(t);
            if (!this.addsValue(previousInfo, info)) continue;
            list.add(info);
            previousInfo = info;
        }
        return new ExceptionAnalysisImpl(list);
    }

    private boolean addsValue(ExceptionInfo previousInfo, ExceptionInfo info) {
        if (previousInfo == null) {
            return true;
        }
        if (!info.getStackTrace().isEmpty()) {
            return true;
        }
        if (!previousInfo.getMessage().contains(info.getMessage())) {
            return true;
        }
        for (String name : info.getPropertyNames()) {
            if (info.getProperty(name).equals(previousInfo.getProperty(name))) continue;
            return true;
        }
        return false;
    }

    private ExceptionInfo extractInfo(Throwable t) {
        Map<String, Object> properties = CollectionFactory.newMap();
        ClassPropertyAdapter adapter = this.propertyAccess.getAdapter(t);
        for (String name : adapter.getPropertyNames()) {
            Object value;
            if (this.throwableProperties.contains(name) || !adapter.getPropertyAdapter(name).isRead() || (value = adapter.get(t, name)) == null) continue;
            properties.put(name, value);
        }
        List<StackTraceElement> stackTrace = Collections.emptyList();
        if (t.getCause() == null) {
            stackTrace = Arrays.asList(t.getStackTrace());
        }
        return new ExceptionInfoImpl(t, properties, stackTrace);
    }
}

