/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jfree.xml.generator.ModelBuilder;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.IgnoredPropertyInfo;
import org.jfree.xml.generator.model.PropertyInfo;
import org.jfree.xml.generator.model.PropertyType;
import org.jfree.xml.generator.model.TypeInfo;
import org.jfree.xml.util.AbstractModelReader;
import org.jfree.xml.util.ObjectDescriptionException;

public class DefaultModelReader
extends AbstractModelReader {
    private DescriptionModel model;
    private ClassDescription currentClassDescription;
    private BeanInfo currentBeanInfo;
    private ArrayList propertyList;
    private ArrayList constructorList;
    static /* synthetic */ Class class$java$lang$Object;

    public synchronized DescriptionModel load(String string) throws IOException, ObjectDescriptionException {
        this.model = new DescriptionModel();
        this.parseXml(new File(string).toURL());
        this.fillSuperClasses();
        return this.model;
    }

    protected void fillSuperClasses() {
        for (int i = 0; i < this.model.size(); ++i) {
            ClassDescription classDescription;
            ClassDescription classDescription2 = this.model.get(i);
            Class clazz = classDescription2.getObjectClass().getSuperclass();
            if (clazz == null || (classDescription = this.model.get(clazz)) == null) continue;
            classDescription2.setSuperClass(classDescription.getObjectClass());
        }
    }

    protected boolean startObjectDefinition(String string, String string2) {
        Class clazz = this.loadClass(string);
        if (clazz == null) {
            return false;
        }
        this.currentClassDescription = new ClassDescription(clazz);
        this.currentClassDescription.setRegisterKey(string2);
        try {
            this.currentBeanInfo = Introspector.getBeanInfo(clazz, class$java$lang$Object == null ? (class$java$lang$Object = DefaultModelReader.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (IntrospectionException introspectionException) {
            return false;
        }
        this.propertyList = new ArrayList();
        this.constructorList = new ArrayList();
        return true;
    }

    protected void endObjectDefinition() throws ObjectDescriptionException {
        this.model.addClassDescription(this.currentClassDescription);
        PropertyInfo[] propertyInfoArray = this.propertyList.toArray(new PropertyInfo[this.propertyList.size()]);
        this.currentClassDescription.setProperties(propertyInfoArray);
        TypeInfo[] typeInfoArray = this.constructorList.toArray(new TypeInfo[this.constructorList.size()]);
        this.currentClassDescription.setConstructorDescription(typeInfoArray);
        this.propertyList = null;
        this.currentBeanInfo = null;
        this.currentClassDescription = null;
    }

    protected void handleAttributeDefinition(String string, String string2, String string3) throws ObjectDescriptionException {
        PropertyInfo propertyInfo = ModelBuilder.createSimplePropertyInfo(this.getPropertyDescriptor(string));
        if (propertyInfo == null) {
            throw new ObjectDescriptionException("Unable to load property " + string);
        }
        propertyInfo.setPropertyType(PropertyType.ATTRIBUTE);
        propertyInfo.setXmlName(string2);
        propertyInfo.setXmlHandler(string3);
        this.propertyList.add(propertyInfo);
    }

    protected void handleConstructorDefinition(String string, String string2) throws ObjectDescriptionException {
        TypeInfo typeInfo = new TypeInfo(string);
        Class clazz = this.loadClass(string2);
        if (clazz == null) {
            throw new ObjectDescriptionException("Failed to load class " + string2);
        }
        typeInfo.setType(this.loadClass(string2));
        this.constructorList.add(typeInfo);
    }

    protected void handleElementDefinition(String string, String string2) throws ObjectDescriptionException {
        PropertyInfo propertyInfo = ModelBuilder.createSimplePropertyInfo(this.getPropertyDescriptor(string));
        if (propertyInfo == null) {
            throw new ObjectDescriptionException("Unable to load property " + string);
        }
        propertyInfo.setPropertyType(PropertyType.ELEMENT);
        propertyInfo.setXmlName(string2);
        propertyInfo.setXmlHandler(null);
        this.propertyList.add(propertyInfo);
    }

    protected void handleLookupDefinition(String string, String string2) throws ObjectDescriptionException {
        PropertyInfo propertyInfo = ModelBuilder.createSimplePropertyInfo(this.getPropertyDescriptor(string));
        if (propertyInfo == null) {
            throw new ObjectDescriptionException("Unable to load property " + string);
        }
        propertyInfo.setPropertyType(PropertyType.LOOKUP);
        propertyInfo.setXmlName(string2);
        propertyInfo.setXmlHandler(null);
        this.propertyList.add(propertyInfo);
    }

    protected PropertyDescriptor getPropertyDescriptor(String string) {
        PropertyDescriptor[] propertyDescriptorArray = this.currentBeanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (!propertyDescriptorArray[i].getName().equals(string)) continue;
            return propertyDescriptorArray[i];
        }
        return null;
    }

    protected void handleIgnoredProperty(String string) {
        this.propertyList.add(new IgnoredPropertyInfo(string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

