/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import org.jfree.xml.generator.DefaultModelReader;
import org.jfree.xml.generator.JavaSourceCollector;
import org.jfree.xml.generator.ModelBuilder;
import org.jfree.xml.generator.ModelWriter;
import org.jfree.xml.generator.SplittingModelWriter;
import org.jfree.xml.generator.model.DescriptionModel;

public class DescriptionGenerator {
    static /* synthetic */ Class class$org$jfree$xml$generator$DescriptionGenerator;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Serializable serializable;
        URL uRL = (class$org$jfree$xml$generator$DescriptionGenerator == null ? (class$org$jfree$xml$generator$DescriptionGenerator = DescriptionGenerator.class$("org.jfree.xml.generator.DescriptionGenerator")) : class$org$jfree$xml$generator$DescriptionGenerator).getResource("generator.properties");
        if (stringArray.length > 0) {
            serializable = new File(stringArray[0]);
            uRL = ((File)serializable).toURL();
        }
        serializable = new Properties();
        try {
            object = new BufferedInputStream(uRL.openStream());
            ((Properties)serializable).load((InputStream)object);
            ((InputStream)object).close();
        }
        catch (Exception exception) {
            System.err.println("Unable to load properties from " + uRL);
        }
        object = ((Properties)serializable).getProperty("sourcedirectory", ".");
        String string = ((Properties)serializable).getProperty("targetfile", "model.xml");
        DescriptionModel descriptionModel = null;
        try {
            descriptionModel = new DefaultModelReader().load(string);
        }
        catch (Exception exception) {
            System.out.println("Unable to load default model. Ignoring...");
        }
        descriptionModel = DescriptionGenerator.generate((String)object, (Properties)serializable, descriptionModel);
        DescriptionGenerator.writeMultiFile(string, descriptionModel);
        System.exit(0);
    }

    public static DescriptionModel generate(String string, Properties properties, DescriptionModel descriptionModel) {
        Object object;
        JavaSourceCollector javaSourceCollector = new JavaSourceCollector(new File(string));
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (((String)object).startsWith("ignore.baseclass.")) {
                javaSourceCollector.addIgnoredBaseClass(properties.getProperty((String)object));
                continue;
            }
            if (!((String)object).startsWith("ignore.package.")) continue;
            javaSourceCollector.addIgnoredPackage(properties.getProperty((String)object));
        }
        javaSourceCollector.collectFiles();
        object = new ModelBuilder();
        return ((ModelBuilder)object).buildModel(javaSourceCollector, descriptionModel);
    }

    public static void writeSingleFile(String string, DescriptionModel descriptionModel) throws IOException {
        System.out.println("Writing ...");
        ModelWriter modelWriter = new ModelWriter();
        modelWriter.setModel(descriptionModel);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        modelWriter.write(bufferedWriter);
        ((Writer)bufferedWriter).close();
    }

    public static void writeMultiFile(String string, DescriptionModel descriptionModel) throws IOException {
        System.out.println("Writing multiple files ...");
        SplittingModelWriter splittingModelWriter = new SplittingModelWriter();
        splittingModelWriter.setModel(descriptionModel);
        splittingModelWriter.write(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

