/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.jfree.xml.generator.SourceCollector;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.MethodInfo;
import org.jfree.xml.generator.model.PropertyInfo;
import org.jfree.xml.generator.model.PropertyType;
import org.jfree.xml.generator.model.TypeInfo;
import org.jfree.xml.util.BasicTypeSupport;

public class ModelBuilder {
    static /* synthetic */ Class class$java$lang$Object;

    public synchronized DescriptionModel buildModel(SourceCollector sourceCollector, DescriptionModel descriptionModel) {
        ClassDescription classDescription;
        Class clazz;
        Object object;
        int n;
        Class[] classArray = sourceCollector.getClasses();
        if (descriptionModel == null) {
            descriptionModel = new DescriptionModel();
        }
        for (n = 0; n < classArray.length; ++n) {
            try {
                object = Introspector.getBeanInfo(classArray[n], class$java$lang$Object == null ? ModelBuilder.class$("java.lang.Object") : class$java$lang$Object);
                clazz = descriptionModel.get(classArray[n]);
                classDescription = this.createClassDescription((BeanInfo)object, (ClassDescription)((Object)clazz));
                if (classDescription == null) continue;
                descriptionModel.addClassDescription(classDescription);
                continue;
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        for (n = 0; n < descriptionModel.size(); ++n) {
            object = descriptionModel.get(n);
            clazz = ((ClassDescription)object).getObjectClass().getSuperclass();
            if (clazz == null || (classDescription = descriptionModel.get(clazz)) == null) continue;
            ((ClassDescription)object).setSuperClass(classDescription.getObjectClass());
        }
        return descriptionModel;
    }

    private ClassDescription createClassDescription(BeanInfo beanInfo, ClassDescription classDescription) {
        Object object;
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyInfo propertyInfo;
            object = propertyDescriptorArray[i];
            if (classDescription != null && (propertyInfo = classDescription.getProperty(((FeatureDescriptor)object).getName())) != null) {
                System.out.println("Ingore predefined property: " + ((FeatureDescriptor)object).getName());
                continue;
            }
            if (propertyDescriptorArray[i] instanceof IndexedPropertyDescriptor || (propertyInfo = ModelBuilder.createSimplePropertyInfo(propertyDescriptorArray[i])) == null) continue;
            arrayList.add(propertyInfo);
        }
        if (arrayList.size() == 0) {
            System.out.println("Ignored class: " + beanInfo.getBeanDescriptor().getBeanClass() + " does not define any properties.");
            return null;
        }
        PropertyInfo[] propertyInfoArray = arrayList.toArray(new PropertyInfo[arrayList.size()]);
        if (classDescription != null) {
            object = classDescription;
        } else {
            object = new ClassDescription(beanInfo.getBeanDescriptor().getBeanClass());
            ((ClassDescription)object).setDescription(beanInfo.getBeanDescriptor().getShortDescription());
        }
        ((ClassDescription)object).setProperties(propertyInfoArray);
        return object;
    }

    public static MethodInfo createMethodInfo(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        MethodInfo methodInfo = new MethodInfo(method.getName());
        Class<?>[] classArray = method.getParameterTypes();
        TypeInfo[] typeInfoArray = new TypeInfo[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            TypeInfo typeInfo = new TypeInfo("param" + i);
            typeInfo.setNullable(true);
            typeInfo.setDescription("generated parameter");
            typeInfo.setType(classArray[i]);
            typeInfoArray[i] = typeInfo;
        }
        methodInfo.setParameters(typeInfoArray);
        methodInfo.setReturnValue(method.getReturnType());
        return methodInfo;
    }

    public static PropertyInfo createSimplePropertyInfo(PropertyDescriptor propertyDescriptor) {
        MethodInfo methodInfo = ModelBuilder.createMethodInfo(propertyDescriptor.getReadMethod());
        MethodInfo methodInfo2 = ModelBuilder.createMethodInfo(propertyDescriptor.getWriteMethod());
        if (methodInfo2 == null || methodInfo == null) {
            return null;
        }
        PropertyInfo propertyInfo = new PropertyInfo(propertyDescriptor.getName());
        propertyInfo.setConstrained(propertyDescriptor.isConstrained());
        propertyInfo.setDescription(propertyDescriptor.getShortDescription());
        propertyInfo.setNullable(true);
        propertyInfo.setPreserve(false);
        propertyInfo.setType(propertyDescriptor.getPropertyType());
        propertyInfo.setReadMethod(methodInfo);
        propertyInfo.setWriteMethod(methodInfo2);
        propertyInfo.setXmlName(propertyDescriptor.getName());
        if (BasicTypeSupport.isBasicDataType(propertyDescriptor.getPropertyType())) {
            propertyInfo.setPropertyType(PropertyType.ATTRIBUTE);
            propertyInfo.setXmlHandler(BasicTypeSupport.getHandlerClass(propertyDescriptor.getPropertyType()));
        } else {
            propertyInfo.setPropertyType(PropertyType.ELEMENT);
        }
        return propertyInfo;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

