/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.xml.util.AttributeDefinition;
import org.jfree.xml.util.BasicTypeSupport;
import org.jfree.xml.util.ConstructorDefinition;
import org.jfree.xml.util.LookupDefinition;
import org.jfree.xml.util.ObjectDescriptionException;
import org.jfree.xml.util.PropertyDefinition;

public final class GenericObjectFactory {
    private ArrayList constructorDefinition;
    private ArrayList propertyDefinition;
    private ArrayList attributeDefinition;
    private ArrayList orderedPropertyNames;
    private ArrayList lookupDefinitions;
    private HashMap propertyInfos;
    private HashMap propertyValues;
    private Class baseClass;
    private String registerName;
    static /* synthetic */ Class class$java$lang$Object;

    public GenericObjectFactory(Class clazz) {
        this.baseClass = clazz;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, class$java$lang$Object == null ? (class$java$lang$Object = GenericObjectFactory.class$("java.lang.Object")) : class$java$lang$Object);
            this.propertyInfos = new HashMap();
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                this.propertyInfos.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new RuntimeException("This is an ugly solution right now ... dirty hack attack");
        }
        this.propertyValues = new HashMap();
        this.orderedPropertyNames = new ArrayList();
        this.constructorDefinition = new ArrayList();
        this.propertyDefinition = new ArrayList();
        this.attributeDefinition = new ArrayList();
        this.lookupDefinitions = new ArrayList();
    }

    private GenericObjectFactory(GenericObjectFactory genericObjectFactory) {
        this.baseClass = genericObjectFactory.baseClass;
        this.propertyValues = new HashMap();
        this.orderedPropertyNames = genericObjectFactory.orderedPropertyNames;
        this.constructorDefinition = genericObjectFactory.constructorDefinition;
        this.propertyDefinition = genericObjectFactory.propertyDefinition;
        this.attributeDefinition = genericObjectFactory.attributeDefinition;
        this.propertyInfos = genericObjectFactory.propertyInfos;
        this.registerName = genericObjectFactory.registerName;
        this.lookupDefinitions = genericObjectFactory.lookupDefinitions;
    }

    public GenericObjectFactory getInstance() {
        return new GenericObjectFactory(this);
    }

    public void setRegisterName(String string) {
        this.registerName = string;
    }

    public String getRegisterName() {
        return this.registerName;
    }

    public void addAttributeDefinition(AttributeDefinition attributeDefinition) {
        if (!this.attributeDefinition.contains(attributeDefinition)) {
            this.attributeDefinition.add(attributeDefinition);
            this.orderedPropertyNames.add(attributeDefinition.getPropertyName());
        }
    }

    public void addPropertyDefinition(PropertyDefinition propertyDefinition) {
        if (!this.propertyDefinition.contains(propertyDefinition)) {
            this.propertyDefinition.add(propertyDefinition);
            this.orderedPropertyNames.add(propertyDefinition.getPropertyName());
        }
    }

    public void addConstructorDefinition(ConstructorDefinition constructorDefinition) {
        if (!this.constructorDefinition.contains(constructorDefinition)) {
            System.out.println("Added Constrcutor: " + constructorDefinition);
            this.constructorDefinition.add(constructorDefinition);
        }
    }

    public void addLookupDefinition(LookupDefinition lookupDefinition) {
        if (!this.lookupDefinitions.contains(lookupDefinition)) {
            System.out.println("Added LookUp: " + lookupDefinition);
            this.lookupDefinitions.add(lookupDefinition);
        }
    }

    public PropertyDescriptor getPropertyDescriptor(String string) {
        return (PropertyDescriptor)this.propertyInfos.get(string);
    }

    public Class getTypeForTagName(String string) throws ObjectDescriptionException {
        PropertyDefinition propertyDefinition = this.getPropertyDefinitionByTagName(string);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(propertyDefinition.getPropertyName());
        if (propertyDescriptor == null) {
            throw new ObjectDescriptionException("Invalid Definition: " + propertyDefinition.getPropertyName());
        }
        return propertyDescriptor.getPropertyType();
    }

    public PropertyDefinition getPropertyDefinitionByPropertyName(String string) throws ObjectDescriptionException {
        for (int i = 0; i < this.propertyDefinition.size(); ++i) {
            PropertyDefinition propertyDefinition = (PropertyDefinition)this.propertyDefinition.get(i);
            if (!propertyDefinition.getPropertyName().equals(string)) continue;
            return propertyDefinition;
        }
        throw new ObjectDescriptionException("This tag is not defined for this kind of object. : " + string);
    }

    public PropertyDefinition getPropertyDefinitionByTagName(String string) throws ObjectDescriptionException {
        for (int i = 0; i < this.propertyDefinition.size(); ++i) {
            PropertyDefinition propertyDefinition = (PropertyDefinition)this.propertyDefinition.get(i);
            if (!propertyDefinition.getElementName().equals(string)) continue;
            return propertyDefinition;
        }
        throw new ObjectDescriptionException("This tag is not defined for this kind of object. : " + string);
    }

    public Iterator getConstructorDefinitions() {
        return Collections.unmodifiableList(this.constructorDefinition).iterator();
    }

    public Iterator getAttributeDefinitions() {
        return Collections.unmodifiableList(this.attributeDefinition).iterator();
    }

    public Iterator getPropertyDefinitions() {
        return Collections.unmodifiableList(this.propertyDefinition).iterator();
    }

    public Iterator getOrderedPropertyNames() {
        return Collections.unmodifiableList(this.orderedPropertyNames).iterator();
    }

    public Iterator getLookupDefinitions() {
        return Collections.unmodifiableList(this.lookupDefinitions).iterator();
    }

    public Object getProperty(String string) {
        return this.propertyValues.get(string);
    }

    public Object createObject() throws ObjectDescriptionException {
        ConstructorDefinition constructorDefinition;
        Class[] classArray = new Class[this.constructorDefinition.size()];
        Object[] objectArray = new Object[this.constructorDefinition.size()];
        for (int i = 0; i < classArray.length; ++i) {
            constructorDefinition = (ConstructorDefinition)this.constructorDefinition.get(i);
            classArray[i] = constructorDefinition.getType();
            objectArray[i] = constructorDefinition.isNull() ? null : this.getProperty(constructorDefinition.getPropertyName());
        }
        try {
            Constructor constructor = this.baseClass.getConstructor(classArray);
            System.out.println("Invoking: " + constructor);
            constructorDefinition = constructor.newInstance(objectArray);
            return constructorDefinition;
        }
        catch (Exception exception) {
            throw new ObjectDescriptionException("Ugh! Constructor made a buuuh!", exception);
        }
    }

    public void setProperty(String string, Object object) throws ObjectDescriptionException {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
        if (propertyDescriptor == null) {
            throw new ObjectDescriptionException("Unknown property " + string);
        }
        if (!this.isAssignableOrPrimitive(propertyDescriptor.getPropertyType(), object.getClass())) {
            throw new ObjectDescriptionException("Invalid value: " + propertyDescriptor.getPropertyType() + " vs. " + object.getClass());
        }
        this.propertyValues.put(string, object);
    }

    private boolean isAssignableOrPrimitive(Class clazz, Class clazz2) {
        if (BasicTypeSupport.isBasicDataType(clazz)) {
            return true;
        }
        return clazz.isAssignableFrom(clazz2);
    }

    private boolean isConstructorProperty(String string) {
        for (int i = 0; i < this.constructorDefinition.size(); ++i) {
            ConstructorDefinition constructorDefinition = (ConstructorDefinition)this.constructorDefinition.get(i);
            if (!string.equals(constructorDefinition.getPropertyName())) continue;
            return true;
        }
        return false;
    }

    public void setObjectProperties(Object object) throws ObjectDescriptionException {
        for (int i = 0; i < this.orderedPropertyNames.size(); ++i) {
            try {
                Object object2;
                String string = (String)this.orderedPropertyNames.get(i);
                if (this.isConstructorProperty(string) || (object2 = this.getProperty(string)) == null) continue;
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
                Method method = propertyDescriptor.getWriteMethod();
                method.invoke(object, object2);
                continue;
            }
            catch (Exception exception) {
                throw new ObjectDescriptionException("Failed to set properties.", exception);
            }
        }
    }

    public void readProperties(Object object) throws ObjectDescriptionException {
        for (int i = 0; i < this.orderedPropertyNames.size(); ++i) {
            try {
                String string = (String)this.orderedPropertyNames.get(i);
                System.out.println("Handle " + string);
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
                Method method = propertyDescriptor.getReadMethod();
                Object object2 = method.invoke(object, new Object[0]);
                if (object2 == null) continue;
                this.setProperty(string, object2);
                continue;
            }
            catch (Exception exception) {
                throw new ObjectDescriptionException("Failed to set properties.", exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

