/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer;

import java.util.ArrayList;
import java.util.Iterator;

public class AttributeList {
    private ArrayList entryList = new ArrayList();

    public Iterator keys() {
        return new AttributeIterator(this.entryList.iterator());
    }

    public synchronized void setAttribute(String string, String string2) {
        AttributeEntry attributeEntry = new AttributeEntry(string, string2);
        int n = this.entryList.indexOf(attributeEntry);
        if (n != -1) {
            this.entryList.remove(n);
        }
        this.entryList.add(attributeEntry);
    }

    public synchronized String getAttribute(String string) {
        return this.getAttribute(string, null);
    }

    public synchronized String getAttribute(String string, String string2) {
        for (int i = 0; i < this.entryList.size(); ++i) {
            AttributeEntry attributeEntry = (AttributeEntry)this.entryList.get(i);
            if (!attributeEntry.getName().equals(string)) continue;
            return attributeEntry.getValue();
        }
        return string2;
    }

    public synchronized void removeAttribute(String string) {
        for (int i = 0; i < this.entryList.size(); ++i) {
            AttributeEntry attributeEntry = (AttributeEntry)this.entryList.get(i);
            if (!attributeEntry.getName().equals(string)) continue;
            this.entryList.remove(attributeEntry);
            return;
        }
    }

    private static class AttributeIterator
    implements Iterator {
        private Iterator backend;

        public AttributeIterator(Iterator iterator) {
            if (iterator == null) {
                throw new NullPointerException();
            }
            this.backend = iterator;
        }

        public boolean hasNext() {
            return this.backend.hasNext();
        }

        public Object next() {
            AttributeEntry attributeEntry = (AttributeEntry)this.backend.next();
            if (attributeEntry != null) {
                return attributeEntry.getName();
            }
            return attributeEntry;
        }

        public void remove() {
            this.backend.remove();
        }
    }

    private static class AttributeEntry {
        private String name;
        private String value;

        public AttributeEntry(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("Name must not be null.");
            }
            if (string2 == null) {
                throw new NullPointerException("Value must not be null.");
            }
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AttributeEntry)) {
                return false;
            }
            AttributeEntry attributeEntry = (AttributeEntry)object;
            return this.name.equals(attributeEntry.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

