/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer.coretypes;

import java.awt.Color;
import java.io.IOException;
import org.jfree.xml.writer.AbstractXmlWriteHandler;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.RootXmlWriteHandler;
import org.jfree.xml.writer.XMLWriter;

public class ColorWriteHandler
extends AbstractXmlWriteHandler {
    public ColorWriteHandler(RootXmlWriteHandler rootXmlWriteHandler) {
        super(rootXmlWriteHandler);
    }

    public void write(String string, Object object, XMLWriter xMLWriter) throws IOException {
        Color color = (Color)object;
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("type", "color");
        attributeList.setAttribute("value", this.encodeColor(color));
        if (color.getAlpha() != 255) {
            attributeList.setAttribute("alpha", String.valueOf(color.getAlpha()));
        }
        xMLWriter.writeTag(string, attributeList, true);
    }

    private String encodeColor(Color color) {
        return "#" + this.encodeInt(color.getRed()) + this.encodeInt(color.getGreen()) + this.encodeInt(color.getBlue());
    }

    private String encodeInt(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }
}

