/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;

public class HTMLContentPane
extends JEditorPane {
    private List<URL> history = new ArrayList<URL>();
    private static String CLASS_NAME = "org.mars_sim.msp.ui.standard.HTMLContentPane";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private int historyIndex;

    public HTMLContentPane() {
        this.setEditable(false);
    }

    public void goToURL(URL url) {
        this.displayPage(url);
        if (this.historyIndex < this.history.size() - 1) {
            ++this.historyIndex;
            this.history.set(this.historyIndex, url);
            while (this.historyIndex < this.history.size() - 1) {
                this.history.remove(this.historyIndex + 1);
            }
        } else {
            this.history.add(url);
            this.historyIndex = this.history.size() - 1;
        }
    }

    public URL forward() {
        ++this.historyIndex;
        if (this.historyIndex >= this.history.size()) {
            this.historyIndex = this.history.size() - 1;
        }
        URL url = this.history.get(this.historyIndex);
        this.displayPage(url);
        return url;
    }

    public URL back() {
        --this.historyIndex;
        if (this.historyIndex < 0) {
            this.historyIndex = 0;
        }
        URL url = this.history.get(this.historyIndex);
        this.displayPage(url);
        return url;
    }

    public boolean isFirst() {
        return this.historyIndex == 0;
    }

    public boolean isLast() {
        return this.historyIndex == this.history.size() - 1;
    }

    private void displayPage(URL pageURL) {
        try {
            this.setPage(pageURL);
        }
        catch (IOException ioException) {
            logger.log(Level.SEVERE, "Attempted to read a bad URL: " + pageURL.toString(), ioException);
        }
    }
}

