/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class ImageLoader {
    private static HashMap<String, ImageIcon> iconCache = new HashMap();
    private static HashMap<String, Image> imageCache = new HashMap();
    private static Toolkit usedToolkit = null;
    public static final String IMAGE_DIR = "/images/";

    private ImageLoader() {
    }

    public static ImageIcon getIcon(String imagename) {
        return ImageLoader.getIcon(imagename, "png");
    }

    public static ImageIcon getIcon(String imagename, String ext) {
        String fullImageName = imagename + "." + ext;
        ImageIcon found = iconCache.get(fullImageName);
        if (found == null) {
            String fileName = IMAGE_DIR + fullImageName;
            URL resource = ImageLoader.class.getResource(fileName);
            found = new ImageIcon(resource);
            iconCache.put(fullImageName, found);
        }
        return found;
    }

    public static Image getImage(String imagename) {
        Image newImage = imageCache.get(imagename);
        if (newImage == null) {
            if (usedToolkit == null) {
                usedToolkit = Toolkit.getDefaultToolkit();
            }
            URL imageURL = ImageLoader.class.getResource(IMAGE_DIR + imagename);
            newImage = usedToolkit.createImage(imageURL);
            imageCache.put(imagename, newImage);
        }
        return newImage;
    }
}

