/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.ui.swing.AnnouncementWindow;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopManager;
import org.mars_sim.msp.ui.swing.MainWindow;
import org.mars_sim.msp.ui.swing.UIConfig;
import org.mars_sim.msp.ui.swing.sound.AudioPlayer;
import org.mars_sim.msp.ui.swing.tool.ToolWindow;
import org.mars_sim.msp.ui.swing.tool.guide.GuideWindow;
import org.mars_sim.msp.ui.swing.tool.mission.MissionWindow;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorWindow;
import org.mars_sim.msp.ui.swing.tool.monitor.UnitTableModel;
import org.mars_sim.msp.ui.swing.tool.navigator.NavigatorWindow;
import org.mars_sim.msp.ui.swing.tool.preferences.PreferencesWindow;
import org.mars_sim.msp.ui.swing.tool.resupply.ResupplyWindow;
import org.mars_sim.msp.ui.swing.tool.science.ScienceWindow;
import org.mars_sim.msp.ui.swing.tool.search.SearchWindow;
import org.mars_sim.msp.ui.swing.tool.settlement.SettlementWindow;
import org.mars_sim.msp.ui.swing.tool.time.TimeWindow;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfoFactory;
import org.mars_sim.msp.ui.swing.unit_window.UnitWindow;
import org.mars_sim.msp.ui.swing.unit_window.UnitWindowFactory;
import org.mars_sim.msp.ui.swing.unit_window.UnitWindowListener;

public class MainDesktopPane
extends JDesktopPane
implements ComponentListener {
    private static String CLASS_NAME = MainDesktopPane.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private final Collection<UnitWindow> unitWindows;
    private final Collection<ToolWindow> toolWindows;
    private final MainWindow mainWindow;
    private final ImageIcon backgroundImageIcon;
    private final JLabel backgroundLabel;
    private boolean firstDisplay;
    private final UpdateThread updateThread;
    private final AudioPlayer soundPlayer = new AudioPlayer();
    private final AnnouncementWindow announcementWindow;

    public MainDesktopPane(MainWindow mainWindow) {
        this.soundPlayer.play("audio/splash.wav");
        this.mainWindow = mainWindow;
        this.unitWindows = new ArrayList<UnitWindow>();
        this.toolWindows = new ArrayList<ToolWindow>();
        this.setBackground(Color.black);
        this.setDesktopManager(new MainDesktopManager());
        this.addComponentListener(this);
        this.backgroundImageIcon = new ImageIcon();
        this.backgroundLabel = new JLabel(this.backgroundImageIcon);
        this.add((Component)this.backgroundLabel, Integer.MIN_VALUE);
        this.backgroundLabel.setLocation(0, 0);
        this.moveToBack(this.backgroundLabel);
        this.firstDisplay = true;
        this.prepareToolWindows();
        this.announcementWindow = new AnnouncementWindow(this);
        try {
            this.announcementWindow.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.updateThread = new UpdateThread(this);
        this.updateThread.setRun(true);
        this.updateThread.start();
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.firstDisplay) {
            ImageIcon baseImageIcon = ImageLoader.getIcon("background");
            Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
            Image backgroundImage = this.createImage((int)screen_size.getWidth(), (int)screen_size.getHeight());
            Graphics backgroundGraphics = backgroundImage.getGraphics();
            for (int x = 0; x < backgroundImage.getWidth(this); x += baseImageIcon.getIconWidth()) {
                for (int y = 0; y < backgroundImage.getHeight(this); y += baseImageIcon.getIconHeight()) {
                    backgroundGraphics.drawImage(baseImageIcon.getImage(), x, y, this);
                }
            }
            this.backgroundImageIcon.setImage(backgroundImage);
            this.backgroundLabel.setSize(this.getSize());
            this.firstDisplay = false;
        }
        this.backgroundLabel.setSize(this.getSize());
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private void prepareToolWindows() {
        this.toolWindows.clear();
        NavigatorWindow navWindow = new NavigatorWindow(this);
        try {
            navWindow.setClosed(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this.toolWindows.add(navWindow);
        SearchWindow searchWindow = new SearchWindow(this);
        try {
            searchWindow.setClosed(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this.toolWindows.add(searchWindow);
        TimeWindow timeWindow = new TimeWindow(this);
        try {
            timeWindow.setClosed(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this.toolWindows.add(timeWindow);
        MonitorWindow monitorWindow = new MonitorWindow(this);
        try {
            monitorWindow.setClosed(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this.toolWindows.add(monitorWindow);
        PreferencesWindow prefsWindow = new PreferencesWindow(this);
        try {
            prefsWindow.setClosed(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this.toolWindows.add(prefsWindow);
        MissionWindow missionWindow = new MissionWindow(this);
        try {
            missionWindow.setClosed(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this.toolWindows.add(missionWindow);
        SettlementWindow settlementWindow = new SettlementWindow(this);
        try {
            settlementWindow.setClosed(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this.toolWindows.add(settlementWindow);
        ScienceWindow scienceWindow = new ScienceWindow(this);
        try {
            scienceWindow.setClosed(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this.toolWindows.add(scienceWindow);
        ResupplyWindow resupplyWindow = new ResupplyWindow(this);
        try {
            resupplyWindow.setClosed(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this.toolWindows.add(resupplyWindow);
        GuideWindow guideWindow = new GuideWindow(this);
        try {
            guideWindow.setClosed(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this.toolWindows.add(guideWindow);
    }

    public ToolWindow getToolWindow(String toolName) {
        ToolWindow result = null;
        for (ToolWindow window : this.toolWindows) {
            if (!toolName.equals(window.getToolName())) continue;
            result = window;
        }
        return result;
    }

    public void addModel(UnitTableModel model) {
        ((MonitorWindow)this.getToolWindow("Monitor Tool")).displayModel(model);
        this.openToolWindow("Monitor Tool");
    }

    public void centerMapGlobe(Coordinates targetLocation) {
        ((NavigatorWindow)this.getToolWindow("Mars Navigator")).updateCoords(targetLocation);
        this.openToolWindow("Mars Navigator");
    }

    public boolean isToolWindowOpen(String toolName) {
        ToolWindow window = this.getToolWindow(toolName);
        if (window != null) {
            return !window.isClosed();
        }
        return false;
    }

    public void openToolWindow(String toolName) {
        ToolWindow window = this.getToolWindow(toolName);
        if (window != null) {
            if (window.isClosed()) {
                if (!window.wasOpened()) {
                    UIConfig config = UIConfig.INSTANCE;
                    if (config.useUIDefault()) {
                        window.setLocation(this.getCenterLocation(window));
                    } else if (config.isInternalWindowConfigured(toolName)) {
                        window.setLocation(config.getInternalWindowLocation(toolName));
                        if (window.isResizable()) {
                            window.setSize(config.getInternalWindowDimension(toolName));
                        }
                    } else {
                        window.setLocation(this.getRandomLocation(window));
                    }
                    window.setWasOpened(true);
                }
                this.add((Component)window, 0);
                try {
                    window.setClosed(false);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.toString());
                }
            }
            window.show();
            try {
                window.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void closeToolWindow(String toolName) {
        ToolWindow window = this.getToolWindow(toolName);
        if (window != null && !window.isClosed()) {
            try {
                window.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void openUnitWindow(Unit unit, boolean initialWindow) {
        JInternalFrame tempWindow = null;
        for (UnitWindow window : this.unitWindows) {
            if (window.getUnit() != unit) continue;
            tempWindow = window;
        }
        if (tempWindow != null) {
            if (tempWindow.isClosed()) {
                this.add((Component)tempWindow, 0);
            }
            try {
                tempWindow.setIcon(false);
            }
            catch (PropertyVetoException e) {
                logger.log(Level.SEVERE, "Problem reopening " + e);
            }
        } else {
            tempWindow = UnitWindowFactory.getUnitWindow(unit, this);
            this.add((Component)tempWindow, 0);
            tempWindow.pack();
            tempWindow.addInternalFrameListener(new UnitWindowListener(this));
            if (initialWindow) {
                tempWindow.setLocation(UIConfig.INSTANCE.getInternalWindowLocation(unit.getName()));
            } else {
                tempWindow.setLocation(this.getRandomLocation(tempWindow));
            }
            this.unitWindows.add((UnitWindow)tempWindow);
            this.mainWindow.createUnitButton(unit);
        }
        tempWindow.setVisible(true);
        try {
            tempWindow.setSelected(true);
            tempWindow.moveToFront();
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        String soundFilePath = UnitDisplayInfoFactory.getUnitDisplayInfo(unit).getSound(unit);
        if (soundFilePath != null && soundFilePath.length() != 0) {
            soundFilePath = "audio/" + soundFilePath;
        }
        this.soundPlayer.play(soundFilePath);
    }

    public UnitWindow findUnitWindow(Unit unit) {
        UnitWindow result = null;
        for (UnitWindow window : this.unitWindows) {
            if (window.getUnit() != unit) continue;
            result = window;
        }
        return result;
    }

    public void disposeUnitWindow(Unit unit) {
        JInternalFrame deadWindow = null;
        for (UnitWindow window : this.unitWindows) {
            if (unit != window.getUnit()) continue;
            deadWindow = window;
        }
        this.unitWindows.remove(deadWindow);
        if (deadWindow != null) {
            deadWindow.dispose();
        }
        this.mainWindow.disposeUnitButton(unit);
    }

    public void disposeUnitWindow(UnitWindow window) {
        if (window != null) {
            this.unitWindows.remove(window);
            window.dispose();
            this.mainWindow.disposeUnitButton(window.getUnit());
        }
    }

    private void update() {
        Iterator<UnitWindow> i1 = this.unitWindows.iterator();
        try {
            while (i1.hasNext()) {
                i1.next().update();
            }
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        Iterator<ToolWindow> i2 = this.toolWindows.iterator();
        try {
            while (i2.hasNext()) {
                i2.next().update();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    void clearDesktop() {
        this.updateThread.setRun(false);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (UnitWindow window : this.unitWindows) {
            window.dispose();
            this.mainWindow.disposeUnitButton(window.getUnit());
            window.destroy();
        }
        this.unitWindows.clear();
        for (ToolWindow window : this.toolWindows) {
            window.dispose();
            window.destroy();
        }
        this.toolWindows.clear();
    }

    void resetDesktop() {
        this.prepareToolWindows();
        this.updateThread.setRun(true);
    }

    private Point getCenterLocation(JInternalFrame tempWindow) {
        Dimension desktop_size = this.getSize();
        Dimension window_size = tempWindow.getSize();
        int rX = (int)Math.round((double)(desktop_size.width - window_size.width) / 2.0);
        int rY = (int)Math.round((double)(desktop_size.height - window_size.height) / 2.0);
        if (rY < 0) {
            rY = 0;
        }
        return new Point(rX, rY);
    }

    private Point getRandomLocation(JInternalFrame tempWindow) {
        Dimension desktop_size = this.getSize();
        Dimension window_size = tempWindow.getSize();
        int rX = (int)Math.round(Math.random() * (double)(desktop_size.width - window_size.width));
        int rY = (int)Math.round(Math.random() * (double)(desktop_size.height - window_size.height));
        if (rY < 0) {
            rY = 0;
        }
        return new Point(rX, rY);
    }

    public AudioPlayer getSoundPlayer() {
        return this.soundPlayer;
    }

    public void openAnnouncementWindow(String announcement) {
        this.announcementWindow.setAnnouncement(announcement);
        this.announcementWindow.pack();
        this.add((Component)this.announcementWindow, 0);
        int Xloc = (this.getWidth() - this.announcementWindow.getWidth()) / 2;
        int Yloc = (this.getHeight() - this.announcementWindow.getHeight()) / 2;
        this.announcementWindow.setLocation(Xloc, Yloc);
        this.announcementWindow.pack();
        this.announcementWindow.setVisible(true);
    }

    public void disposeAnnouncementWindow() {
        this.announcementWindow.dispose();
    }

    void updateToolWindowLF() {
        for (ToolWindow toolWindow : this.toolWindows) {
            SwingUtilities.updateComponentTreeUI(toolWindow);
            toolWindow.pack();
        }
    }

    void openInitialWindows() {
        UIConfig config = UIConfig.INSTANCE;
        if (config.useUIDefault()) {
            this.openToolWindow("Mars Navigator");
            this.getToolWindow("Mars Navigator").setLocation(0, 0);
            this.openToolWindow("Help");
            GuideWindow ourGuide = (GuideWindow)this.getToolWindow("Help");
            ourGuide.setURL("/docs/help/tutorial1.html");
        } else {
            List<String> windowNames = config.getInternalWindowNames();
            int num = windowNames.size();
            for (int x = 0; x < num; ++x) {
                Unit unit;
                String highestZName = null;
                int highestZ = Integer.MIN_VALUE;
                for (String name : windowNames) {
                    int zOrder;
                    boolean display = config.isInternalWindowDisplayed(name);
                    String type = config.getInternalWindowType(name);
                    if ("unit".equals(type) && !Simulation.instance().isDefaultLoad()) {
                        display = false;
                    }
                    if (!display || (zOrder = config.getInternalWindowZOrder(name)) <= highestZ) continue;
                    highestZName = name;
                    highestZ = zOrder;
                }
                if (highestZName == null) continue;
                String type = config.getInternalWindowType(highestZName);
                if ("tool".equals(type)) {
                    this.openToolWindow(highestZName);
                } else if ("unit".equals(type) && (unit = Simulation.instance().getUnitManager().findUnit(highestZName)) != null) {
                    this.openUnitWindow(unit, true);
                }
                windowNames.remove(highestZName);
            }
            if (Simulation.instance().isDefaultLoad()) {
                for (String name : config.getInternalWindowNames()) {
                    Unit unit;
                    if (!"unit".equals(config.getInternalWindowType(name)) || config.isInternalWindowDisplayed(name) || (unit = Simulation.instance().getUnitManager().findUnit(name)) == null) continue;
                    this.mainWindow.createUnitButton(unit);
                }
            }
        }
    }

    private class UpdateThread
    extends Thread {
        public static final long SLEEP_TIME = 1000L;
        MainDesktopPane desktop;
        boolean run;

        private UpdateThread(MainDesktopPane desktop) {
            super("Desktop update thread");
            this.run = false;
            this.desktop = desktop;
        }

        private void setRun(boolean run) {
            this.run = run;
        }

        @Override
        public void run() {
            while (true) {
                if (this.run) {
                    this.desktop.update();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

