/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.time.MasterClock;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MainWindowMenu;
import org.mars_sim.msp.ui.swing.ToolToolBar;
import org.mars_sim.msp.ui.swing.UIConfig;
import org.mars_sim.msp.ui.swing.UnitToolBar;
import org.mars_sim.msp.ui.swing.configeditor.TempSimulationConfigEditor;

public class MainWindow {
    public static final String WINDOW_TITLE = "Mars Simulation Project (version 3.05)";
    private static Logger logger = Logger.getLogger(MainWindow.class.getName());
    private JFrame frame = new JFrame("Mars Simulation Project (version 3.05)");
    private final UnitToolBar unitToolbar;
    private final ToolToolBar toolToolbar;
    private final MainDesktopPane desktop;
    private Thread newSimThread;
    private Thread loadSimThread;
    private Thread saveSimThread;

    public MainWindow(boolean cleanUI) {
        if (!cleanUI) {
            UIConfig.INSTANCE.parseFile();
        }
        boolean useDefault = UIConfig.INSTANCE.useUIDefault();
        this.setLookAndFeel(false);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                MainWindow.this.exitSimulation();
            }
        });
        this.frame.setJMenuBar(new MainWindowMenu(this));
        JPanel mainPane = new JPanel(new BorderLayout());
        this.frame.setContentPane(mainPane);
        this.toolToolbar = new ToolToolBar(this);
        mainPane.add((Component)this.toolToolbar, "North");
        this.unitToolbar = new UnitToolBar(this);
        mainPane.add((Component)this.unitToolbar, "South");
        this.unitToolbar.setVisible(UIConfig.INSTANCE.showUnitBar());
        this.toolToolbar.setVisible(UIConfig.INSTANCE.showToolBar());
        this.desktop = new MainDesktopPane(this);
        mainPane.add((Component)this.desktop, "Center");
        Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frame_size = useDefault ? (screen_size.width > 800 ? new Dimension((int)Math.round(screen_size.getWidth() * 0.9), (int)Math.round(screen_size.getHeight() * 0.9)) : new Dimension(screen_size)) : UIConfig.INSTANCE.getMainWindowDimension();
        this.frame.setSize(frame_size);
        if (useDefault) {
            this.frame.setLocation((screen_size.width - frame_size.width) / 2, (screen_size.height - frame_size.height) / 2);
        } else {
            this.frame.setLocation(UIConfig.INSTANCE.getMainWindowLocation());
        }
        this.frame.setVisible(true);
        this.desktop.openInitialWindows();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public MainDesktopPane getDesktop() {
        return this.desktop;
    }

    public void loadSimulation() {
        if (this.loadSimThread == null || !this.loadSimThread.isAlive()) {
            this.loadSimThread = new Thread("Load Simulation Thread"){

                @Override
                public void run() {
                    MainWindow.this.loadSimulationProcess();
                }
            };
            this.loadSimThread.start();
        } else {
            this.loadSimThread.interrupt();
        }
    }

    private void loadSimulationProcess() {
        JFileChooser chooser = new JFileChooser(Simulation.DEFAULT_DIR);
        chooser.setDialogTitle("Select stored simulation");
        if (chooser.showOpenDialog(this.frame) == 0) {
            this.desktop.openAnnouncementWindow("Loading simulation...");
            this.desktop.clearDesktop();
            MasterClock clock = Simulation.instance().getMasterClock();
            clock.loadSimulation(chooser.getSelectedFile());
            while (clock.isLoadingSimulation()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "the wait while loading sleep was interrupted", e);
                }
            }
            this.desktop.resetDesktop();
            this.desktop.disposeAnnouncementWindow();
            this.desktop.openToolWindow("Mars Navigator");
        }
    }

    public void newSimulation() {
        if (this.newSimThread == null || !this.newSimThread.isAlive()) {
            this.newSimThread = new Thread("New simulation Thread"){

                @Override
                public void run() {
                    MainWindow.this.newSimulationProcess();
                }
            };
            this.newSimThread.start();
        } else {
            this.newSimThread.interrupt();
        }
    }

    private void newSimulationProcess() {
        if (JOptionPane.showConfirmDialog(this.desktop, "Do you really want to create a new simulation and abandon the current running?", UIManager.getString("OptionPane.titleText"), 0) == 0) {
            this.desktop.openAnnouncementWindow("Creating new simulation...");
            Simulation.stopSimulation();
            try {
                this.desktop.clearDesktop();
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
                e.printStackTrace(System.err);
            }
            SimulationConfig.loadConfig();
            TempSimulationConfigEditor editor = new TempSimulationConfigEditor(this.frame.getOwner(), SimulationConfig.instance());
            editor.setVisible(true);
            Simulation.createNewSimulation();
            Simulation.instance().start();
            try {
                this.desktop.resetDesktop();
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
                e.printStackTrace(System.err);
            }
            this.desktop.disposeAnnouncementWindow();
            this.desktop.openToolWindow("Mars Navigator");
        }
    }

    public void saveSimulation(final boolean useDefault) {
        if (this.saveSimThread == null || !this.saveSimThread.isAlive()) {
            this.saveSimThread = new Thread("Save Simulation Thread"){

                @Override
                public void run() {
                    MainWindow.this.saveSimulationProcess(useDefault);
                }
            };
            this.saveSimThread.start();
        } else {
            this.saveSimThread.interrupt();
        }
    }

    private void saveSimulationProcess(boolean useDefault) {
        File fileLocn = null;
        if (!useDefault) {
            JFileChooser chooser = new JFileChooser(Simulation.DEFAULT_DIR);
            chooser.setDialogTitle("Select save location");
            if (chooser.showSaveDialog(this.frame) == 0) {
                fileLocn = chooser.getSelectedFile();
            } else {
                return;
            }
        }
        this.desktop.openAnnouncementWindow("Saving simulation...");
        MasterClock clock = Simulation.instance().getMasterClock();
        clock.saveSimulation(fileLocn);
        while (clock.isSavingSimulation()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Sleep while saving simulation was interrupted", e);
            }
        }
        this.desktop.disposeAnnouncementWindow();
    }

    public void pauseSimulation() {
        this.desktop.openAnnouncementWindow("Pausing simulation");
        Simulation.instance().getMasterClock().setPaused(true);
    }

    public void unpauseSimulation() {
        Simulation.instance().getMasterClock().setPaused(false);
        this.desktop.disposeAnnouncementWindow();
    }

    public void createUnitButton(Unit unit) {
        this.unitToolbar.createUnitButton(unit);
    }

    public void disposeUnitButton(Unit unit) {
        this.unitToolbar.disposeUnitButton(unit);
    }

    public void exitSimulation() {
        UIConfig.INSTANCE.saveFile(this);
        Simulation sim = Simulation.instance();
        try {
            sim.getMasterClock().saveSimulation(null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem saving simulation " + e);
            e.printStackTrace(System.err);
        }
        sim.getMasterClock().exitProgram();
    }

    public void setLookAndFeel(boolean nativeLookAndFeel) {
        boolean changed = false;
        if (nativeLookAndFeel) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                changed = true;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not load system look&feel", e);
            }
        } else {
            try {
                boolean foundNimbus = false;
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!info.getName().equals("Nimbus")) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    foundNimbus = true;
                    changed = true;
                    break;
                }
                if (!foundNimbus) {
                    logger.log(Level.WARNING, "Could not set Nimbus Look&Feel, make sure you have a recent JRE 1.6 update or 1.7");
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                    changed = true;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not set Nimbus Look&Feel, make sure you have a recent JRE 1.6 update or 1.7", e);
            }
        }
        if (changed) {
            SwingUtilities.updateComponentTreeUI(this.frame);
            if (this.desktop != null) {
                this.desktop.updateToolWindowLF();
            }
        }
    }

    public UnitToolBar getUnitToolBar() {
        return this.unitToolbar;
    }

    public ToolToolBar getToolToolBar() {
        return this.toolToolbar;
    }
}

