/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class SVGLoader {
    private static Map<String, GraphicsNode> svgCache;
    public static final String SVG_DIR = "/svg/";

    private SVGLoader() {
    }

    public static GraphicsNode getSVGImage(String name) {
        GraphicsNode found;
        if (svgCache == null) {
            svgCache = new HashMap<String, GraphicsNode>();
        }
        if ((found = svgCache.get(name)) == null) {
            String fileName = SVG_DIR + name;
            URL resource = SVGLoader.class.getResource(fileName);
            try {
                String xmlParser = XMLResourceDescriptor.getXMLParserClassName();
                SAXSVGDocumentFactory df = new SAXSVGDocumentFactory(xmlParser);
                SVGDocument doc = df.createSVGDocument(resource.toString());
                UserAgentAdapter userAgent = new UserAgentAdapter();
                DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
                BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
                ctx.setDynamicState(2);
                GVTBuilder builder = new GVTBuilder();
                found = builder.build(ctx, (Document)doc);
                svgCache.put(name, found);
            }
            catch (Exception e) {
                System.err.println("getSVGImage error: " + fileName);
                e.printStackTrace(System.err);
            }
        }
        return found;
    }
}

