/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.ui.swing.ImageLoader;

public class SplashWindow {
    private JFrame window = new JFrame(){

        @Override
        public void paint(Graphics g) {
            g.drawImage(SplashWindow.this.splashImage, 0, 0, this);
        }
    };
    private static String[] IMAGE_NAMES = new String[]{"SplashImage.png", "SplashImage2.jpg", "SplashImage3.jpg"};
    private Image splashImage;
    private int width;
    private int height;

    public SplashWindow() {
        String imageName = IMAGE_NAMES[RandomUtil.getRandomInt((int)(IMAGE_NAMES.length - 1))];
        this.splashImage = ImageLoader.getImage(imageName);
        ImageIcon splashIcon = new ImageIcon(this.splashImage);
        this.width = splashIcon.getIconWidth();
        this.height = splashIcon.getIconHeight();
        this.window.setSize(this.width, this.height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = new Dimension(this.width, this.height);
        this.window.setLocation((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
        this.window.setBackground(Color.black);
        this.window.setUndecorated(true);
        this.window.setVisible(true);
    }

    public void show() {
        this.window.setVisible(true);
    }

    public void hide() {
        this.window.dispose();
    }

    public JFrame getJFrame() {
        return this.window;
    }
}

