/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import org.mars_sim.msp.ui.swing.MainWindow;
import org.mars_sim.msp.ui.swing.ToolButton;

public class ToolToolBar
extends JToolBar
implements ActionListener {
    private Vector<ToolButton> toolButtons = new Vector();
    private MainWindow parentMainWindow;

    public ToolToolBar(MainWindow parentMainWindow) {
        super(0);
        this.parentMainWindow = parentMainWindow;
        this.setName("Tool Toolbar");
        this.setFloatable(false);
        this.prepareToolButtons();
        this.setBorder(new BevelBorder(0));
    }

    private void prepareToolButtons() {
        ToolButton newButton = new ToolButton("New", "New");
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolToolBar.this.parentMainWindow.newSimulation();
            }
        });
        this.add(newButton);
        ToolButton openButton = new ToolButton("Open...", "Open");
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolToolBar.this.parentMainWindow.loadSimulation();
            }
        });
        this.add(openButton);
        ToolButton saveButton = new ToolButton("Save", "Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolToolBar.this.parentMainWindow.saveSimulation(true);
            }
        });
        this.add(saveButton);
        ToolButton saveAsButton = new ToolButton("Save As...", "SaveAs");
        saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolToolBar.this.parentMainWindow.saveSimulation(false);
            }
        });
        this.add(saveAsButton);
        ToolButton exitButton = new ToolButton("Exit", "Exit");
        exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolToolBar.this.parentMainWindow.exitSimulation();
            }
        });
        this.add(exitButton);
        this.addSeparator();
        ToolButton navButton = new ToolButton("Mars Navigator", "Planet");
        navButton.addActionListener(this);
        this.add(navButton);
        this.toolButtons.addElement(navButton);
        ToolButton searchButton = new ToolButton("Search Tool", "Find");
        searchButton.addActionListener(this);
        this.add(searchButton);
        this.toolButtons.addElement(searchButton);
        ToolButton timeButton = new ToolButton("Time Tool", "Time");
        timeButton.addActionListener(this);
        this.add(timeButton);
        this.toolButtons.addElement(timeButton);
        ToolButton monitorButton = new ToolButton("Monitor Tool", "Monitor");
        monitorButton.addActionListener(this);
        this.add(monitorButton);
        this.toolButtons.addElement(monitorButton);
        ToolButton prefsButton = new ToolButton("Preferences Tool", "Preferences");
        prefsButton.addActionListener(this);
        this.add(prefsButton);
        this.toolButtons.addElement(prefsButton);
        ToolButton missionButton = new ToolButton("Mission Tool", "Mission");
        missionButton.addActionListener(this);
        this.add(missionButton);
        this.toolButtons.addElement(missionButton);
        ToolButton settlementButton = new ToolButton("Settlement Map Tool", "SettlementMapTool");
        settlementButton.addActionListener(this);
        this.add(settlementButton);
        this.toolButtons.addElement(settlementButton);
        ToolButton scienceButton = new ToolButton("Science Tool", "Science");
        scienceButton.addActionListener(this);
        this.add(scienceButton);
        this.toolButtons.addElement(scienceButton);
        ToolButton resupplyButton = new ToolButton("Resupply Tool", "Resupply");
        resupplyButton.addActionListener(this);
        this.add(resupplyButton);
        this.toolButtons.addElement(resupplyButton);
        this.addSeparator();
        ToolButton guideButton = new ToolButton("Help", "Guide");
        guideButton.addActionListener(this);
        this.add(guideButton);
        this.toolButtons.addElement(guideButton);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.parentMainWindow.getDesktop().openToolWindow(((ToolButton)event.getSource()).getToolName());
    }
}

