/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.ui.swing.MainWindow;
import org.mars_sim.msp.ui.swing.UnitButton;

public class UnitToolBar
extends JToolBar
implements ActionListener {
    private List<UnitButton> unitButtons = new ArrayList<UnitButton>();
    private MainWindow parentMainWindow;

    public UnitToolBar(MainWindow parentMainWindow) {
        this.parentMainWindow = parentMainWindow;
        this.setName("Unit Toolbar");
        this.setFloatable(false);
        this.setPreferredSize(new Dimension(0, 57));
        this.setBorder(new BevelBorder(0));
    }

    public void createUnitButton(Unit unit) {
        boolean alreadyExists = false;
        for (UnitButton unitButton : this.unitButtons) {
            if (unitButton.getUnit() != unit) continue;
            alreadyExists = true;
        }
        if (!alreadyExists) {
            UnitButton tempButton = new UnitButton(unit);
            tempButton.addActionListener(this);
            this.add(tempButton);
            this.validate();
            this.repaint();
            this.unitButtons.add(tempButton);
        }
    }

    public void disposeUnitButton(Unit unit) {
        Iterator<UnitButton> i = this.unitButtons.iterator();
        while (i.hasNext()) {
            UnitButton unitButton = i.next();
            if (unitButton.getUnit() != unit) continue;
            this.remove(unitButton);
            this.validate();
            this.repaint();
            i.remove();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Unit unit = ((UnitButton)event.getSource()).getUnit();
        this.parentMainWindow.getDesktop().openUnitWindow(unit, false);
    }

    public Unit[] getUnitsInToolBar() {
        Unit[] result = new Unit[this.unitButtons.size()];
        for (int x = 0; x < this.unitButtons.size(); ++x) {
            result[x] = this.unitButtons.get(x).getUnit();
        }
        return result;
    }
}

