/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.configeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.structure.SettlementConfig;
import org.mars_sim.msp.core.structure.SettlementTemplate;

public class TempSimulationConfigEditor
extends JDialog {
    private static Logger logger = Logger.getLogger(TempSimulationConfigEditor.class.getName());
    private SimulationConfig config;
    private SettlementTableModel settlementTableModel;
    private JTable settlementTable;
    private boolean hasError;
    private JLabel errorLabel;
    private JButton createButton;

    public TempSimulationConfigEditor(Window owner, SimulationConfig config) {
        super(owner, "Simulation Configuration Editor", Dialog.ModalityType.APPLICATION_MODAL);
        this.config = config;
        this.hasError = false;
        JPanel contentPanel = new JPanel(new BorderLayout(10, 10));
        contentPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(contentPanel);
        JLabel titleLabel = new JLabel("Choose settlements for the new simulation:", 0);
        this.add((Component)titleLabel, "North");
        JScrollPane settlementScrollPane = new JScrollPane();
        settlementScrollPane.setPreferredSize(new Dimension(585, 200));
        this.add((Component)settlementScrollPane, "Center");
        this.settlementTableModel = new SettlementTableModel();
        this.settlementTable = new JTable(this.settlementTableModel);
        this.settlementTable.setRowSelectionAllowed(true);
        this.settlementTable.setSelectionMode(2);
        this.settlementTable.getColumnModel().getColumn(0).setPreferredWidth(125);
        this.settlementTable.getColumnModel().getColumn(1).setPreferredWidth(205);
        this.settlementTable.getColumnModel().getColumn(2).setPreferredWidth(85);
        this.settlementTable.getColumnModel().getColumn(3).setPreferredWidth(85);
        this.settlementTable.getColumnModel().getColumn(4).setPreferredWidth(85);
        settlementScrollPane.setViewportView(this.settlementTable);
        TableColumn templateColumn = this.settlementTable.getColumnModel().getColumn(1);
        JComboBox<String> templateCB = new JComboBox<String>();
        SettlementConfig settlementConfig = config.getSettlementConfiguration();
        Iterator i = settlementConfig.getSettlementTemplates().iterator();
        while (i.hasNext()) {
            templateCB.addItem(((SettlementTemplate)i.next()).getTemplateName());
        }
        templateColumn.setCellEditor(new DefaultCellEditor(templateCB));
        JPanel configurationButtonOuterPanel = new JPanel(new BorderLayout(0, 0));
        this.add((Component)configurationButtonOuterPanel, "East");
        JPanel configurationButtonInnerTopPanel = new JPanel(new GridLayout(2, 1));
        configurationButtonOuterPanel.add((Component)configurationButtonInnerTopPanel, "North");
        JButton addButton = new JButton("Add");
        addButton.setToolTipText("Add a new settlement");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TempSimulationConfigEditor.this.addNewSettlement();
            }
        });
        configurationButtonInnerTopPanel.add(addButton);
        JButton removeButton = new JButton("Remove");
        removeButton.setToolTipText("Remove selected settlements");
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TempSimulationConfigEditor.this.removeSelectedSettlements();
            }
        });
        configurationButtonInnerTopPanel.add(removeButton);
        JPanel configurationButtonInnerBottomPanel = new JPanel(new GridLayout(1, 1));
        configurationButtonOuterPanel.add((Component)configurationButtonInnerBottomPanel, "South");
        JButton defaultButton = new JButton("Default");
        defaultButton.setToolTipText("Reset to default settlements");
        defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TempSimulationConfigEditor.this.setDefaultSettlements();
            }
        });
        configurationButtonInnerBottomPanel.add(defaultButton);
        JPanel bottomPanel = new JPanel(new BorderLayout(0, 0));
        this.add((Component)bottomPanel, "South");
        this.errorLabel = new JLabel("", 0);
        this.errorLabel.setForeground(Color.RED);
        bottomPanel.add((Component)this.errorLabel, "North");
        JPanel bottomButtonPanel = new JPanel(new FlowLayout(1));
        bottomPanel.add((Component)bottomButtonPanel, "South");
        this.createButton = new JButton("Create New Simulation");
        this.createButton.setToolTipText("Create a new simulation");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableCellEditor editor = TempSimulationConfigEditor.this.settlementTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                }
                if (!TempSimulationConfigEditor.this.hasError) {
                    TempSimulationConfigEditor.this.setConfiguration();
                    TempSimulationConfigEditor.this.closeWindow();
                }
            }
        });
        bottomButtonPanel.add(this.createButton);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
    }

    private void addNewSettlement() {
        SettlementInfo settlement = this.determineNewSettlementConfiguration();
        this.settlementTableModel.addSettlement(settlement);
    }

    private void removeSelectedSettlements() {
        this.settlementTableModel.removeSettlements(this.settlementTable.getSelectedRows());
    }

    private void setDefaultSettlements() {
        this.settlementTableModel.loadDefaultSettlements();
    }

    private void setConfiguration() {
        SettlementConfig settlementConfig = this.config.getSettlementConfiguration();
        settlementConfig.clearInitialSettlements();
        for (int x = 0; x < this.settlementTableModel.getRowCount(); ++x) {
            String name = (String)this.settlementTableModel.getValueAt(x, 0);
            String template = (String)this.settlementTableModel.getValueAt(x, 1);
            String population = (String)this.settlementTableModel.getValueAt(x, 2);
            int populationNum = Integer.parseInt(population);
            String latitude = (String)this.settlementTableModel.getValueAt(x, 3);
            String longitude = (String)this.settlementTableModel.getValueAt(x, 4);
            settlementConfig.addInitialSettlement(name, template, populationNum, latitude, longitude);
        }
    }

    private void closeWindow() {
        this.dispose();
    }

    private void setError(String errorString) {
        if (!this.hasError) {
            this.hasError = true;
            this.errorLabel.setText(errorString);
            this.createButton.setEnabled(false);
        }
    }

    private void clearError() {
        this.hasError = false;
        this.errorLabel.setText("");
        this.createButton.setEnabled(true);
    }

    private SettlementInfo determineNewSettlementConfiguration() {
        SettlementInfo settlement = new SettlementInfo();
        settlement.name = this.determineNewSettlementName();
        settlement.template = this.determineNewSettlementTemplate();
        settlement.population = this.determineNewSettlementPopulation(settlement.template);
        settlement.latitude = this.determineNewSettlementLatitude();
        settlement.longitude = this.determineNewSettlementLongitude();
        return settlement;
    }

    private String determineNewSettlementName() {
        String result = null;
        SettlementConfig settlementConfig = this.config.getSettlementConfiguration();
        List settlementNames = settlementConfig.getSettlementNameList();
        Collections.shuffle(settlementNames);
        for (String name : settlementNames) {
            boolean nameUsed = false;
            for (int x = 0; x < this.settlementTableModel.getRowCount(); ++x) {
                if (!name.equals(this.settlementTableModel.getValueAt(x, 0))) continue;
                nameUsed = true;
            }
            if (nameUsed) continue;
            result = name;
            break;
        }
        int count = 1;
        while (result == null) {
            String name = "Settlement " + count;
            boolean nameUsed = false;
            for (int x = 0; x < this.settlementTableModel.getRowCount(); ++x) {
                if (!name.equals(this.settlementTableModel.getValueAt(x, 0))) continue;
                nameUsed = true;
            }
            if (!nameUsed) {
                result = name;
            }
            ++count;
        }
        return result;
    }

    private String determineNewSettlementTemplate() {
        String result = null;
        SettlementConfig settlementConfig = this.config.getSettlementConfiguration();
        List templates = settlementConfig.getSettlementTemplates();
        if (templates.size() > 0) {
            int index = RandomUtil.getRandomInt((int)(templates.size() - 1));
            result = ((SettlementTemplate)templates.get(index)).getTemplateName();
        } else {
            logger.log(Level.WARNING, "No configured settlement templates found");
        }
        return result;
    }

    private String determineNewSettlementPopulation(String templateName) {
        String result = "0";
        if (templateName != null) {
            SettlementConfig settlementConfig = this.config.getSettlementConfiguration();
            for (SettlementTemplate template : settlementConfig.getSettlementTemplates()) {
                if (!template.getTemplateName().equals(templateName)) continue;
                result = Integer.toString(template.getDefaultPopulation());
            }
        }
        return result;
    }

    private String determineNewSettlementLatitude() {
        double phi = Coordinates.getRandomLatitude();
        String formattedLatitude = Coordinates.getFormattedLatitudeString((double)phi);
        int degreeIndex = formattedLatitude.indexOf(186);
        return formattedLatitude.substring(0, degreeIndex) + formattedLatitude.substring(degreeIndex + 1, formattedLatitude.length());
    }

    private String determineNewSettlementLongitude() {
        double theta = Coordinates.getRandomLongitude();
        String formattedLongitude = Coordinates.getFormattedLongitudeString((double)theta);
        int degreeIndex = formattedLongitude.indexOf(186);
        return formattedLongitude.substring(0, degreeIndex) + formattedLongitude.substring(degreeIndex + 1, formattedLongitude.length());
    }

    private class SettlementTableModel
    extends AbstractTableModel {
        private String[] columns = new String[]{"Name", "Template", "Population", "Latitude", "Longitude"};
        private List<SettlementInfo> settlements = new ArrayList<SettlementInfo>();

        private SettlementTableModel() {
            this.loadDefaultSettlements();
        }

        private void loadDefaultSettlements() {
            SettlementConfig settlementConfig = TempSimulationConfigEditor.this.config.getSettlementConfiguration();
            this.settlements.clear();
            for (int x = 0; x < settlementConfig.getNumberOfInitialSettlements(); ++x) {
                SettlementInfo info = new SettlementInfo();
                info.name = settlementConfig.getInitialSettlementName(x);
                info.template = settlementConfig.getInitialSettlementTemplate(x);
                info.population = Integer.toString(settlementConfig.getInitialSettlementPopulationNumber(x));
                info.latitude = settlementConfig.getInitialSettlementLatitude(x);
                info.longitude = settlementConfig.getInitialSettlementLongitude(x);
                this.settlements.add(info);
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.settlements.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex > -1 && columnIndex < this.columns.length) {
                return this.columns[columnIndex];
            }
            return "invalid column index";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public Object getValueAt(int row, int column) {
            String result = "unknown";
            if (row > -1 && row < this.getRowCount()) {
                SettlementInfo info = this.settlements.get(row);
                if (column > -1 && column < this.getColumnCount()) {
                    switch (column) {
                        case 0: {
                            result = info.name;
                            break;
                        }
                        case 1: {
                            result = info.template;
                            break;
                        }
                        case 2: {
                            result = info.population;
                            break;
                        }
                        case 3: {
                            result = info.latitude;
                            break;
                        }
                        case 4: {
                            result = info.longitude;
                        }
                    }
                } else {
                    result = "invalid column index";
                }
            } else {
                result = "invalid row index";
            }
            return result;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex > -1 && rowIndex < this.getRowCount()) {
                SettlementInfo info = this.settlements.get(rowIndex);
                if (columnIndex > -1 && columnIndex < this.getColumnCount()) {
                    switch (columnIndex) {
                        case 0: {
                            info.name = (String)aValue;
                            break;
                        }
                        case 1: {
                            info.template = (String)aValue;
                            break;
                        }
                        case 2: {
                            info.population = (String)aValue;
                            break;
                        }
                        case 3: {
                            info.latitude = (String)aValue;
                            break;
                        }
                        case 4: {
                            info.longitude = (String)aValue;
                        }
                    }
                }
                this.checkForErrors();
            }
        }

        private void removeSettlements(int[] rowIndexes) {
            ArrayList<SettlementInfo> removedSettlements = new ArrayList<SettlementInfo>(rowIndexes.length);
            for (int x = 0; x < rowIndexes.length; ++x) {
                if (rowIndexes[x] <= -1 || rowIndexes[x] >= this.getRowCount()) continue;
                removedSettlements.add(this.settlements.get(rowIndexes[x]));
            }
            Iterator i = removedSettlements.iterator();
            while (i.hasNext()) {
                this.settlements.remove(i.next());
            }
            this.fireTableDataChanged();
        }

        private void addSettlement(SettlementInfo settlement) {
            this.settlements.add(settlement);
            this.fireTableDataChanged();
        }

        private void checkForErrors() {
            TempSimulationConfigEditor.this.clearError();
            for (SettlementInfo settlement : this.settlements) {
                if (settlement.name == null || settlement.name.isEmpty()) {
                    TempSimulationConfigEditor.this.setError("Settlement name cannot be blank");
                }
                if (settlement.population == null || settlement.population.isEmpty()) {
                    TempSimulationConfigEditor.this.setError("Settlement population cannot be blank");
                } else {
                    try {
                        int popInt = Integer.parseInt(settlement.population);
                        if (popInt < 0) {
                            TempSimulationConfigEditor.this.setError("Settlement population must be 0 or larger");
                        }
                    }
                    catch (NumberFormatException e) {
                        TempSimulationConfigEditor.this.setError("Settlement population must be a valid integer number");
                    }
                }
                if (settlement.latitude == null || settlement.latitude.isEmpty()) {
                    TempSimulationConfigEditor.this.setError("Settlement latitude cannot be blank");
                } else {
                    String cleanLatitude = settlement.latitude.trim().toUpperCase();
                    if (!cleanLatitude.endsWith("N") && !cleanLatitude.endsWith("S")) {
                        TempSimulationConfigEditor.this.setError("Settlement latitude must end with direction 'N' or 'S'");
                    } else {
                        String numLatitude = cleanLatitude.substring(0, cleanLatitude.length() - 1);
                        try {
                            double doubleLatitude = Double.parseDouble(numLatitude);
                            if (doubleLatitude < 0.0 || doubleLatitude > 90.0) {
                                TempSimulationConfigEditor.this.setError("Settlement latitude must begin with a number between 0 and 90");
                            }
                        }
                        catch (NumberFormatException e) {
                            TempSimulationConfigEditor.this.setError("Settlement latitude must begin with a number between 0 and 90");
                        }
                    }
                }
                if (settlement.longitude == null || settlement.longitude.isEmpty()) {
                    TempSimulationConfigEditor.this.setError("Settlement longitude cannot be blank");
                    continue;
                }
                String cleanLongitude = settlement.longitude.trim().toUpperCase();
                if (!cleanLongitude.endsWith("W") && !cleanLongitude.endsWith("E")) {
                    TempSimulationConfigEditor.this.setError("Settlement longitude must end with direction 'W' or 'E'");
                    continue;
                }
                String numLongitude = cleanLongitude.substring(0, cleanLongitude.length() - 1);
                try {
                    double doubleLongitude = Double.parseDouble(numLongitude);
                    if (!(doubleLongitude < 0.0) && !(doubleLongitude > 180.0)) continue;
                    TempSimulationConfigEditor.this.setError("Settlement longitude must begin with a number between 0 and 180");
                }
                catch (NumberFormatException e) {
                    TempSimulationConfigEditor.this.setError("Settlement longitude must begin with a number between 0 and 180");
                }
            }
        }
    }

    private class SettlementInfo {
        String name;
        String template;
        String population;
        String latitude;
        String longitude;

        private SettlementInfo() {
        }
    }
}

