/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.sound;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import org.mars_sim.msp.ui.swing.UIConfig;

public class AudioPlayer
implements LineListener,
MetaEventListener {
    private static Logger logger = Logger.getLogger(AudioPlayer.class.getName());
    private SourceDataLine currentLine = null;
    private Clip currentClip = null;
    private Sequencer sequencer = null;
    private Synthesizer synthesizer = null;
    private Receiver synthReceiver = null;
    private Transmitter seqTransmitter = null;
    private boolean mute;
    private float volume;
    private ConcurrentHashMap<String, Clip> audioCache = new ConcurrentHashMap();
    private boolean looping = false;
    private Thread sound_player;

    public AudioPlayer() {
        if (UIConfig.INSTANCE.useUIDefault()) {
            this.setMute(false);
            this.setVolume(0.5f);
        } else {
            this.setMute(UIConfig.INSTANCE.isMute());
            this.setVolume(UIConfig.INSTANCE.getVolume());
        }
    }

    private void startPlay(final String filepath, final boolean loop) {
        this.sound_player = new Thread(){

            @Override
            public void run() {
                if (filepath != null && filepath.length() != 0) {
                    if (filepath.endsWith(".wav")) {
                        AudioPlayer.this.startPlayWavSound(filepath, loop);
                    } else if (filepath.endsWith(".mp3") || filepath.endsWith(".ogg")) {
                        AudioPlayer.this.startPlayCompressedSound(filepath, loop);
                    } else if (filepath.endsWith(".midi") || filepath.endsWith(".mid")) {
                        AudioPlayer.this.startMidiSound(filepath, loop);
                    }
                }
            }
        };
        this.sound_player.setPriority(1);
        this.sound_player.setName(filepath);
        this.sound_player.setDaemon(true);
        this.sound_player.start();
    }

    public void startPlayWavSound(String filepath, boolean loop) {
        try {
            if (!this.audioCache.containsKey(filepath)) {
                URL soundURL = this.getClass().getClassLoader().getResource(filepath);
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(soundURL);
                this.currentClip = AudioSystem.getClip();
                this.currentClip.open(audioInputStream);
                this.audioCache.put(filepath, this.currentClip);
                if (this.audioCache.size() > 5) {
                    Object[] keys = this.audioCache.keySet().toArray();
                    this.audioCache.remove(keys[0]);
                    keys = null;
                }
            } else {
                this.currentClip = this.audioCache.get(filepath);
                this.currentClip.setFramePosition(0);
                this.currentClip.stop();
            }
            this.currentClip.addLineListener(this);
            this.setVolume(this.volume);
            this.setMute(this.mute);
            if (loop) {
                this.currentClip.loop(-1);
            } else {
                this.currentClip.start();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Issues when playing WAV sound", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPlayCompressedSound(String filepath, boolean loop) {
        this.stop();
        AudioInputStream din = null;
        this.looping = loop;
        do {
            try {
                File file = new File(filepath);
                AudioInputStream in = AudioSystem.getAudioInputStream(file);
                AudioFormat baseFormat = in.getFormat();
                AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                din = AudioSystem.getAudioInputStream(decodedFormat, in);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, decodedFormat);
                this.currentLine = (SourceDataLine)AudioSystem.getLine(info);
                if (this.currentLine == null) continue;
                this.currentLine.addLineListener(this);
                this.currentLine.open(decodedFormat);
                this.setVolume(this.volume);
                this.setMute(this.mute);
                byte[] data = new byte[decodedFormat.getSampleSizeInBits()];
                this.currentLine.start();
                int nBytesRead = 0;
                while ((nBytesRead = din.read(data, 0, data.length)) != -1) {
                    this.currentLine.write(data, 0, nBytesRead);
                }
                this.currentLine.drain();
                this.currentLine.stop();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                logger.log(Level.SEVERE, "Issues when playing compressed sound", e);
            }
            finally {
                if (din != null) {
                    try {
                        din.close();
                        din = null;
                    }
                    catch (IOException e) {}
                }
            }
        } while (this.looping);
    }

    public void startMidiSound(String filepath, boolean loop) {
        this.looping = loop;
        try {
            this.sequencer = MidiSystem.getSequencer();
            this.synthesizer = MidiSystem.getSynthesizer();
            this.sequencer.open();
            this.synthesizer.open();
            this.synthReceiver = this.synthesizer.getReceiver();
            this.seqTransmitter = this.sequencer.getTransmitter();
            this.seqTransmitter.setReceiver(this.synthReceiver);
            Sequence sequence = MidiSystem.getSequence(new File(filepath));
            this.sequencer.setSequence(sequence);
            this.sequencer.addMetaEventListener(this);
            this.setVolume(this.volume);
            this.setMute(this.mute);
            if (this.looping) {
                this.sequencer.setLoopCount(-1);
                this.sequencer.start();
            } else {
                this.sequencer.start();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Issues when playing compressed sound", e);
        }
    }

    public void play(String filepath) {
        this.startPlay(filepath, false);
    }

    public void loop(String filepath) {
        this.startPlay(filepath, true);
    }

    public void stop() {
        this.looping = false;
        if (this.currentClip != null && this.currentClip.isOpen()) {
            this.currentClip.stop();
            this.currentClip.removeLineListener(this);
            this.currentClip = null;
        }
        if (this.currentLine != null && this.currentLine.isOpen()) {
            this.currentLine.drain();
            this.currentLine.close();
            this.currentLine.removeLineListener(this);
            this.currentLine = null;
        }
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.stop();
            this.sequencer.close();
            this.sequencer.removeMetaEventListener(this);
            this.sequencer = null;
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        FloatControl gainControl;
        float gain;
        float gainLog10;
        if (volume < 0.0f && volume > 1.0f) {
            throw new IllegalArgumentException("Volume invalid: " + volume);
        }
        this.volume = volume;
        if (this.currentClip != null) {
            gainLog10 = (float)(Math.log(volume) / Math.log(10.0));
            gain = gainLog10 * 20.0f;
            try {
                if (this.currentClip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                    gainControl = (FloatControl)this.currentClip.getControl(FloatControl.Type.MASTER_GAIN);
                    gainControl.setValue(gain);
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (this.currentLine != null) {
            gainLog10 = (float)(Math.log(volume) / Math.log(10.0));
            gain = gainLog10 * 20.0f;
            try {
                if (this.currentClip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                    gainControl = (FloatControl)this.currentLine.getControl(FloatControl.Type.MASTER_GAIN);
                    gainControl.setValue(gain);
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (this.sequencer != null) {
            this.setVolumeSequencer(volume);
        }
    }

    public boolean isMute() {
        return this.mute;
    }

    public void setMute(boolean mute) {
        BooleanControl muteControl;
        this.mute = mute;
        if (this.currentClip != null && this.currentClip.isControlSupported(BooleanControl.Type.MUTE)) {
            muteControl = (BooleanControl)this.currentClip.getControl(BooleanControl.Type.MUTE);
            muteControl.setValue(mute);
        }
        if (this.currentLine != null && this.currentLine.isControlSupported(BooleanControl.Type.MUTE)) {
            muteControl = (BooleanControl)this.currentLine.getControl(BooleanControl.Type.MUTE);
            muteControl.setValue(mute);
        }
        if (this.sequencer != null) {
            this.muteSequencer(mute);
        }
    }

    private void muteSequencer(boolean mute) {
        Sequence sequence = this.sequencer.getSequence();
        int tracks = sequence.getTracks().length;
        for (int i = 0; i < tracks; ++i) {
            this.sequencer.setTrackMute(i, mute);
        }
    }

    private void setVolumeSequencer(float volume) {
        MidiChannel[] channels;
        int convert = (int)(volume * 127.0f);
        for (MidiChannel channel : channels = this.synthesizer.getChannels()) {
            channel.controlChange(7, convert);
        }
    }

    @Override
    public void update(LineEvent event) {
        if (event.getType() == LineEvent.Type.STOP || event.getType() == LineEvent.Type.CLOSE) {
            if (event.getSource().equals(this.currentClip)) {
                this.currentClip.stop();
            } else {
                Line line = event.getLine();
                line.close();
                line.removeLineListener(this);
            }
        }
    }

    public void cleanAudioPlayer() {
        this.stop();
        this.audioCache.clear();
        this.sound_player = null;
    }

    @Override
    public void meta(MetaMessage meta) {
        if (meta.getType() == 47 && this.sequencer != null) {
            this.sequencer.stop();
            this.sequencer.close();
            this.sequencer.removeMetaEventListener(this);
            this.sequencer = null;
        }
    }
}

