/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.ExploredLocation;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.tool.map.MapLayer;
import org.mars_sim.msp.ui.swing.tool.map.MapUtils;

public class ExploredSiteMapLayer
implements MapLayer {
    private static final String EXPLORED_ICON_NAME = "SmallFlagYellow";
    private static final String MINED_ICON_NAME = "SmallFlagGray";
    private static final String SELECTED_ICON_NAME = "SmallFlagBlue";
    private Component displayComponent;
    private Icon navpointIconExplored;
    private Icon navpointIconMined;
    private Icon navpointIconSelected;
    private boolean displayMined;
    private boolean displayReserved;
    private ExploredLocation selectedSite;

    public ExploredSiteMapLayer(Component displayComponent) {
        this.displayComponent = displayComponent;
        this.navpointIconExplored = ImageLoader.getIcon(EXPLORED_ICON_NAME);
        this.navpointIconMined = ImageLoader.getIcon(MINED_ICON_NAME);
        this.navpointIconSelected = ImageLoader.getIcon(SELECTED_ICON_NAME);
        this.displayMined = true;
        this.displayReserved = true;
        this.selectedSite = null;
    }

    public void setDisplayMined(boolean displayMined) {
        this.displayMined = displayMined;
    }

    public void setDisplayReserved(boolean displayReserved) {
        this.displayReserved = displayReserved;
    }

    public void setSelectedSite(ExploredLocation selectedSite) {
        this.selectedSite = selectedSite;
    }

    @Override
    public void displayLayer(Coordinates mapCenter, String mapType, Graphics g) {
        SurfaceFeatures surfaceFeatures = Simulation.instance().getMars().getSurfaceFeatures();
        for (ExploredLocation site : surfaceFeatures.getExploredLocations()) {
            boolean displaySite = true;
            if (site.isReserved() && !this.displayReserved) {
                displaySite = false;
            }
            if (site.isMined() && !this.displayMined) {
                displaySite = false;
            }
            if (!site.isExplored()) {
                displaySite = false;
            }
            if (!displaySite) continue;
            this.displayExploredSite(site, mapCenter, mapType, g);
        }
    }

    private void displayExploredSite(ExploredLocation site, Coordinates mapCenter, String mapType, Graphics g) {
        double angle = 0.0;
        angle = "USGS map".equals(mapType) ? 0.06106 : 0.48587;
        if (mapCenter.getAngle(site.getLocation()) < angle) {
            Icon navIcon = null;
            navIcon = site.equals(this.selectedSite) ? this.navpointIconSelected : (site.isMined() ? this.navpointIconMined : this.navpointIconExplored);
            IntPoint location = MapUtils.getRectPosition(site.getLocation(), mapCenter, mapType);
            IntPoint drawLocation = new IntPoint(location.getiX(), location.getiY() - navIcon.getIconHeight());
            navIcon.paintIcon(this.displayComponent, g, drawLocation.getiX(), drawLocation.getiY());
        }
    }

    public int getIconWidth() {
        return this.navpointIconExplored.getIconWidth();
    }

    public int getIconHeight() {
        return this.navpointIconExplored.getIconHeight();
    }
}

