/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.Landmark;
import org.mars_sim.msp.ui.swing.tool.map.MapLayer;
import org.mars_sim.msp.ui.swing.tool.map.MapUtils;

public class LandmarkMapLayer
implements MapLayer {
    private int CIRCLE_DIAMETER = 10;
    private Color SURFACE_COLOR = new Color(50, 50, 255);
    private Color TOPO_COLOR = new Color(50, 50, 50);
    private Font MAP_LABEL_FONT = new Font("SansSerif", 0, 10);
    private int LABEL_HORIZONTAL_OFFSET = 2;

    @Override
    public void displayLayer(Coordinates mapCenter, String mapType, Graphics g) {
        for (Landmark landmark : Simulation.instance().getMars().getSurfaceFeatures().getLandmarks()) {
            double angle = 0.0;
            angle = "USGS map".equals(mapType) ? 0.06106 : 0.48587;
            if (!(mapCenter.getAngle(landmark.getLandmarkLocation()) < angle)) continue;
            this.displayLandmark(landmark, mapCenter, mapType, g);
        }
    }

    private void displayLandmark(Landmark landmark, Coordinates mapCenter, String mapType, Graphics g) {
        IntPoint location = MapUtils.getRectPosition(landmark.getLandmarkLocation(), mapCenter, mapType);
        int locX = location.getiX() - this.CIRCLE_DIAMETER / 2;
        int locY = location.getiY() - this.CIRCLE_DIAMETER / 2;
        if ("topographical map".equals(mapType)) {
            g.setColor(this.TOPO_COLOR);
        } else {
            g.setColor(this.SURFACE_COLOR);
        }
        g.drawOval(locX, locY, this.CIRCLE_DIAMETER, this.CIRCLE_DIAMETER);
        int locLabelX = location.getiX() + this.CIRCLE_DIAMETER / 2 + this.LABEL_HORIZONTAL_OFFSET;
        int locLabelY = location.getiY() + this.CIRCLE_DIAMETER;
        g.setFont(this.MAP_LABEL_FONT);
        g.drawString(landmark.getLandmarkName(), locLabelX, locLabelY);
    }
}

