/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.IntPoint;

public class MapUtils {
    private static final int MAP_OFFSET_X = 300;
    private static final int MAP_OFFSET_Y = 300;

    private MapUtils() {
    }

    public static IntPoint getRectPosition(Coordinates coords, Coordinates mapCenter, String mapType) {
        int mapHeight = 0;
        mapHeight = "USGS map".equals(mapType) ? 11458 : 1440;
        double rho = (double)mapHeight / Math.PI;
        int halfMap = mapHeight / 2;
        int low_edge = halfMap - 150;
        return Coordinates.findRectPosition((Coordinates)coords, (Coordinates)mapCenter, (double)rho, (int)halfMap, (int)low_edge);
    }

    public static int getPixelDistance(double distance, String mapType) {
        int mapWidth = 0;
        mapWidth = "USGS map".equals(mapType) ? 22916 : 2880;
        double distancePerPixel = 21318.847747260337 / (double)mapWidth;
        return (int)Math.round(distance / distancePerPixel);
    }
}

