/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.MineralMap;
import org.mars_sim.msp.ui.swing.tool.map.MapLayer;

public class MineralMapLayer
implements MapLayer {
    private static String CLASS_NAME = "org.mars_sim.msp.ui.standard.tool.map.MineralMapLayer";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private int[] mineralConcentrationArray;
    private Component displayComponent;
    private Image mineralConcentrationMap;
    private Coordinates mapCenterCache;
    private String mapTypeCache;
    private boolean updateLayer;
    private Map<String, Boolean> mineralsDisplayedMap;

    public MineralMapLayer(Component displayComponent) {
        this.displayComponent = displayComponent;
        this.mineralConcentrationArray = new int[90000];
        this.updateMineralsDisplayed();
    }

    @Override
    public void displayLayer(Coordinates mapCenter, String mapType, Graphics g) {
        if (!mapCenter.equals((Object)this.mapCenterCache) || !mapType.equals(this.mapTypeCache) || this.updateLayer) {
            this.mapCenterCache = new Coordinates(mapCenter);
            this.mapTypeCache = mapType;
            this.updateLayer = false;
            Arrays.fill(this.mineralConcentrationArray, 0);
            int centerX = 150;
            int centerY = 150;
            double rho = 0.0;
            rho = "USGS map".equals(mapType) ? 3647.194675893874 : 458.3662361046586;
            MineralMap mineralMap = Simulation.instance().getMars().getSurfaceFeatures().getMineralMap();
            Map<String, Color> mineralColors = this.getMineralColors();
            this.updateMineralsDisplayed();
            Coordinates location = new Coordinates(0.0, 0.0);
            for (int x = 0; x < 300; x += 2) {
                for (int y = 0; y < 300; y += 2) {
                    mapCenter.convertRectToSpherical((double)(x - centerX), (double)(y - centerY), rho, location);
                    Map mineralConcentrations = mineralMap.getAllMineralConcentrations(location);
                    if (mineralConcentrations.size() <= 0) continue;
                    for (String mineralType : mineralConcentrations.keySet()) {
                        double concentration;
                        if (!this.isMineralDisplayed(mineralType) || !((concentration = ((Double)mineralConcentrations.get(mineralType)).doubleValue()) > 0.0)) continue;
                        Color baseColor = mineralColors.get(mineralType);
                        int index = x + y * 300;
                        this.addColorToMineralConcentrationArray(index, baseColor, concentration);
                        this.addColorToMineralConcentrationArray(index + 1, baseColor, concentration);
                        if (y >= 299) continue;
                        int indexNextLine = x + (y + 1) * 300;
                        this.addColorToMineralConcentrationArray(indexNextLine, baseColor, concentration);
                        this.addColorToMineralConcentrationArray(indexNextLine + 1, baseColor, concentration);
                    }
                }
            }
            this.mineralConcentrationMap = this.displayComponent.createImage(new MemoryImageSource(300, 300, this.mineralConcentrationArray, 0, 300));
            MediaTracker mt = new MediaTracker(this.displayComponent);
            mt.addImage(this.mineralConcentrationMap, 0);
            try {
                mt.waitForID(0);
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "MineralMapLayer interrupted: " + e);
            }
        }
        g.drawImage(this.mineralConcentrationMap, 0, 0, this.displayComponent);
    }

    private void addColorToMineralConcentrationArray(int index, Color color, double concentration) {
        int concentrationInt = (int)(255.0 * (concentration / 100.0));
        int concentrationColor = concentrationInt << 24 | color.getRGB() & 0xFFFFFF;
        int currentColor = this.mineralConcentrationArray[index];
        this.mineralConcentrationArray[index] = currentColor | concentrationColor;
    }

    public Map<String, Color> getMineralColors() {
        MineralMap mineralMap = Simulation.instance().getMars().getSurfaceFeatures().getMineralMap();
        String[] mineralNames = mineralMap.getMineralTypeNames();
        HashMap<String, Color> result = new HashMap<String, Color>(mineralNames.length);
        for (int x = 0; x < mineralNames.length; ++x) {
            String mineralTypeName = mineralMap.getMineralTypeNames()[x];
            int mineralColor = Color.HSBtoRGB((float)x / (float)mineralNames.length, 1.0f, 1.0f);
            result.put(mineralTypeName, new Color(mineralColor));
        }
        return result;
    }

    private void updateMineralsDisplayed() {
        MineralMap mineralMap = Simulation.instance().getMars().getSurfaceFeatures().getMineralMap();
        Object[] mineralNames = mineralMap.getMineralTypeNames();
        Arrays.sort(mineralNames);
        if (this.mineralsDisplayedMap == null) {
            this.mineralsDisplayedMap = new HashMap<String, Boolean>(mineralNames.length);
        }
        Object[] currentMineralNames = this.mineralsDisplayedMap.keySet().toArray(new String[this.mineralsDisplayedMap.size()]);
        Arrays.sort(currentMineralNames);
        if (!Arrays.equals(mineralNames, currentMineralNames)) {
            this.mineralsDisplayedMap.clear();
            for (Object mineralName : mineralNames) {
                this.mineralsDisplayedMap.put((String)mineralName, true);
            }
        }
    }

    public boolean isMineralDisplayed(String mineralType) {
        if (this.mineralsDisplayedMap != null && this.mineralsDisplayedMap.containsKey(mineralType)) {
            return this.mineralsDisplayedMap.get(mineralType);
        }
        return false;
    }

    public void setMineralDisplayed(String mineralType, boolean displayed) {
        if (this.mineralsDisplayedMap != null && this.isMineralDisplayed(mineralType) != displayed) {
            this.mineralsDisplayedMap.put(mineralType, displayed);
            this.updateLayer = true;
        }
    }
}

