/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.Mars;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.ui.swing.tool.map.MapLayer;

public class ShadingMapLayer
implements MapLayer {
    private static String CLASS_NAME = "org.mars_sim.msp.ui.standard.tool.map.ShadingMapLayer";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private SurfaceFeatures surfaceFeatures;
    private int[] shadingArray;
    private Component displayComponent;

    public ShadingMapLayer(Component displayComponent) {
        Mars mars = Simulation.instance().getMars();
        this.surfaceFeatures = mars.getSurfaceFeatures();
        this.displayComponent = displayComponent;
        this.shadingArray = new int[90000];
    }

    @Override
    public void displayLayer(Coordinates mapCenter, String mapType, Graphics g) {
        int centerX = 150;
        int centerY = 150;
        double rho = 0.0;
        rho = "USGS map".equals(mapType) ? 3647.194675893874 : 458.3662361046586;
        boolean nightTime = true;
        boolean dayTime = true;
        Coordinates location = new Coordinates(0.0, 0.0);
        for (int x = 0; x < 300; x += 2) {
            for (int y = 0; y < 300; y += 2) {
                int shadeColor;
                mapCenter.convertRectToSpherical((double)(x - centerX), (double)(y - centerY), rho, location);
                double sunlight = this.surfaceFeatures.getSurfaceSunlight(location);
                int sunlightInt = (int)(127.0 * sunlight);
                this.shadingArray[x + y * 300] = shadeColor = 127 - sunlightInt << 24 & 0xFF000000;
                this.shadingArray[x + 1 + y * 300] = shadeColor;
                if (y < 299) {
                    this.shadingArray[x + (y + 1) * 300] = shadeColor;
                    this.shadingArray[x + 1 + (y + 1) * 300] = shadeColor;
                }
                if (sunlight > 0.0) {
                    nightTime = false;
                }
                if (!(sunlight < 127.0)) continue;
                dayTime = false;
            }
        }
        if (nightTime) {
            g.setColor(new Color(0, 0, 0, 128));
            g.fillRect(0, 0, 300, 300);
        } else if (!dayTime) {
            Image shadingMap = this.displayComponent.createImage(new MemoryImageSource(300, 300, this.shadingArray, 0, 300));
            MediaTracker mt = new MediaTracker(this.displayComponent);
            mt.addImage(shadingMap, 0);
            try {
                mt.waitForID(0);
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "ShadingMapLayer interrupted: " + e);
            }
            g.drawImage(shadingMap, 0, 0, this.displayComponent);
        }
    }
}

