/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Graphics;
import javax.swing.Icon;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.ui.swing.tool.map.MapUtils;
import org.mars_sim.msp.ui.swing.tool.map.UnitMapLayer;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfo;
import org.mars_sim.msp.ui.swing.unit_display_info.UnitDisplayInfoFactory;

public class UnitLabelMapLayer
extends UnitMapLayer {
    private static final int LABEL_HORIZONTAL_OFFSET = 2;

    @Override
    protected void displayUnit(Unit unit, Coordinates mapCenter, String mapType, Graphics g) {
        IntPoint location = MapUtils.getRectPosition(unit.getCoordinates(), mapCenter, mapType);
        UnitDisplayInfo displayInfo = UnitDisplayInfoFactory.getUnitDisplayInfo(unit);
        IntPoint labelLocation = this.getLabelLocation(location, displayInfo.getSurfMapIcon(unit));
        if ("topographical map".equals(mapType)) {
            g.setColor(displayInfo.getTopoMapLabelColor());
        } else {
            g.setColor(displayInfo.getSurfMapLabelColor());
        }
        g.setFont(displayInfo.getMapLabelFont());
        if (!displayInfo.isMapBlink(unit) || displayInfo.isMapBlink(unit) && this.getBlinkFlag()) {
            g.drawString(unit.getName(), labelLocation.getiX(), labelLocation.getiY());
        }
    }

    private IntPoint getLabelLocation(IntPoint unitPosition, Icon unitIcon) {
        int unitX = unitPosition.getiX();
        int unitY = unitPosition.getiY();
        int iconHeight = unitIcon.getIconHeight();
        int iconWidth = unitIcon.getIconWidth();
        return new IntPoint(unitX + iconWidth / 2 + 2, unitY + iconHeight / 2);
    }
}

