/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.map;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.tool.map.MapLayer;
import org.mars_sim.msp.ui.swing.tool.map.MapUtils;

public class VehicleTrailMapLayer
implements MapLayer {
    private Vehicle singleVehicle;

    public void setSingleVehicle(Vehicle singleVehicle) {
        this.singleVehicle = singleVehicle;
    }

    @Override
    public void displayLayer(Coordinates mapCenter, String mapType, Graphics g) {
        if ("topographical map".equals(mapType)) {
            g.setColor(Color.black);
        } else {
            g.setColor(new Color(0, 96, 0));
        }
        if (this.singleVehicle != null) {
            this.displayTrail(this.singleVehicle, mapCenter, mapType, g);
        } else {
            Iterator i = Simulation.instance().getUnitManager().getVehicles().iterator();
            while (i.hasNext()) {
                this.displayTrail((Vehicle)i.next(), mapCenter, mapType, g);
            }
        }
    }

    private void displayTrail(Vehicle vehicle, Coordinates mapCenter, String mapType, Graphics g) {
        double angle = 0.0;
        angle = "USGS map".equals(mapType) ? 0.06106 : 0.48587;
        IntPoint oldSpot = null;
        for (Coordinates trailSpot : new ArrayList(vehicle.getTrail())) {
            if (trailSpot == null || !(mapCenter.getAngle(trailSpot) < angle)) continue;
            IntPoint spotLocation = MapUtils.getRectPosition(trailSpot, mapCenter, mapType);
            if (oldSpot == null) {
                g.drawRect(spotLocation.getiX(), spotLocation.getiY(), 1, 1);
            } else if (!spotLocation.equals(oldSpot)) {
                g.drawLine(oldSpot.getiX(), oldSpot.getiY(), spotLocation.getiX(), spotLocation.getiY());
            }
            oldSpot = spotLocation;
        }
    }
}

