/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.AreologyStudyFieldMission;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyEvent;
import org.mars_sim.msp.core.science.ScientificStudyListener;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.tool.mission.MissionCustomInfoPanel;
import org.mars_sim.msp.ui.swing.tool.science.ScienceWindow;

public class AreologyStudyFieldMissionCustomInfoPanel
extends MissionCustomInfoPanel
implements ScientificStudyListener {
    private MainDesktopPane desktop;
    private ScientificStudy study;
    private AreologyStudyFieldMission areologyMission;
    private JLabel studyNameLabel;
    private JLabel researcherNameLabel;
    private JProgressBar studyResearchBar;

    AreologyStudyFieldMissionCustomInfoPanel(MainDesktopPane desktop) {
        this.desktop = desktop;
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel(new GridLayout(3, 1));
        this.add((Component)contentPanel, "North");
        JPanel studyPanel = new JPanel(new FlowLayout(0));
        contentPanel.add(studyPanel);
        JButton scienceToolButton = new JButton(ImageLoader.getIcon("Science"));
        scienceToolButton.setMargin(new Insets(1, 1, 1, 1));
        scienceToolButton.setToolTipText("Open study in science tool.");
        scienceToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AreologyStudyFieldMissionCustomInfoPanel.this.displayStudyInScienceTool();
            }
        });
        studyPanel.add(scienceToolButton);
        JLabel studyTitleLabel = new JLabel("Areology Field Study: ");
        studyPanel.add(studyTitleLabel);
        this.studyNameLabel = new JLabel("");
        studyPanel.add(this.studyNameLabel);
        JPanel researcherPanel = new JPanel(new FlowLayout(0));
        contentPanel.add(researcherPanel);
        JLabel researcherTitleLabel = new JLabel("Lead Researcher: ");
        researcherPanel.add(researcherTitleLabel);
        this.researcherNameLabel = new JLabel("");
        researcherPanel.add(this.researcherNameLabel);
        JPanel studyResearchPanel = new JPanel(new FlowLayout(0));
        contentPanel.add(studyResearchPanel);
        JLabel studyResearchTitleLabel = new JLabel("Study Research Completion: ");
        studyResearchPanel.add(studyResearchTitleLabel);
        this.studyResearchBar = new JProgressBar(0, 100);
        this.studyResearchBar.setStringPainted(true);
        studyResearchPanel.add(this.studyResearchBar);
    }

    @Override
    public void updateMission(Mission mission) {
        if (mission instanceof AreologyStudyFieldMission) {
            this.areologyMission = (AreologyStudyFieldMission)mission;
            if (this.study != null) {
                this.study.removeScientificStudyListener((ScientificStudyListener)this);
            }
            this.study = this.areologyMission.getScientificStudy();
            this.study.addScientificStudyListener((ScientificStudyListener)this);
            this.studyNameLabel.setText(this.study.toString());
            this.researcherNameLabel.setText(this.areologyMission.getLeadResearcher().getName());
            this.updateStudyResearchBar(this.study, this.areologyMission.getLeadResearcher());
        }
    }

    @Override
    public void updateMissionEvent(MissionEvent e) {
    }

    public void scientificStudyUpdate(ScientificStudyEvent event) {
        ScientificStudy study = event.getStudy();
        Person leadResearcher = this.areologyMission.getLeadResearcher();
        if (("study primary research work event".equals(event.getType()) || "study collaboration research work event".equals(event.getType())) && leadResearcher.equals(event.getResearcher())) {
            this.updateStudyResearchBar(study, leadResearcher);
        }
    }

    private boolean isStudyPrimaryResearcher(Person researcher, ScientificStudy study) {
        boolean result = false;
        if (researcher.equals(study.getPrimaryResearcher())) {
            result = true;
        }
        return result;
    }

    private boolean isStudyCollaborativeResearcher(Person researcher, ScientificStudy study) {
        boolean result = false;
        if (study.getCollaborativeResearchers().containsKey(researcher)) {
            result = true;
        }
        return result;
    }

    private void updateStudyResearchBar(ScientificStudy study, Person leadResearcher) {
        if (study != null) {
            double requiredResearchWork = 0.0;
            double completedResearchWork = 0.0;
            if (this.isStudyPrimaryResearcher(leadResearcher, study)) {
                requiredResearchWork = study.getTotalPrimaryResearchWorkTimeRequired();
                completedResearchWork = study.getPrimaryResearchWorkTimeCompleted();
            } else if (this.isStudyCollaborativeResearcher(leadResearcher, study)) {
                requiredResearchWork = study.getTotalCollaborativeResearchWorkTimeRequired();
                completedResearchWork = study.getCollaborativeResearchWorkTimeCompleted(leadResearcher);
            } else {
                return;
            }
            int percentResearchCompleted = (int)(completedResearchWork / requiredResearchWork * 100.0);
            this.studyResearchBar.setValue(percentResearchCompleted);
        }
    }

    private void displayStudyInScienceTool() {
        if (this.study != null) {
            ScienceWindow scienceToolWindow = (ScienceWindow)this.desktop.getToolWindow("Science Tool");
            scienceToolWindow.setScientificStudy(this.study);
            this.desktop.openToolWindow("Science Tool");
        }
    }
}

