/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Iterator;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.ai.mission.BuildingConstructionMission;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.construction.ConstructionEvent;
import org.mars_sim.msp.core.structure.construction.ConstructionListener;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStage;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionVehicleType;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.tool.mission.MissionCustomInfoPanel;

public class ConstructionMissionCustomInfoPanel
extends MissionCustomInfoPanel
implements ConstructionListener {
    private MainDesktopPane desktop;
    private BuildingConstructionMission mission;
    private ConstructionSite site;
    private JLabel stageLabel;
    private BoundedRangeModel progressBarModel;
    private JButton settlementButton;

    ConstructionMissionCustomInfoPanel(MainDesktopPane desktop) {
        this.desktop = desktop;
        this.setLayout(new BorderLayout());
        JPanel contentsPanel = new JPanel(new GridLayout(4, 1));
        this.add((Component)contentsPanel, "North");
        JPanel titlePanel = new JPanel(new FlowLayout(1));
        contentsPanel.add(titlePanel);
        JLabel titleLabel = new JLabel("Building Construction Site");
        titlePanel.add(titleLabel);
        JPanel settlementPanel = new JPanel(new FlowLayout(0));
        contentsPanel.add(settlementPanel);
        JLabel settlementLabel = new JLabel("Settlement: ");
        settlementPanel.add(settlementLabel);
        this.settlementButton = new JButton("   ");
        settlementPanel.add(this.settlementButton);
        this.settlementButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Settlement settlement;
                if (ConstructionMissionCustomInfoPanel.this.mission != null && (settlement = ConstructionMissionCustomInfoPanel.this.mission.getAssociatedSettlement()) != null) {
                    ConstructionMissionCustomInfoPanel.this.getDesktop().openUnitWindow((Unit)settlement, false);
                }
            }
        });
        JPanel stagePanel = new JPanel(new FlowLayout(0));
        contentsPanel.add(stagePanel);
        this.stageLabel = new JLabel("Stage:");
        stagePanel.add(this.stageLabel);
        JPanel progressBarPanel = new JPanel(new FlowLayout(0));
        contentsPanel.add(progressBarPanel);
        JProgressBar progressBar = new JProgressBar();
        this.progressBarModel = progressBar.getModel();
        progressBar.setStringPainted(true);
        progressBarPanel.add(progressBar);
        this.setToolTipText(this.getToolTipString());
    }

    @Override
    public void updateMission(Mission mission) {
        if (this.site != null) {
            this.site.removeConstructionListener((ConstructionListener)this);
        }
        if (mission instanceof BuildingConstructionMission) {
            this.mission = (BuildingConstructionMission)mission;
            this.site = this.mission.getConstructionSite();
            if (this.site != null) {
                this.site.addConstructionListener((ConstructionListener)this);
            }
            this.settlementButton.setText(mission.getAssociatedSettlement().getName());
            this.stageLabel.setText(this.getStageString());
            this.updateProgressBar();
            this.setToolTipText(this.getToolTipString());
        }
    }

    @Override
    public void updateMissionEvent(MissionEvent e) {
        this.stageLabel.setText(this.getStageString());
    }

    public void constructionUpdate(ConstructionEvent event) {
        if ("adding construction work".equals(event.getType())) {
            this.updateProgressBar();
            this.setToolTipText(this.getToolTipString());
        }
    }

    private String getStageString() {
        ConstructionStage stage;
        StringBuilder stageString = new StringBuilder("Stage: ");
        if (this.mission != null && (stage = this.mission.getConstructionStage()) != null) {
            stageString.append(stage.getInfo().getName());
        }
        return stageString.toString();
    }

    private void updateProgressBar() {
        ConstructionStage stage;
        int workProgress = 0;
        if (this.mission != null && (stage = this.mission.getConstructionStage()) != null) {
            double completedWork = stage.getCompletedWorkTime();
            double requiredWork = stage.getRequiredWorkTime();
            if (requiredWork > 0.0) {
                workProgress = (int)(100.0 * completedWork / requiredWork);
            }
        }
        this.progressBarModel.setValue(workProgress);
    }

    private MainDesktopPane getDesktop() {
        return this.desktop;
    }

    private String getToolTipString() {
        StringBuilder result = new StringBuilder("<html>");
        ConstructionStage stage = null;
        if (this.site != null) {
            stage = this.site.getCurrentConstructionStage();
        }
        if (stage != null) {
            ConstructionStageInfo info = stage.getInfo();
            result.append("Status: building ").append(info.getName()).append("<br>");
            result.append("Stage Type: ").append(info.getType()).append("<br>");
            if (stage.isSalvaging()) {
                result.append("Work Type: salvage<br>");
            } else {
                result.append("Work Type: Construction<br>");
            }
            DecimalFormat formatter = new DecimalFormat("0.0");
            String requiredWorkTime = formatter.format(stage.getRequiredWorkTime() / 1000.0);
            result.append("Work Time Required: ").append(requiredWorkTime).append(" Sols<br>");
            String completedWorkTime = formatter.format(stage.getCompletedWorkTime() / 1000.0);
            result.append("Work Time Completed: ").append(completedWorkTime).append(" Sols<br>");
            result.append("Architect Construction Skill Required: ").append(info.getArchitectConstructionSkill()).append("<br>");
            if (info.getResources().size() > 0) {
                result.append("<br>Construction Resources:<br>");
                for (AmountResource resource : info.getResources().keySet()) {
                    double amount = (Double)info.getResources().get(resource);
                    result.append("&nbsp;&nbsp;").append(resource.getName()).append(": ").append(amount).append(" kg<br>");
                }
            }
            if (info.getParts().size() > 0) {
                result.append("<br>Construction Parts:<br>");
                for (Part part : info.getParts().keySet()) {
                    int number = (Integer)info.getParts().get(part);
                    result.append("&nbsp;&nbsp;").append(part.getName()).append(": ").append(number).append("<br>");
                }
            }
            if (info.getVehicles().size() > 0) {
                result.append("<br>Construction Vehicles:<br>");
                for (ConstructionVehicleType vehicle : info.getVehicles()) {
                    result.append("&nbsp;&nbsp;Vehicle Type: ").append(vehicle.getVehicleType()).append("<br>");
                    result.append("&nbsp;&nbsp;Attachment Parts:<br>");
                    Iterator l = vehicle.getAttachmentParts().iterator();
                    while (l.hasNext()) {
                        result.append("&nbsp;&nbsp;&nbsp;&nbsp;").append(((Part)l.next()).getName()).append("<br>");
                    }
                }
            }
        }
        result.append("</html>");
        return result.toString();
    }
}

