/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.person.ai.mission.EmergencySupplyMission;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.ui.swing.tool.mission.MissionCustomInfoPanel;

public class EmergencySupplyMissionCustomInfoPanel
extends MissionCustomInfoPanel {
    private EmergencySupplyMission mission;
    private EmergencySuppliesTableModel emergencySuppliesTableModel;

    EmergencySupplyMissionCustomInfoPanel() {
        this.setLayout(new BorderLayout());
        JLabel emergencySuppliesLabel = new JLabel("Emergency Supplies:", 2);
        this.add((Component)emergencySuppliesLabel, "North");
        JScrollPane emergencySuppliesScrollPane = new JScrollPane();
        emergencySuppliesScrollPane.setPreferredSize(new Dimension(-1, -1));
        this.add((Component)emergencySuppliesScrollPane, "Center");
        this.emergencySuppliesTableModel = new EmergencySuppliesTableModel();
        JTable emergencySuppliesTable = new JTable(this.emergencySuppliesTableModel);
        emergencySuppliesScrollPane.setViewportView(emergencySuppliesTable);
    }

    @Override
    public void updateMissionEvent(MissionEvent e) {
    }

    @Override
    public void updateMission(Mission mission) {
        if (mission instanceof EmergencySupplyMission) {
            this.mission = (EmergencySupplyMission)mission;
            this.emergencySuppliesTableModel.updateTable();
        }
    }

    private class EmergencySuppliesTableModel
    extends AbstractTableModel {
        protected Map<Good, Integer> goodsMap;
        protected List<Good> goodsList = new ArrayList<Good>();

        private EmergencySuppliesTableModel() {
            this.goodsMap = new HashMap<Good, Integer>();
        }

        @Override
        public int getRowCount() {
            return this.goodsList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Good";
            }
            return "Amount";
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.goodsList.size()) {
                Good good = this.goodsList.get(row);
                result = column == 0 ? good.getName() : this.goodsMap.get(good);
            }
            return result;
        }

        protected void updateTable() {
            this.goodsMap = EmergencySupplyMissionCustomInfoPanel.this.mission.getEmergencySuppliesAsGoods();
            this.goodsList = new ArrayList<Good>(this.goodsMap.keySet());
            Collections.sort(this.goodsList);
            this.fireTableDataChanged();
        }
    }
}

