/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.ai.mission.Mining;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.NumberCellRenderer;
import org.mars_sim.msp.ui.swing.tool.mission.MissionCustomInfoPanel;

public class MiningMissionCustomInfoPanel
extends MissionCustomInfoPanel {
    private Mining mission;
    private MainDesktopPane desktop;
    private JButton luvButton;
    private ConcentrationTableModel concentrationTableModel;
    private ExcavationTableModel excavationTableModel;

    MiningMissionCustomInfoPanel(MainDesktopPane desktop) {
        this.setLayout(new BorderLayout());
        this.desktop = desktop;
        JPanel luvPane = new JPanel(new FlowLayout(0));
        this.add((Component)luvPane, "North");
        JLabel luvLabel = new JLabel("Light Utility Vehicle: ");
        luvPane.add(luvLabel);
        this.luvButton = new JButton("   ");
        this.luvButton.setVisible(false);
        this.luvButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightUtilityVehicle luv = MiningMissionCustomInfoPanel.this.mission.getLightUtilityVehicle();
                if (luv != null) {
                    MiningMissionCustomInfoPanel.this.getDesktop().openUnitWindow((Unit)luv, false);
                }
            }
        });
        luvPane.add(this.luvButton);
        JPanel centerPane = new JPanel(new GridLayout(2, 1));
        this.add((Component)centerPane, "Center");
        JPanel concentrationPane = new JPanel(new BorderLayout());
        centerPane.add(concentrationPane);
        JLabel concentrationLabel = new JLabel("Mineral Concentrations at Site:");
        concentrationPane.add((Component)concentrationLabel, "North");
        JScrollPane concentrationScrollPane = new JScrollPane();
        concentrationScrollPane.setPreferredSize(new Dimension(-1, -1));
        concentrationPane.add((Component)concentrationScrollPane, "Center");
        this.concentrationTableModel = new ConcentrationTableModel();
        JTable concentrationTable = new JTable(this.concentrationTableModel);
        concentrationTable.setDefaultRenderer(Double.class, new NumberCellRenderer(1));
        concentrationScrollPane.setViewportView(concentrationTable);
        JPanel excavationPane = new JPanel(new BorderLayout());
        centerPane.add(excavationPane);
        JLabel excavationLabel = new JLabel("Minerals Excavated at Site:");
        excavationPane.add((Component)excavationLabel, "North");
        JScrollPane excavationScrollPane = new JScrollPane();
        excavationScrollPane.setPreferredSize(new Dimension(-1, -1));
        excavationPane.add((Component)excavationScrollPane, "Center");
        this.excavationTableModel = new ExcavationTableModel();
        JTable excavationTable = new JTable(this.excavationTableModel);
        excavationTable.setDefaultRenderer(Double.class, new NumberCellRenderer(2));
        excavationScrollPane.setViewportView(excavationTable);
    }

    private MainDesktopPane getDesktop() {
        return this.desktop;
    }

    @Override
    public void updateMission(Mission mission) {
        if (mission instanceof Mining) {
            this.mission = (Mining)mission;
            this.updateLUVButton();
            this.concentrationTableModel.updateTable();
            this.excavationTableModel.updateTable();
        }
    }

    @Override
    public void updateMissionEvent(MissionEvent e) {
        if (e.getType().equals("excavate minerals") || e.getType().equals("collect minerals")) {
            this.excavationTableModel.updateTable();
        }
    }

    private void updateLUVButton() {
        LightUtilityVehicle luv = this.mission.getLightUtilityVehicle();
        this.luvButton.setText(luv.getName());
        this.luvButton.setVisible(true);
    }

    private class ExcavationTableModel
    extends AbstractTableModel {
        protected Map<AmountResource, Double> excavationMap = new HashMap<AmountResource, Double>();

        private ExcavationTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.excavationMap.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Mineral";
            }
            return "Excavated (kg)";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            } else if (columnIndex == 1) {
                dataType = Double.class;
            }
            return dataType;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            AmountResource[] minerals = this.excavationMap.keySet().toArray(new AmountResource[this.excavationMap.size()]);
            if (row >= 0 && row < minerals.length) {
                result = column == 0 ? minerals[row] : this.excavationMap.get(minerals[row]);
            }
            return result;
        }

        private void updateTable() {
            String[] mineralNames;
            this.excavationMap.clear();
            for (String mineralName : mineralNames = Simulation.instance().getMars().getSurfaceFeatures().getMineralMap().getMineralTypeNames()) {
                AmountResource mineral = AmountResource.findAmountResource((String)mineralName);
                double amount = MiningMissionCustomInfoPanel.this.mission.getTotalMineralExcavatedAmount(mineral);
                if (!(amount > 0.0)) continue;
                this.excavationMap.put(mineral, amount);
            }
            this.fireTableDataChanged();
        }
    }

    private class ConcentrationTableModel
    extends AbstractTableModel {
        protected Map<String, Double> estimatedConcentrationMap = new HashMap<String, Double>();
        protected Map<String, Double> actualConcentrationMap = new HashMap<String, Double>();

        private ConcentrationTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.estimatedConcentrationMap.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Mineral";
            }
            if (columnIndex == 1) {
                return "Estimated %";
            }
            return "Actual %";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            } else if (columnIndex == 1) {
                dataType = Double.class;
            } else if (columnIndex == 2) {
                dataType = Double.class;
            }
            return dataType;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            String[] minerals = this.estimatedConcentrationMap.keySet().toArray(new String[this.estimatedConcentrationMap.size()]);
            if (row >= 0 && row < minerals.length) {
                if (column == 0) {
                    result = minerals[row];
                } else if (column == 1) {
                    result = this.estimatedConcentrationMap.get(minerals[row]);
                } else if (column == 2) {
                    result = this.actualConcentrationMap.containsKey(minerals[row]) ? this.actualConcentrationMap.get(minerals[row]) : new Double(0.0);
                }
            }
            return result;
        }

        private void updateTable() {
            if (MiningMissionCustomInfoPanel.this.mission.getMiningSite() != null) {
                this.estimatedConcentrationMap = MiningMissionCustomInfoPanel.this.mission.getMiningSite().getEstimatedMineralConcentrations();
                this.actualConcentrationMap = Simulation.instance().getMars().getSurfaceFeatures().getMineralMap().getAllMineralConcentrations(MiningMissionCustomInfoPanel.this.mission.getMiningSite().getLocation());
            } else {
                this.estimatedConcentrationMap.clear();
                this.actualConcentrationMap.clear();
            }
            this.fireTableDataChanged();
        }
    }
}

