/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.person.ai.mission.MissionListener;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.MissionManagerListener;

public class MissionListModel
extends AbstractListModel
implements MissionManagerListener,
MissionListener {
    private List<Mission> missions = new ArrayList<Mission>();

    public MissionListModel() {
        MissionManager manager = Simulation.instance().getMissionManager();
        Iterator i = manager.getMissions().iterator();
        while (i.hasNext()) {
            this.addMission((Mission)i.next());
        }
        manager.addListener((MissionManagerListener)this);
    }

    public void addMission(Mission mission) {
        if (!this.missions.contains(mission)) {
            this.missions.add(mission);
            mission.addMissionListener((MissionListener)this);
            SwingUtilities.invokeLater(new MissionListUpdater(0, this, this.missions.size() - 1));
        }
    }

    public void removeMission(Mission mission) {
        if (this.missions.contains(mission)) {
            int index = this.missions.indexOf(mission);
            this.missions.remove(mission);
            mission.removeMissionListener((MissionListener)this);
            SwingUtilities.invokeLater(new MissionListUpdater(1, this, index));
        }
    }

    public void missionUpdate(MissionEvent event) {
        int index;
        if (event.getType().equals("description") && (index = this.missions.indexOf(event.getSource())) > -1 && index < this.missions.size()) {
            SwingUtilities.invokeLater(new MissionListUpdater(2, this, index));
        }
    }

    @Override
    public int getSize() {
        return this.missions.size();
    }

    @Override
    public Object getElementAt(int index) {
        try {
            return this.missions.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public boolean containsMission(Mission mission) {
        return this.missions != null && this.missions.contains(mission);
    }

    public int getMissionIndex(Mission mission) {
        if (this.containsMission(mission)) {
            return this.missions.indexOf(mission);
        }
        return -1;
    }

    public void destroy() {
        this.missions.clear();
        this.missions = null;
        Simulation.instance().getMissionManager().removeListener((MissionManagerListener)this);
    }

    private class MissionListUpdater
    implements Runnable {
        private static final int ADD = 0;
        private static final int REMOVE = 1;
        private static final int CHANGE = 2;
        private int mode;
        private MissionListModel model;
        private int row;

        private MissionListUpdater(int mode, MissionListModel model, int row) {
            this.mode = mode;
            this.model = model;
            this.row = row;
        }

        @Override
        public void run() {
            switch (this.mode) {
                case 0: {
                    MissionListModel.this.fireIntervalAdded(this.model, this.row, this.row);
                    break;
                }
                case 1: {
                    MissionListModel.this.fireIntervalRemoved(this.model, this.row, this.row);
                    break;
                }
                case 2: {
                    MissionListModel.this.fireContentsChanged(this.model, this.row, this.row);
                }
            }
        }
    }
}

