/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.tool.mission.MissionCustomInfoPanel;

public class RescueMissionCustomInfoPanel
extends MissionCustomInfoPanel {
    private MainDesktopPane desktop;
    private RescueSalvageVehicle rescueMission;
    private JButton rescueVehicleButton;
    private JLabel vehicleStatusValueLabel;
    private JLabel malfunctionListLabel;

    RescueMissionCustomInfoPanel(MainDesktopPane desktop) {
        this.desktop = desktop;
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel(new GridLayout(3, 1));
        this.add((Component)contentPanel, "North");
        JPanel rescueVehiclePanel = new JPanel(new FlowLayout(0));
        contentPanel.add(rescueVehiclePanel);
        JLabel rescueVehicleTitleLabel = new JLabel("Vehicle to Rescue: ");
        rescueVehiclePanel.add(rescueVehicleTitleLabel);
        this.rescueVehicleButton = new JButton("");
        rescueVehiclePanel.add(this.rescueVehicleButton);
        this.rescueVehicleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RescueMissionCustomInfoPanel.this.openRescueVehicleWindow();
            }
        });
        JPanel statusPanel = new JPanel(new FlowLayout(0));
        contentPanel.add(statusPanel);
        JLabel vehicleStatusTitleLabel = new JLabel("Vehicle Status: ");
        statusPanel.add(vehicleStatusTitleLabel);
        this.vehicleStatusValueLabel = new JLabel("");
        statusPanel.add(this.vehicleStatusValueLabel);
        JPanel malfunctionPanel = new JPanel(new FlowLayout(0));
        contentPanel.add(malfunctionPanel);
        JLabel malfunctionTitleLabel = new JLabel("Vehicle Malfunctions: ");
        malfunctionPanel.add(malfunctionTitleLabel);
        this.malfunctionListLabel = new JLabel("");
        malfunctionPanel.add(this.malfunctionListLabel);
    }

    private void openRescueVehicleWindow() {
        Vehicle vehicle;
        if (this.rescueMission != null && (vehicle = this.rescueMission.getVehicleTarget()) != null) {
            this.desktop.openUnitWindow((Unit)vehicle, false);
        }
    }

    @Override
    public void updateMission(Mission mission) {
        if (mission instanceof RescueSalvageVehicle) {
            this.rescueMission = (RescueSalvageVehicle)mission;
            Vehicle vehicle = this.rescueMission.getVehicleTarget();
            this.rescueVehicleButton.setText(vehicle.getName());
            this.vehicleStatusValueLabel.setText(vehicle.getStatus());
            List malfunctions = vehicle.getMalfunctionManager().getMalfunctions();
            StringBuffer malfunctionBuff = new StringBuffer("");
            if (malfunctions.size() > 0) {
                malfunctionBuff.append(((Malfunction)malfunctions.get(0)).getName());
                for (int x = 1; x < malfunctions.size(); ++x) {
                    malfunctionBuff.append(", ");
                    malfunctionBuff.append(((Malfunction)malfunctions.get(x)).getName());
                }
            }
            this.malfunctionListLabel.setText(malfunctionBuff.toString());
        }
    }

    @Override
    public void updateMissionEvent(MissionEvent e) {
    }
}

