/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.person.ai.mission.Trade;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.ui.swing.tool.mission.MissionCustomInfoPanel;

public class TradeMissionCustomInfoPanel
extends MissionCustomInfoPanel {
    private Trade mission;
    private SellingGoodsTableModel sellingGoodsTableModel;
    private JLabel desiredGoodsProfitLabel;
    private DesiredGoodsTableModel desiredGoodsTableModel;
    private JLabel boughtGoodsProfitLabel;
    private BoughtGoodsTableModel boughtGoodsTableModel;

    TradeMissionCustomInfoPanel() {
        this.setLayout(new GridLayout(3, 1));
        JPanel sellingGoodsPane = new JPanel(new BorderLayout());
        this.add(sellingGoodsPane);
        JLabel sellingGoodsLabel = new JLabel("Goods to Sell:", 2);
        sellingGoodsPane.add((Component)sellingGoodsLabel, "North");
        JScrollPane sellingGoodsScrollPane = new JScrollPane();
        sellingGoodsScrollPane.setPreferredSize(new Dimension(-1, -1));
        sellingGoodsPane.add((Component)sellingGoodsScrollPane, "Center");
        this.sellingGoodsTableModel = new SellingGoodsTableModel();
        JTable sellingGoodsTable = new JTable(this.sellingGoodsTableModel);
        sellingGoodsScrollPane.setViewportView(sellingGoodsTable);
        JPanel desiredGoodsPane = new JPanel(new BorderLayout());
        this.add(desiredGoodsPane);
        JPanel desiredGoodsLabelPane = new JPanel(new GridLayout(1, 2, 0, 0));
        desiredGoodsPane.add((Component)desiredGoodsLabelPane, "North");
        JLabel desiredGoodsLabel = new JLabel("Desired Goods to Buy:", 2);
        desiredGoodsLabelPane.add(desiredGoodsLabel);
        this.desiredGoodsProfitLabel = new JLabel("Profit:", 2);
        desiredGoodsLabelPane.add(this.desiredGoodsProfitLabel);
        JScrollPane desiredGoodsScrollPane = new JScrollPane();
        desiredGoodsScrollPane.setPreferredSize(new Dimension(-1, -1));
        desiredGoodsPane.add((Component)desiredGoodsScrollPane, "Center");
        this.desiredGoodsTableModel = new DesiredGoodsTableModel();
        JTable desiredGoodsTable = new JTable(this.desiredGoodsTableModel);
        desiredGoodsScrollPane.setViewportView(desiredGoodsTable);
        JPanel boughtGoodsPane = new JPanel(new BorderLayout());
        this.add(boughtGoodsPane);
        JPanel boughtGoodsLabelPane = new JPanel(new GridLayout(1, 2, 0, 0));
        boughtGoodsPane.add((Component)boughtGoodsLabelPane, "North");
        JLabel boughtGoodsLabel = new JLabel("Goods Bought:", 2);
        boughtGoodsLabelPane.add(boughtGoodsLabel);
        this.boughtGoodsProfitLabel = new JLabel("Profit:", 2);
        boughtGoodsLabelPane.add(this.boughtGoodsProfitLabel);
        JScrollPane boughtGoodsScrollPane = new JScrollPane();
        boughtGoodsScrollPane.setPreferredSize(new Dimension(-1, -1));
        boughtGoodsPane.add((Component)boughtGoodsScrollPane, "Center");
        this.boughtGoodsTableModel = new BoughtGoodsTableModel();
        JTable boughtGoodsTable = new JTable(this.boughtGoodsTableModel);
        boughtGoodsScrollPane.setViewportView(boughtGoodsTable);
    }

    @Override
    public void updateMissionEvent(MissionEvent e) {
        if (e.getType().equals("buy load")) {
            this.boughtGoodsTableModel.updateTable();
            this.updateBoughtGoodsProfit();
        }
    }

    @Override
    public void updateMission(Mission mission) {
        if (mission instanceof Trade) {
            this.mission = (Trade)mission;
            this.sellingGoodsTableModel.updateTable();
            this.desiredGoodsTableModel.updateTable();
            this.boughtGoodsTableModel.updateTable();
            this.updateDesiredGoodsProfit();
            this.updateBoughtGoodsProfit();
        }
    }

    private void updateDesiredGoodsProfit() {
        int profit = (int)this.mission.getDesiredProfit();
        this.desiredGoodsProfitLabel.setText("Profit: " + profit + " VP");
    }

    private void updateBoughtGoodsProfit() {
        int profit = (int)this.mission.getProfit();
        this.boughtGoodsProfitLabel.setText("Profit: " + profit + " VP");
    }

    private class BoughtGoodsTableModel
    extends GoodsTableModel {
        private BoughtGoodsTableModel() {
        }

        @Override
        protected void updateTable() {
            if (TradeMissionCustomInfoPanel.this.mission.getBuyLoad() != null) {
                this.goodsMap = TradeMissionCustomInfoPanel.this.mission.getBuyLoad();
                this.goodsList = new ArrayList(this.goodsMap.keySet());
                Collections.sort(this.goodsList);
            } else {
                this.goodsMap.clear();
                this.goodsList.clear();
            }
            this.fireTableDataChanged();
        }
    }

    private class DesiredGoodsTableModel
    extends GoodsTableModel {
        private DesiredGoodsTableModel() {
        }

        @Override
        protected void updateTable() {
            if (TradeMissionCustomInfoPanel.this.mission.getDesiredBuyLoad() != null) {
                this.goodsMap = TradeMissionCustomInfoPanel.this.mission.getDesiredBuyLoad();
                this.goodsList = new ArrayList(this.goodsMap.keySet());
                Collections.sort(this.goodsList);
            } else {
                this.goodsMap.clear();
                this.goodsList.clear();
            }
            this.fireTableDataChanged();
        }
    }

    private class SellingGoodsTableModel
    extends GoodsTableModel {
        private SellingGoodsTableModel() {
        }

        @Override
        protected void updateTable() {
            if (TradeMissionCustomInfoPanel.this.mission.getSellLoad() != null) {
                this.goodsMap = TradeMissionCustomInfoPanel.this.mission.getSellLoad();
                this.goodsList = new ArrayList(this.goodsMap.keySet());
                Collections.sort(this.goodsList);
            } else {
                this.goodsMap.clear();
                this.goodsList.clear();
            }
            this.fireTableDataChanged();
        }
    }

    private static abstract class GoodsTableModel
    extends AbstractTableModel {
        protected Map<Good, Integer> goodsMap;
        protected List<Good> goodsList = new ArrayList<Good>();

        private GoodsTableModel() {
            this.goodsMap = new HashMap<Good, Integer>();
        }

        @Override
        public int getRowCount() {
            return this.goodsList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Good";
            }
            return "Amount";
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.goodsList.size()) {
                Good good = this.goodsList.get(row);
                result = column == 0 ? good.getName() : this.goodsMap.get(good);
            }
            return result;
        }

        protected abstract void updateTable();
    }
}

