/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableCellRenderer;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableModel;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

class ConstructionSettlementPanel
extends WizardPanel {
    private static final String NAME = "Construction Settlement";
    private SettlementTableModel settlementTableModel;
    private JTable settlementTable;
    private JLabel errorMessageLabel;

    ConstructionSettlementPanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel selectSettlementLabel = new JLabel("Select a settlement to construct a building.", 0);
        selectSettlementLabel.setFont(selectSettlementLabel.getFont().deriveFont(1));
        selectSettlementLabel.setAlignmentX(0.5f);
        this.add(selectSettlementLabel);
        JPanel settlementPane = new JPanel(new BorderLayout(0, 0));
        settlementPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        settlementPane.setAlignmentX(0.5f);
        this.add(settlementPane);
        JScrollPane settlementScrollPane = new JScrollPane();
        settlementPane.add((Component)settlementScrollPane, "Center");
        this.settlementTableModel = new SettlementTableModel();
        this.settlementTable = new JTable(this.settlementTableModel);
        this.settlementTable.setDefaultRenderer(Object.class, new UnitTableCellRenderer(this.settlementTableModel));
        this.settlementTable.setRowSelectionAllowed(true);
        this.settlementTable.setSelectionMode(0);
        this.settlementTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (e.getValueIsAdjusting() && (index = ConstructionSettlementPanel.this.settlementTable.getSelectedRow()) > -1) {
                    if (ConstructionSettlementPanel.this.settlementTableModel.isFailureRow(index)) {
                        ConstructionSettlementPanel.this.errorMessageLabel.setText("Settlement cannot be used in the mission (see red cells).");
                        ConstructionSettlementPanel.this.getWizard().setButtons(false);
                    } else {
                        ConstructionSettlementPanel.this.errorMessageLabel.setText(" ");
                        ConstructionSettlementPanel.this.getWizard().setButtons(true);
                    }
                }
            }
        });
        this.settlementTable.setPreferredScrollableViewportSize(this.settlementTable.getPreferredSize());
        settlementScrollPane.setViewportView(this.settlementTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setFont(this.errorMessageLabel.getFont().deriveFont(1));
        this.errorMessageLabel.setAlignmentX(0.5f);
        this.add(this.errorMessageLabel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    void clearInfo() {
        this.settlementTable.clearSelection();
        this.errorMessageLabel.setText(" ");
    }

    @Override
    boolean commitChanges() {
        int selectedIndex = this.settlementTable.getSelectedRow();
        Settlement selectedSettlement = (Settlement)this.settlementTableModel.getUnit(selectedIndex);
        this.getWizard().getMissionData().setConstructionSettlement(selectedSettlement);
        return true;
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    void updatePanel() {
        this.settlementTableModel.updateTable();
        this.settlementTable.setPreferredScrollableViewportSize(this.settlementTable.getPreferredSize());
    }

    private static class SettlementTableModel
    extends UnitTableModel {
        private SettlementTableModel() {
            UnitManager manager = Simulation.instance().getUnitManager();
            Collection settlements = CollectionUtils.sortByName((Collection)manager.getSettlements());
            Iterator i = settlements.iterator();
            while (i.hasNext()) {
                this.units.add(i.next());
            }
            this.columns.add("Name");
            this.columns.add("Population");
            this.columns.add("Construction Sites");
            this.columns.add("Light Utility Vehicles");
            this.columns.add("EVA Suits");
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.units.size()) {
                try {
                    Settlement settlement = (Settlement)this.getUnit(row);
                    Inventory inv = settlement.getInventory();
                    if (column == 0) {
                        result = settlement.getName();
                    } else if (column == 1) {
                        result = settlement.getCurrentPopulationNum();
                    } else if (column == 2) {
                        int numSites = settlement.getConstructionManager().getConstructionSites().size();
                        result = numSites;
                    } else if (column == 3) {
                        result = inv.findNumUnitsOfClass(LightUtilityVehicle.class);
                    } else if (column == 4) {
                        result = inv.findNumUnitsOfClass(EVASuit.class);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        void updateTable() {
            this.fireTableStructureChanged();
        }

        @Override
        boolean isFailureCell(int row, int column) {
            boolean result = false;
            Settlement settlement = (Settlement)this.getUnit(row);
            try {
                if (column == 1 && settlement.getCurrentPopulationNum() == 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return result;
        }
    }
}

