/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.ConstructionProjectPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.ConstructionSettlementPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.ConstructionVehiclePanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.DestinationSettlementPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.EmergencySupplyPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.ExplorationSitesPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.FieldSitePanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.LeadResearcherPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.LightUtilityVehiclePanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.MembersPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.MiningSitePanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.MissionDataBean;
import org.mars_sim.msp.ui.swing.tool.mission.create.ProspectingSitePanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.RendezvousVehiclePanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.SalvageProjectPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.SalvageSettlementPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.SalvageVehiclePanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.StartingSettlementPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.StudyPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.TradeGoodsPanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.TypePanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.VehiclePanel;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

public class CreateMissionWizard
extends JDialog {
    private JPanel infoPane;
    private JButton prevButton;
    private JButton nextButton;
    private JButton finalButton;
    private MissionDataBean missionBean = new MissionDataBean();
    private List<WizardPanel> wizardPanels;
    private int displayPanelIndex;

    public CreateMissionWizard(Frame owner) {
        super(owner, "Create Mission Wizard", true);
        this.infoPane = new JPanel(new CardLayout());
        this.infoPane.setBorder(new MarsPanelBorder());
        this.add((Component)this.infoPane, "Center");
        this.wizardPanels = new ArrayList<WizardPanel>();
        this.displayPanelIndex = 0;
        this.addWizardPanel(new TypePanel(this));
        this.addWizardPanel(new StartingSettlementPanel(this));
        JPanel bottomButtonPane = new JPanel();
        this.add((Component)bottomButtonPane, "South");
        this.prevButton = new JButton("Previous");
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateMissionWizard.this.getCurrentWizardPanel().clearInfo();
                CreateMissionWizard.this.displayPanelIndex--;
                CardLayout layout = (CardLayout)CreateMissionWizard.this.infoPane.getLayout();
                layout.show(CreateMissionWizard.this.infoPane, CreateMissionWizard.this.getCurrentWizardPanel().getPanelName());
                CreateMissionWizard.this.nextButton.setEnabled(true);
                if (CreateMissionWizard.this.displayPanelIndex == 0) {
                    CreateMissionWizard.this.prevButton.setEnabled(false);
                }
            }
        });
        this.prevButton.setEnabled(false);
        bottomButtonPane.add(this.prevButton);
        this.nextButton = new JButton("Next");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreateMissionWizard.this.getCurrentWizardPanel().commitChanges()) {
                    CreateMissionWizard.this.displayPanelIndex++;
                    CreateMissionWizard.this.setButtons(false);
                    CardLayout layout = (CardLayout)CreateMissionWizard.this.infoPane.getLayout();
                    WizardPanel currentPanel = CreateMissionWizard.this.getCurrentWizardPanel();
                    currentPanel.updatePanel();
                    layout.show(CreateMissionWizard.this.infoPane, currentPanel.getPanelName());
                }
            }
        });
        this.nextButton.setEnabled(false);
        bottomButtonPane.add(this.nextButton);
        this.finalButton = new JButton("Final");
        this.finalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CreateMissionWizard.this.getCurrentWizardPanel().commitChanges()) {
                    CreateMissionWizard.this.missionBean.createMission();
                    CreateMissionWizard.this.dispose();
                }
            }
        });
        this.finalButton.setEnabled(false);
        bottomButtonPane.add(this.finalButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateMissionWizard.this.dispose();
            }
        });
        bottomButtonPane.add(cancelButton);
        this.pack();
        this.setSize(new Dimension(700, 550));
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
        this.setVisible(true);
    }

    private WizardPanel getCurrentWizardPanel() {
        return this.wizardPanels.get(this.displayPanelIndex);
    }

    void setFinalWizardPanels() {
        int numPanels = this.wizardPanels.size();
        for (int x = 1; x < numPanels; ++x) {
            this.wizardPanels.remove(1);
        }
        if (this.missionBean.getType().equals("Travel to Settlement")) {
            this.addWizardPanel(new StartingSettlementPanel(this));
            this.addWizardPanel(new VehiclePanel(this));
            this.addWizardPanel(new MembersPanel(this));
            this.addWizardPanel(new DestinationSettlementPanel(this));
        } else if (this.missionBean.getType().equals("Rescue/Salvage Vehicle")) {
            this.addWizardPanel(new StartingSettlementPanel(this));
            this.addWizardPanel(new VehiclePanel(this));
            this.addWizardPanel(new MembersPanel(this));
            this.addWizardPanel(new RendezvousVehiclePanel(this));
        } else if (this.missionBean.getType().equals("Ice Prospecting")) {
            this.addWizardPanel(new StartingSettlementPanel(this));
            this.addWizardPanel(new VehiclePanel(this));
            this.addWizardPanel(new MembersPanel(this));
            this.addWizardPanel(new ProspectingSitePanel(this));
        } else if (this.missionBean.getType().equals("Regolith Prospecting")) {
            this.addWizardPanel(new StartingSettlementPanel(this));
            this.addWizardPanel(new VehiclePanel(this));
            this.addWizardPanel(new MembersPanel(this));
            this.addWizardPanel(new ProspectingSitePanel(this));
        } else if (this.missionBean.getType().equals("Mineral Exploration")) {
            this.addWizardPanel(new StartingSettlementPanel(this));
            this.addWizardPanel(new VehiclePanel(this));
            this.addWizardPanel(new MembersPanel(this));
            this.addWizardPanel(new ExplorationSitesPanel(this));
        } else if (this.missionBean.getType().equals("Trade")) {
            this.addWizardPanel(new StartingSettlementPanel(this));
            this.addWizardPanel(new VehiclePanel(this));
            this.addWizardPanel(new MembersPanel(this));
            this.addWizardPanel(new DestinationSettlementPanel(this));
            this.addWizardPanel(new TradeGoodsPanel(this, false));
            this.addWizardPanel(new TradeGoodsPanel(this, true));
        } else if (this.missionBean.getType().equals("Mining")) {
            this.addWizardPanel(new StartingSettlementPanel(this));
            this.addWizardPanel(new VehiclePanel(this));
            this.addWizardPanel(new MembersPanel(this));
            this.addWizardPanel(new LightUtilityVehiclePanel(this));
            this.addWizardPanel(new MiningSitePanel(this));
        } else if (this.missionBean.getType().equals("Building Construction")) {
            this.addWizardPanel(new ConstructionSettlementPanel(this));
            this.addWizardPanel(new MembersPanel(this));
            this.addWizardPanel(new ConstructionProjectPanel(this));
            this.addWizardPanel(new ConstructionVehiclePanel(this));
        } else if (this.missionBean.getType().equals("Building Salvage")) {
            this.addWizardPanel(new SalvageSettlementPanel(this));
            this.addWizardPanel(new MembersPanel(this));
            this.addWizardPanel(new SalvageProjectPanel(this));
            this.addWizardPanel(new SalvageVehiclePanel(this));
        } else if (this.missionBean.getType().equals("Areology Study Field Mission")) {
            this.addWizardPanel(new StudyPanel(this));
            this.addWizardPanel(new LeadResearcherPanel(this));
            this.addWizardPanel(new VehiclePanel(this));
            this.addWizardPanel(new MembersPanel(this));
            this.addWizardPanel(new FieldSitePanel(this));
        } else if (this.missionBean.getType().equals("Biology Study Field Mission")) {
            this.addWizardPanel(new StudyPanel(this));
            this.addWizardPanel(new LeadResearcherPanel(this));
            this.addWizardPanel(new VehiclePanel(this));
            this.addWizardPanel(new MembersPanel(this));
            this.addWizardPanel(new FieldSitePanel(this));
        } else if (this.missionBean.getType().equals("Emergency Supply Mission")) {
            this.addWizardPanel(new StartingSettlementPanel(this));
            this.addWizardPanel(new VehiclePanel(this));
            this.addWizardPanel(new MembersPanel(this));
            this.addWizardPanel(new DestinationSettlementPanel(this));
            this.addWizardPanel(new EmergencySupplyPanel(this));
        }
    }

    private void addWizardPanel(WizardPanel newWizardPanel) {
        this.wizardPanels.add(newWizardPanel);
        this.infoPane.add((Component)newWizardPanel, newWizardPanel.getPanelName());
    }

    MissionDataBean getMissionData() {
        return this.missionBean;
    }

    void setButtons(boolean nextEnabled) {
        this.prevButton.setEnabled(this.displayPanelIndex > 0);
        if (nextEnabled) {
            this.nextButton.setEnabled(this.displayPanelIndex < this.wizardPanels.size() - 1);
            this.finalButton.setEnabled(this.displayPanelIndex == this.wizardPanels.size() - 1);
        } else {
            this.nextButton.setEnabled(false);
            this.finalButton.setEnabled(false);
        }
    }
}

