/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.NumberFormatter;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.equipment.Bag;
import org.mars_sim.msp.core.equipment.Barrel;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.equipment.GasCanister;
import org.mars_sim.msp.core.person.ai.mission.TradeUtil;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Phase;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.MissionDataBean;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

public class EmergencySupplyPanel
extends WizardPanel {
    private JLabel errorMessageLabel;
    private JTable supplyTable;
    private JTable cargoTable;
    private JLabel availableSupplyLabel;
    private SupplyTableModel supplyTableModel;
    private CargoTableModel cargoTableModel;
    private JButton leftArrowButton;
    private JButton rightArrowButton;
    private JFormattedTextField amountTextField;
    private NumberFormatter formatter;

    EmergencySupplyPanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BorderLayout());
        this.setBorder(new MarsPanelBorder());
        JLabel titleLabel = new JLabel("Choose supply amounts to deliver.", 0);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        this.add((Component)titleLabel, "North");
        JPanel availableSupplyPane = new JPanel(new BorderLayout());
        availableSupplyPane.setPreferredSize(new Dimension(260, 100));
        this.add((Component)availableSupplyPane, "West");
        this.availableSupplyLabel = new JLabel("Available supply at ", 0);
        availableSupplyPane.add((Component)this.availableSupplyLabel, "North");
        JScrollPane supplyScrollPane = new JScrollPane();
        availableSupplyPane.add((Component)supplyScrollPane, "Center");
        this.supplyTableModel = new SupplyTableModel();
        this.supplyTable = new JTable(this.supplyTableModel);
        this.supplyTable.setRowSelectionAllowed(true);
        this.supplyTable.setSelectionMode(0);
        this.supplyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() && EmergencySupplyPanel.this.supplyTable.getSelectedRow() > -1) {
                    EmergencySupplyPanel.this.cargoTable.clearSelection();
                    EmergencySupplyPanel.this.errorMessageLabel.setText(" ");
                    EmergencySupplyPanel.this.leftArrowButton.setEnabled(false);
                    EmergencySupplyPanel.this.amountTextField.setEnabled(true);
                    EmergencySupplyPanel.this.rightArrowButton.setEnabled(true);
                }
            }
        });
        supplyScrollPane.setViewportView(this.supplyTable);
        JPanel amountOuterPanel = new JPanel(new FlowLayout(1));
        this.add((Component)amountOuterPanel, "Center");
        JPanel amountControlPane = new JPanel(new BorderLayout());
        amountOuterPanel.add(amountControlPane);
        JLabel amountLabel = new JLabel("Amount", 0);
        amountControlPane.add((Component)amountLabel, "North");
        this.leftArrowButton = new JButton("<");
        this.leftArrowButton.setEnabled(false);
        this.leftArrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int amount = (Integer)EmergencySupplyPanel.this.formatter.stringToValue(EmergencySupplyPanel.this.amountTextField.getText());
                    int selectedGoodIndex = EmergencySupplyPanel.this.cargoTable.getSelectedRow();
                    if (selectedGoodIndex > -1) {
                        Good good = (Good)EmergencySupplyPanel.this.cargoTableModel.cargoList.get(selectedGoodIndex);
                        int currentAmount = (Integer)EmergencySupplyPanel.this.cargoTableModel.cargoMap.get(good);
                        if (amount <= currentAmount) {
                            EmergencySupplyPanel.this.cargoTableModel.removeGoodAmount(good, amount);
                            EmergencySupplyPanel.this.supplyTableModel.addGoodAmount(good, amount);
                            EmergencySupplyPanel.this.errorMessageLabel.setText(" ");
                        } else {
                            EmergencySupplyPanel.this.errorMessageLabel.setText("Amount to remove is larger than cargo amount.");
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        amountControlPane.add((Component)this.leftArrowButton, "West");
        this.formatter = new NumberFormatter();
        this.formatter.setAllowsInvalid(false);
        this.formatter.setMinimum(Integer.valueOf(0));
        this.formatter.setMaximum(Integer.valueOf(9999));
        this.amountTextField = new JFormattedTextField(this.formatter);
        this.amountTextField.setValue(0);
        this.amountTextField.setColumns(5);
        this.amountTextField.setHorizontalAlignment(4);
        this.amountTextField.setEnabled(false);
        amountControlPane.add((Component)this.amountTextField, "Center");
        this.rightArrowButton = new JButton(">");
        this.rightArrowButton.setEnabled(false);
        this.rightArrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int amount = (Integer)EmergencySupplyPanel.this.formatter.stringToValue(EmergencySupplyPanel.this.amountTextField.getText());
                    int selectedGoodIndex = EmergencySupplyPanel.this.supplyTable.getSelectedRow();
                    if (selectedGoodIndex > -1) {
                        Good good = (Good)EmergencySupplyPanel.this.supplyTableModel.goodsList.get(selectedGoodIndex);
                        int currentAmount = (Integer)EmergencySupplyPanel.this.supplyTableModel.goodsMap.get(good);
                        if (amount <= currentAmount) {
                            if (good.getCategory().equals("vehicle") && (amount > 1 || EmergencySupplyPanel.this.cargoTableModel.hasCargoVehicle())) {
                                EmergencySupplyPanel.this.errorMessageLabel.setText("Only one vehicle can be traded.");
                            } else {
                                EmergencySupplyPanel.this.supplyTableModel.removeGoodAmount(good, amount);
                                EmergencySupplyPanel.this.cargoTableModel.addGoodAmount(good, amount);
                                EmergencySupplyPanel.this.errorMessageLabel.setText(" ");
                            }
                        } else {
                            EmergencySupplyPanel.this.errorMessageLabel.setText("Amount to add is larger than available amount.");
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        amountControlPane.add((Component)this.rightArrowButton, "East");
        JPanel cargoPane = new JPanel(new BorderLayout());
        cargoPane.setPreferredSize(new Dimension(260, 100));
        this.add((Component)cargoPane, "East");
        JLabel cargoLabel = new JLabel("Cargo", 0);
        cargoPane.add((Component)cargoLabel, "North");
        JScrollPane cargoScrollPane = new JScrollPane();
        cargoPane.add((Component)cargoScrollPane, "Center");
        this.cargoTableModel = new CargoTableModel();
        this.cargoTable = new JTable(this.cargoTableModel);
        this.cargoTable.setRowSelectionAllowed(true);
        this.cargoTable.setSelectionMode(0);
        this.cargoTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() && EmergencySupplyPanel.this.cargoTable.getSelectedRow() > -1) {
                    EmergencySupplyPanel.this.cargoTable.clearSelection();
                    EmergencySupplyPanel.this.errorMessageLabel.setText(" ");
                    EmergencySupplyPanel.this.leftArrowButton.setEnabled(true);
                    EmergencySupplyPanel.this.amountTextField.setEnabled(true);
                    EmergencySupplyPanel.this.rightArrowButton.setEnabled(false);
                }
            }
        });
        cargoScrollPane.setViewportView(this.cargoTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setForeground(Color.RED);
        this.add((Component)this.errorMessageLabel, "South");
    }

    @Override
    String getPanelName() {
        return "Emergency Supplies";
    }

    @Override
    boolean commitChanges() {
        boolean result = false;
        try {
            if (this.hasEnoughContainers()) {
                MissionDataBean missionData = this.getWizard().getMissionData();
                missionData.setEmergencyGoods(this.cargoTableModel.getCargoGoods());
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return result;
    }

    @Override
    void clearInfo() {
        this.supplyTable.clearSelection();
        this.cargoTable.clearSelection();
        this.leftArrowButton.setEnabled(false);
        this.rightArrowButton.setEnabled(false);
        this.amountTextField.setEnabled(false);
    }

    @Override
    void updatePanel() {
        MissionDataBean missionData = this.getWizard().getMissionData();
        String settlementName = missionData.getStartingSettlement().getName();
        this.availableSupplyLabel.setText("Available supplies at " + settlementName);
        this.supplyTableModel.updateTable();
        this.cargoTableModel.updateTable();
        this.getWizard().setButtons(true);
    }

    private boolean hasEnoughContainers() {
        boolean result = true;
        HashMap<Class, Integer> containerMap = new HashMap<Class, Integer>(3);
        containerMap.put(Bag.class, this.getNumberOfCargoContainers(Bag.class));
        containerMap.put(Barrel.class, this.getNumberOfCargoContainers(Barrel.class));
        containerMap.put(GasCanister.class, this.getNumberOfCargoContainers(GasCanister.class));
        Map<Good, Integer> cargoGoods = this.cargoTableModel.getCargoGoods();
        for (Good good : cargoGoods.keySet()) {
            if (!good.getCategory().equals("amount resource")) continue;
            AmountResource resource = (AmountResource)good.getObject();
            Phase phase = resource.getPhase();
            Class containerType = this.getContainerTypeNeeded(phase);
            int containerNum = (Integer)containerMap.get(containerType);
            Equipment container = EquipmentFactory.getEquipment((Class)containerType, (Coordinates)new Coordinates(0.0, 0.0), (boolean)true);
            double capacity = container.getInventory().getAmountResourceCapacity(resource, false);
            double totalCapacity = (double)containerNum * capacity;
            double resourceAmount = cargoGoods.get(good).intValue();
            if (resourceAmount > totalCapacity) {
                double neededCapacity = resourceAmount - totalCapacity;
                int neededContainerNum = (int)Math.ceil(neededCapacity / capacity);
                String containerName = container.getName().toLowerCase();
                if (neededContainerNum > 1) {
                    containerName = containerName + "s";
                }
                this.errorMessageLabel.setText(neededContainerNum + " " + containerName + " needed to hold " + resource.getName());
                result = false;
                break;
            }
            int neededContainerNum = (int)Math.ceil(resourceAmount / capacity);
            int remainingContainerNum = containerNum - neededContainerNum;
            containerMap.put(containerType, remainingContainerNum);
        }
        return result;
    }

    private int getNumberOfCargoContainers(Class containerType) {
        int result = 0;
        Good containerGood = GoodsUtil.getEquipmentGood((Class)containerType);
        Map<Good, Integer> cargoGoods = this.cargoTableModel.getCargoGoods();
        if (cargoGoods.containsKey(containerGood)) {
            result = cargoGoods.get(containerGood);
        }
        return result;
    }

    private Class getContainerTypeNeeded(Phase phase) {
        Class<Bag> result = null;
        if (phase.equals((Object)Phase.SOLID)) {
            result = Bag.class;
        }
        if (phase.equals((Object)Phase.LIQUID)) {
            result = Barrel.class;
        }
        if (phase.equals((Object)Phase.GAS)) {
            result = GasCanister.class;
        }
        return result;
    }

    private List<AmountResource> getEmergencyResources() {
        ArrayList<AmountResource> result = new ArrayList<AmountResource>(4);
        result.add(AmountResource.findAmountResource((String)"oxygen"));
        result.add(AmountResource.findAmountResource((String)"water"));
        result.add(AmountResource.findAmountResource((String)"food"));
        result.add(AmountResource.findAmountResource((String)"methane"));
        return result;
    }

    private class CargoTableModel
    extends AbstractTableModel {
        private Map<Good, Integer> cargoMap;
        private List<Good> cargoList = new ArrayList<Good>();

        private CargoTableModel() {
            this.cargoMap = new HashMap<Good, Integer>();
        }

        @Override
        public int getRowCount() {
            return this.cargoList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Good";
            }
            return "Amount";
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.cargoList.size()) {
                Good good = this.cargoList.get(row);
                result = column == 0 ? good.getName() : this.cargoMap.get(good);
            }
            return result;
        }

        void updateTable() {
            this.cargoList.clear();
            this.cargoMap.clear();
            this.fireTableDataChanged();
        }

        void addGoodAmount(Good good, int amount) {
            if (amount > 0) {
                if (this.cargoList.contains(good)) {
                    amount += this.cargoMap.get(good).intValue();
                } else {
                    this.cargoList.add(good);
                }
                this.cargoMap.put(good, amount);
                this.fireTableDataChanged();
            }
        }

        void removeGoodAmount(Good good, int amount) {
            if (amount > 0) {
                int finalAmount;
                int currentAmount = 0;
                if (this.cargoList.contains(good)) {
                    currentAmount = this.cargoMap.get(good);
                }
                if ((finalAmount = currentAmount - amount) > 0) {
                    int selectedGoodIndex = EmergencySupplyPanel.this.cargoTable.getSelectedRow();
                    this.cargoMap.put(good, finalAmount);
                    this.fireTableDataChanged();
                    if (selectedGoodIndex > -1) {
                        EmergencySupplyPanel.this.cargoTable.setRowSelectionInterval(selectedGoodIndex, selectedGoodIndex);
                    }
                } else {
                    this.cargoList.remove(good);
                    this.cargoMap.remove(good);
                    this.fireTableDataChanged();
                }
            }
        }

        Map<Good, Integer> getCargoGoods() {
            return new HashMap<Good, Integer>(this.cargoMap);
        }

        private boolean hasCargoVehicle() {
            boolean result = false;
            Iterator<Good> i = this.cargoList.iterator();
            while (i.hasNext()) {
                if (!i.next().getCategory().equals("vehicle")) continue;
                result = true;
            }
            return result;
        }
    }

    private class SupplyTableModel
    extends AbstractTableModel {
        private Map<Good, Integer> goodsMap;
        private List<Good> goodsList = GoodsUtil.getGoodsList();

        private SupplyTableModel() {
            this.goodsMap = new HashMap<Good, Integer>(this.goodsList.size());
            Iterator<Good> i = this.goodsList.iterator();
            while (i.hasNext()) {
                this.goodsMap.put(i.next(), 0);
            }
        }

        @Override
        public int getRowCount() {
            return this.goodsList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Good";
            }
            return "Amount";
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.goodsList.size()) {
                Good good = this.goodsList.get(row);
                result = column == 0 ? good.getName() : this.goodsMap.get(good);
            }
            return result;
        }

        void updateTable() {
            MissionDataBean missionData = EmergencySupplyPanel.this.getWizard().getMissionData();
            Settlement settlement = missionData.getStartingSettlement();
            for (Good good : this.goodsList) {
                try {
                    int amount = (int)TradeUtil.getNumInInventory((Good)good, (Inventory)settlement.getInventory());
                    if (this.checkForVehicle(good)) {
                        --amount;
                    }
                    this.goodsMap.put(good, amount);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            this.fireTableDataChanged();
        }

        private boolean checkForVehicle(Good good) {
            boolean result = false;
            if (good.getCategory().equals("vehicle")) {
                String missionRoverName = EmergencySupplyPanel.this.getWizard().getMissionData().getRover().getDescription();
                if (good.getName().equalsIgnoreCase(missionRoverName)) {
                    result = true;
                }
            }
            return result;
        }

        void addGoodAmount(Good good, int amount) {
            if (amount > 0) {
                this.goodsMap.put(good, amount += this.goodsMap.get(good).intValue());
                this.fireTableDataChanged();
            }
        }

        void removeGoodAmount(Good good, int amount) {
            if (amount > 0) {
                int finalAmount = this.goodsMap.get(good) - amount;
                this.goodsMap.put(good, finalAmount);
                int selectedGoodIndex = EmergencySupplyPanel.this.supplyTable.getSelectedRow();
                this.fireTableDataChanged();
                if (selectedGoodIndex > -1) {
                    EmergencySupplyPanel.this.supplyTable.setRowSelectionInterval(selectedGoodIndex, selectedGoodIndex);
                }
            }
        }
    }
}

