/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.IntPoint;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.map.EllipseLayer;
import org.mars_sim.msp.ui.swing.tool.map.MapPanel;
import org.mars_sim.msp.ui.swing.tool.map.MapUtils;
import org.mars_sim.msp.ui.swing.tool.map.NavpointEditLayer;
import org.mars_sim.msp.ui.swing.tool.map.UnitIconMapLayer;
import org.mars_sim.msp.ui.swing.tool.map.UnitLabelMapLayer;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

public class FieldSitePanel
extends WizardPanel {
    private static final String NAME = "Field Research Site";
    private static final double RANGE_MODIFIER = 0.95;
    private MapPanel mapPane;
    private EllipseLayer ellipseLayer;
    private NavpointEditLayer navLayer;
    private boolean navSelected;
    private IntPoint navOffset;
    private JLabel locationLabel;
    private int pixelRange;

    FieldSitePanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel titleLabel = new JLabel("Choose field research site.");
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        titleLabel.setAlignmentX(0.5f);
        this.add(titleLabel);
        this.mapPane = new MapPanel();
        this.mapPane.addMapLayer(new UnitIconMapLayer(this.mapPane));
        this.mapPane.addMapLayer(new UnitLabelMapLayer());
        this.ellipseLayer = new EllipseLayer(Color.GREEN);
        this.mapPane.addMapLayer(this.ellipseLayer);
        this.navLayer = new NavpointEditLayer(this.mapPane, false);
        this.mapPane.addMapLayer(this.navLayer);
        this.mapPane.addMouseListener(new NavpointMouseListener());
        this.mapPane.addMouseMotionListener(new NavpointMouseMotionListener());
        this.mapPane.setMaximumSize(this.mapPane.getPreferredSize());
        this.mapPane.setAlignmentX(0.5f);
        this.add(this.mapPane);
        this.locationLabel = new JLabel("Location: ", 0);
        this.locationLabel.setFont(this.locationLabel.getFont().deriveFont(1));
        this.locationLabel.setAlignmentX(0.5f);
        this.add(this.locationLabel);
        this.add(Box.createVerticalStrut(10));
        JLabel instructionLabel = new JLabel("Drag navpoint flag to desired field research site");
        instructionLabel.setFont(instructionLabel.getFont().deriveFont(1));
        instructionLabel.setAlignmentX(0.5f);
        this.add(instructionLabel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    void clearInfo() {
        this.getWizard().setButtons(false);
        this.navLayer.clearNavpointPositions();
    }

    @Override
    boolean commitChanges() {
        IntPoint navpointPixel = this.navLayer.getNavpointPosition(0);
        Coordinates navpoint = this.getCenterCoords().convertRectToSpherical((double)(navpointPixel.getiX() - 150), (double)(navpointPixel.getiY() - 150), 458.3662361046586);
        this.getWizard().getMissionData().setFieldSite(navpoint);
        return true;
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    void updatePanel() {
        try {
            double range = this.getWizard().getMissionData().getRover().getRange() * 0.95 / 2.0;
            this.pixelRange = this.convertRadiusToMapPixels(range);
            this.ellipseLayer.setEllipseDetails(new IntPoint(150, 150), new IntPoint(150, 150), this.pixelRange * 2);
            IntPoint initialNavpointPos = new IntPoint(150, 150 - this.pixelRange / 2);
            this.navLayer.addNavpointPosition(initialNavpointPos);
            Coordinates initialNavpoint = this.getCenterCoords().convertRectToSpherical(0.0, (double)(-1 * (this.pixelRange / 2)), 458.3662361046586);
            this.locationLabel.setText("Location: " + initialNavpoint.getFormattedString());
            this.mapPane.showMap(this.getCenterCoords());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getWizard().setButtons(true);
    }

    private Coordinates getCenterCoords() {
        return this.getWizard().getMissionData().getStartingSettlement().getCoordinates();
    }

    private int convertRadiusToMapPixels(double radius) {
        return MapUtils.getPixelDistance(radius, "surface map");
    }

    private class NavpointMouseMotionListener
    extends MouseMotionAdapter {
        private NavpointMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            int displayY;
            int displayX;
            IntPoint displayPos;
            if (FieldSitePanel.this.navSelected && this.withinBounds(displayPos = new IntPoint(displayX = event.getPoint().x + FieldSitePanel.this.navOffset.getiX(), displayY = event.getPoint().y + FieldSitePanel.this.navOffset.getiY()))) {
                FieldSitePanel.this.navLayer.setNavpointPosition(0, displayPos);
                Coordinates center = FieldSitePanel.this.getWizard().getMissionData().getStartingSettlement().getCoordinates();
                Coordinates navpoint = center.convertRectToSpherical((double)(displayPos.getiX() - 150), (double)(displayPos.getiY() - 150), 458.3662361046586);
                FieldSitePanel.this.locationLabel.setText("Location: " + navpoint.getFormattedString());
                FieldSitePanel.this.mapPane.repaint();
            }
        }

        private boolean withinBounds(IntPoint position) {
            int radius;
            boolean result = true;
            if (!FieldSitePanel.this.navLayer.withinDisplayEdges(position)) {
                result = false;
            }
            if ((radius = (int)Math.round(Math.sqrt(Math.pow(150.0 - position.getX(), 2.0) + Math.pow(150.0 - position.getY(), 2.0)))) > FieldSitePanel.this.pixelRange) {
                result = false;
            }
            return result;
        }
    }

    private class NavpointMouseListener
    extends MouseAdapter {
        private NavpointMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (FieldSitePanel.this.navLayer.overNavIcon(event.getX(), event.getY()) == 0) {
                FieldSitePanel.this.navSelected = true;
                FieldSitePanel.this.navLayer.selectNavpoint(0);
                FieldSitePanel.this.navOffset = this.determineOffset(event.getX(), event.getY());
                FieldSitePanel.this.ellipseLayer.setDisplayEllipse(true);
                FieldSitePanel.this.mapPane.repaint();
            }
        }

        private IntPoint determineOffset(int x, int y) {
            int xOffset = FieldSitePanel.this.navLayer.getNavpointPosition(0).getiX() - x;
            int yOffset = FieldSitePanel.this.navLayer.getNavpointPosition(0).getiY() - y;
            return new IntPoint(xOffset, yOffset);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            FieldSitePanel.this.navSelected = false;
            FieldSitePanel.this.navLayer.clearSelectedNavpoint();
            FieldSitePanel.this.ellipseLayer.setDisplayEllipse(false);
            FieldSitePanel.this.mapPane.repaint();
        }
    }
}

