/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.RescueSalvageVehicle;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableCellRenderer;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableModel;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

class RendezvousVehiclePanel
extends WizardPanel {
    private static final String NAME = "Rendezvous Vehicle";
    private VehicleTableModel vehicleTableModel;
    private JTable vehicleTable;
    private JLabel errorMessageLabel;

    RendezvousVehiclePanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel selectVehicleLabel = new JLabel("Select a rover to rescue/salvage.", 0);
        selectVehicleLabel.setFont(selectVehicleLabel.getFont().deriveFont(1));
        selectVehicleLabel.setAlignmentX(0.5f);
        this.add(selectVehicleLabel);
        JPanel vehiclePane = new JPanel(new BorderLayout(0, 0));
        vehiclePane.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        vehiclePane.setAlignmentX(0.5f);
        this.add(vehiclePane);
        JScrollPane vehicleScrollPane = new JScrollPane();
        vehiclePane.add((Component)vehicleScrollPane, "Center");
        this.vehicleTableModel = new VehicleTableModel();
        this.vehicleTable = new JTable(this.vehicleTableModel);
        this.vehicleTable.setDefaultRenderer(Object.class, new UnitTableCellRenderer(this.vehicleTableModel));
        this.vehicleTable.setRowSelectionAllowed(true);
        this.vehicleTable.setSelectionMode(0);
        this.vehicleTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (e.getValueIsAdjusting() && (index = RendezvousVehiclePanel.this.vehicleTable.getSelectedRow()) > -1) {
                    if (RendezvousVehiclePanel.this.vehicleTableModel.isFailureRow(index)) {
                        RendezvousVehiclePanel.this.errorMessageLabel.setText("Rover cannot be rescued/salvaged (see red cells).");
                        RendezvousVehiclePanel.this.getWizard().setButtons(false);
                    } else {
                        RendezvousVehiclePanel.this.errorMessageLabel.setText(" ");
                        RendezvousVehiclePanel.this.getWizard().setButtons(true);
                    }
                }
            }
        });
        vehicleScrollPane.setViewportView(this.vehicleTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setFont(this.errorMessageLabel.getFont().deriveFont(1));
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setAlignmentX(0.5f);
        this.add(this.errorMessageLabel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    boolean commitChanges() {
        int selectedIndex = this.vehicleTable.getSelectedRow();
        Rover selectedVehicle = (Rover)this.vehicleTableModel.getUnit(selectedIndex);
        this.getWizard().getMissionData().setRescueRover(selectedVehicle);
        return true;
    }

    @Override
    void clearInfo() {
        this.vehicleTable.clearSelection();
        this.errorMessageLabel.setText(" ");
    }

    @Override
    void updatePanel() {
        this.vehicleTableModel.updateTable();
        this.vehicleTable.setPreferredScrollableViewportSize(this.vehicleTable.getPreferredSize());
    }

    private class VehicleTableModel
    extends UnitTableModel {
        private VehicleTableModel() {
            this.columns.add("Name");
            this.columns.add("Distance");
            this.columns.add("Crew");
            this.columns.add("Oxygen");
            this.columns.add("Water");
            this.columns.add("Food");
            this.columns.add("Rescuing Rover");
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.units.size()) {
                Rover vehicle = (Rover)this.getUnit(row);
                Inventory inv = vehicle.getInventory();
                try {
                    if (column == 0) {
                        result = vehicle.getName();
                    } else {
                        if (column == 1) {
                            Settlement startingSettlement = RendezvousVehiclePanel.this.getWizard().getMissionData().getStartingSettlement();
                            double distance = startingSettlement.getCoordinates().getDistance(vehicle.getCoordinates());
                            return (int)distance;
                        }
                        if (column == 2) {
                            result = vehicle.getCrewNum();
                        } else if (column == 3) {
                            AmountResource oxygen = AmountResource.findAmountResource((String)"oxygen");
                            result = (int)inv.getAmountResourceStored(oxygen, false);
                        } else if (column == 4) {
                            AmountResource water = AmountResource.findAmountResource((String)"water");
                            result = (int)inv.getAmountResourceStored(water, false);
                        } else if (column == 5) {
                            AmountResource food = AmountResource.findAmountResource((String)"food");
                            result = (int)inv.getAmountResourceStored(food, false);
                        } else if (column == 6) {
                            Vehicle rescueVehicle = this.getRescueVehicle((Vehicle)vehicle);
                            if (rescueVehicle != null) {
                                return rescueVehicle.getName();
                            }
                            return "None";
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        void updateTable() {
            this.units.clear();
            Settlement startingSettlement = RendezvousVehiclePanel.this.getWizard().getMissionData().getStartingSettlement();
            Collection<Vehicle> emergencyVehicles = this.getEmergencyBeaconVehicles();
            while (emergencyVehicles.size() > 0) {
                Vehicle closestVehicle = null;
                double closestDistance = Double.MAX_VALUE;
                for (Vehicle vehicle : emergencyVehicles) {
                    double distance = startingSettlement.getCoordinates().getDistance(vehicle.getCoordinates());
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    closestVehicle = vehicle;
                }
                this.units.add(closestVehicle);
                emergencyVehicles.remove(closestVehicle);
            }
            this.fireTableDataChanged();
        }

        private Collection<Vehicle> getEmergencyBeaconVehicles() {
            ConcurrentLinkedQueue<Vehicle> result = new ConcurrentLinkedQueue<Vehicle>();
            for (Vehicle vehicle : Simulation.instance().getUnitManager().getVehicles()) {
                if (!vehicle.isEmergencyBeacon()) continue;
                result.add(vehicle);
            }
            return result;
        }

        private Vehicle getRescueVehicle(Vehicle emergencyVehicle) {
            Vehicle result = null;
            MissionManager manager = Simulation.instance().getMissionManager();
            for (Mission mission : manager.getMissions()) {
                Vehicle vehicleTarget;
                if (!(mission instanceof RescueSalvageVehicle) || emergencyVehicle != (vehicleTarget = ((RescueSalvageVehicle)mission).getVehicleTarget())) continue;
                result = ((VehicleMission)mission).getVehicle();
            }
            return result;
        }

        @Override
        boolean isFailureCell(int row, int column) {
            boolean result = false;
            Rover vehicle = (Rover)this.getUnit(row);
            if (column == 1) {
                try {
                    Rover missionVehicle = RendezvousVehiclePanel.this.getWizard().getMissionData().getRover();
                    Settlement startingSettlement = RendezvousVehiclePanel.this.getWizard().getMissionData().getStartingSettlement();
                    double distance = startingSettlement.getCoordinates().getDistance(vehicle.getCoordinates()) * 2.0;
                    if (distance > missionVehicle.getRange()) {
                        result = true;
                    }
                }
                catch (Exception e) {}
            } else if (column == 6 && this.getRescueVehicle((Vehicle)vehicle) != null) {
                result = true;
            }
            return result;
        }
    }
}

