/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.equipment.Bag;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.equipment.SpecimenContainer;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableCellRenderer;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableModel;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

class StartingSettlementPanel
extends WizardPanel {
    private static final String NAME = "Starting Settlement";
    private SettlementTableModel settlementTableModel;
    private JTable settlementTable;
    private JLabel errorMessageLabel;

    StartingSettlementPanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel selectSettlementLabel = new JLabel("Select a starting settlement.", 0);
        selectSettlementLabel.setFont(selectSettlementLabel.getFont().deriveFont(1));
        selectSettlementLabel.setAlignmentX(0.5f);
        this.add(selectSettlementLabel);
        JPanel settlementPane = new JPanel(new BorderLayout(0, 0));
        settlementPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        settlementPane.setAlignmentX(0.5f);
        this.add(settlementPane);
        JScrollPane settlementScrollPane = new JScrollPane();
        settlementPane.add((Component)settlementScrollPane, "Center");
        this.settlementTableModel = new SettlementTableModel();
        this.settlementTable = new JTable(this.settlementTableModel);
        this.settlementTable.setDefaultRenderer(Object.class, new UnitTableCellRenderer(this.settlementTableModel));
        this.settlementTable.setRowSelectionAllowed(true);
        this.settlementTable.setSelectionMode(0);
        this.settlementTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (e.getValueIsAdjusting() && (index = StartingSettlementPanel.this.settlementTable.getSelectedRow()) > -1) {
                    if (StartingSettlementPanel.this.settlementTableModel.isFailureRow(index)) {
                        StartingSettlementPanel.this.errorMessageLabel.setText("Settlement cannot start the mission (see red cells).");
                        StartingSettlementPanel.this.getWizard().setButtons(false);
                    } else {
                        StartingSettlementPanel.this.errorMessageLabel.setText(" ");
                        StartingSettlementPanel.this.getWizard().setButtons(true);
                    }
                }
            }
        });
        this.settlementTable.setPreferredScrollableViewportSize(this.settlementTable.getPreferredSize());
        settlementScrollPane.setViewportView(this.settlementTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setFont(this.errorMessageLabel.getFont().deriveFont(1));
        this.errorMessageLabel.setAlignmentX(0.5f);
        this.add(this.errorMessageLabel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    boolean commitChanges() {
        int selectedIndex = this.settlementTable.getSelectedRow();
        Settlement selectedSettlement = (Settlement)this.settlementTableModel.getUnit(selectedIndex);
        this.getWizard().getMissionData().setStartingSettlement(selectedSettlement);
        return true;
    }

    @Override
    void clearInfo() {
        this.settlementTable.clearSelection();
        this.errorMessageLabel.setText(" ");
    }

    @Override
    void updatePanel() {
        this.settlementTableModel.updateTable();
        this.settlementTable.setPreferredScrollableViewportSize(this.settlementTable.getPreferredSize());
    }

    private class SettlementTableModel
    extends UnitTableModel {
        private SettlementTableModel() {
            UnitManager manager = Simulation.instance().getUnitManager();
            Collection settlements = CollectionUtils.sortByName((Collection)manager.getSettlements());
            Iterator i = settlements.iterator();
            while (i.hasNext()) {
                this.units.add(i.next());
            }
            this.columns.add("Name");
            this.columns.add("Pop.");
            this.columns.add("Rovers");
            this.columns.add("Oxygen");
            this.columns.add("Water");
            this.columns.add("Food");
            this.columns.add("Methane");
            this.columns.add("EVA Suits");
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.units.size()) {
                try {
                    Settlement settlement = (Settlement)this.getUnit(row);
                    Inventory inv = settlement.getInventory();
                    if (column == 0) {
                        result = settlement.getName();
                    } else if (column == 1) {
                        result = settlement.getCurrentPopulationNum();
                    } else if (column == 2) {
                        result = inv.findNumUnitsOfClass(Rover.class);
                    }
                    if (column == 3) {
                        AmountResource oxygen = AmountResource.findAmountResource((String)"oxygen");
                        result = (int)inv.getAmountResourceStored(oxygen, false);
                    } else if (column == 4) {
                        AmountResource water = AmountResource.findAmountResource((String)"water");
                        result = (int)inv.getAmountResourceStored(water, false);
                    } else if (column == 5) {
                        AmountResource food = AmountResource.findAmountResource((String)"food");
                        result = (int)inv.getAmountResourceStored(food, false);
                    } else if (column == 6) {
                        AmountResource methane = AmountResource.findAmountResource((String)"methane");
                        result = (int)inv.getAmountResourceStored(methane, false);
                    } else if (column == 7) {
                        result = inv.findNumUnitsOfClass(EVASuit.class);
                    }
                    String type = StartingSettlementPanel.this.getWizard().getMissionData().getType();
                    if (type.equals("Mineral Exploration")) {
                        if (column == 8) {
                            result = inv.findNumEmptyUnitsOfClass(SpecimenContainer.class, true);
                        }
                    } else if (type.equals("Ice Prospecting") || type.equals("Regolith Prospecting")) {
                        if (column == 8) {
                            result = inv.findNumEmptyUnitsOfClass(Bag.class, true);
                        }
                    } else if (type.equals("Mining")) {
                        if (column == 8) {
                            result = inv.findNumEmptyUnitsOfClass(Bag.class, true);
                        } else if (column == 9) {
                            result = inv.findNumUnitsOfClass(LightUtilityVehicle.class);
                        } else if (column == 10) {
                            Part pneumaticDrill = (Part)Part.findItemResource((String)"pneumatic drill");
                            result = inv.getItemResourceNum((ItemResource)pneumaticDrill);
                        } else if (column == 11) {
                            Part backhoe = (Part)Part.findItemResource((String)"backhoe");
                            result = inv.getItemResourceNum((ItemResource)backhoe);
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        void updateTable() {
            String type;
            if (this.columns.size() > 8) {
                for (int x = 0; x < this.columns.size() - 8; ++x) {
                    this.columns.remove(8);
                }
            }
            if ((type = StartingSettlementPanel.this.getWizard().getMissionData().getType()).equals("Mineral Exploration")) {
                this.columns.add("Specimen Containers");
            } else if (type.equals("Ice Prospecting") || type.equals("Regolith Prospecting")) {
                this.columns.add("Bags");
            } else if (type.equals("Mining")) {
                this.columns.add("Bags");
                this.columns.add("Light Utility Vehicles");
                this.columns.add("Pneumatic Drills");
                this.columns.add("Backhoes");
            }
            this.fireTableStructureChanged();
        }

        @Override
        boolean isFailureCell(int row, int column) {
            boolean result = false;
            Settlement settlement = (Settlement)this.getUnit(row);
            Inventory inv = settlement.getInventory();
            try {
                String type;
                if (column == 1) {
                    if (settlement.getCurrentPopulationNum() == 0) {
                        result = true;
                    }
                } else if (column == 2) {
                    if (inv.findNumUnitsOfClass(Rover.class) == 0) {
                        result = true;
                    }
                } else if (column == 3) {
                    AmountResource oxygen = AmountResource.findAmountResource((String)"oxygen");
                    if (inv.getAmountResourceStored(oxygen, false) < 100.0) {
                        result = true;
                    }
                } else if (column == 4) {
                    AmountResource water = AmountResource.findAmountResource((String)"water");
                    if (inv.getAmountResourceStored(water, false) < 100.0) {
                        result = true;
                    }
                } else if (column == 5) {
                    AmountResource food = AmountResource.findAmountResource((String)"food");
                    if (inv.getAmountResourceStored(food, false) < 100.0) {
                        result = true;
                    }
                } else if (column == 6) {
                    AmountResource methane = AmountResource.findAmountResource((String)"methane");
                    if (inv.getAmountResourceStored(methane, false) < 100.0) {
                        result = true;
                    }
                } else if (column == 7 && inv.findNumUnitsOfClass(EVASuit.class) == 0) {
                    result = true;
                }
                if ((type = StartingSettlementPanel.this.getWizard().getMissionData().getType()).equals("Mineral Exploration")) {
                    if (column == 8 && inv.findNumEmptyUnitsOfClass(SpecimenContainer.class, true) < 20) {
                        result = true;
                    }
                } else if (type.equals("Ice Prospecting") || type.equals("Regolith Prospecting")) {
                    if (column == 8 && inv.findNumEmptyUnitsOfClass(Bag.class, true) < 20) {
                        result = true;
                    }
                } else if (type.equals("Mining")) {
                    Part backhoe;
                    if (column == 8 && inv.findNumEmptyUnitsOfClass(Bag.class, true) < 20) {
                        result = true;
                    }
                    if (column == 9) {
                        if (inv.findNumUnitsOfClass(LightUtilityVehicle.class) == 0) {
                            result = true;
                        }
                    } else if (column == 10) {
                        Part pneumaticDrill = (Part)Part.findItemResource((String)"pneumatic drill");
                        if (inv.getItemResourceNum((ItemResource)pneumaticDrill) == 0) {
                            result = true;
                        }
                    } else if (column == 11 && inv.getItemResourceNum((ItemResource)(backhoe = (Part)Part.findItemResource((String)"backhoe"))) == 0) {
                        result = true;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return result;
        }
    }
}

