/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.science.Science;
import org.mars_sim.msp.core.science.ScienceUtil;
import org.mars_sim.msp.core.science.ScientificStudy;
import org.mars_sim.msp.core.science.ScientificStudyManager;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

public class StudyPanel
extends WizardPanel {
    private static final String NAME = "Scientific Study";
    private StudyTableModel studyTableModel;
    private JTable studyTable;
    private JLabel errorMessageLabel;

    StudyPanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel selectStudyLabel = new JLabel("Select a scientific study.", 0);
        selectStudyLabel.setFont(selectStudyLabel.getFont().deriveFont(1));
        selectStudyLabel.setAlignmentX(0.5f);
        this.add(selectStudyLabel);
        JPanel studyPane = new JPanel(new BorderLayout(0, 0));
        studyPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        studyPane.setAlignmentX(0.5f);
        this.add(studyPane);
        JScrollPane studyScrollPane = new JScrollPane();
        studyPane.add((Component)studyScrollPane, "Center");
        Science studyScience = null;
        String missionType = wizard.getMissionData().getType();
        if ("Areology Study Field Mission".equals(missionType)) {
            studyScience = ScienceUtil.getScience((String)"Areology");
        } else if ("Biology Study Field Mission".equals(missionType)) {
            studyScience = ScienceUtil.getScience((String)"Biology");
        }
        this.studyTableModel = new StudyTableModel(studyScience);
        this.studyTable = new JTable(this.studyTableModel);
        this.studyTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (StudyPanel.this.studyTableModel.isFailureCell(row, column)) {
                    this.setBackground(Color.RED);
                } else if (!isSelected) {
                    this.setBackground(Color.WHITE);
                }
                return result;
            }
        });
        this.studyTable.setRowSelectionAllowed(true);
        this.studyTable.setSelectionMode(0);
        this.studyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (e.getValueIsAdjusting() && (index = StudyPanel.this.studyTable.getSelectedRow()) > -1) {
                    if (StudyPanel.this.studyTableModel.isFailureRow(index)) {
                        StudyPanel.this.errorMessageLabel.setText("mission cannot use study (see red cells).");
                        StudyPanel.this.getWizard().setButtons(false);
                    } else {
                        StudyPanel.this.errorMessageLabel.setText(" ");
                        StudyPanel.this.getWizard().setButtons(true);
                    }
                }
            }
        });
        this.studyTable.setPreferredScrollableViewportSize(this.studyTable.getPreferredSize());
        studyScrollPane.setViewportView(this.studyTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setFont(this.errorMessageLabel.getFont().deriveFont(1));
        this.errorMessageLabel.setAlignmentX(0.5f);
        this.add(this.errorMessageLabel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    void clearInfo() {
        this.studyTable.clearSelection();
        this.errorMessageLabel.setText(" ");
    }

    @Override
    boolean commitChanges() {
        int selectedIndex = this.studyTable.getSelectedRow();
        ScientificStudy selectedStudy = this.studyTableModel.getStudy(selectedIndex);
        this.getWizard().getMissionData().setScientificStudy(selectedStudy);
        return true;
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    void updatePanel() {
        this.studyTableModel.updateTable();
        this.studyTable.setPreferredScrollableViewportSize(this.studyTable.getPreferredSize());
    }

    private static class StudyTableModel
    extends AbstractTableModel {
        private Science studyScience;
        private String scienceName;
        private List<ScientificStudy> studies;

        private StudyTableModel(Science studyScience) {
            this.studyScience = studyScience;
            ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
            this.studies = manager.getOngoingStudies();
            Collections.sort(this.studies);
            this.scienceName = studyScience.getName().substring(0, 1).toUpperCase() + studyScience.getName().substring(1);
        }

        private ScientificStudy getStudy(int index) {
            ScientificStudy result = null;
            if (index >= 0 && index < this.studies.size()) {
                result = this.studies.get(index);
            }
            return result;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.studies.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            String result = "unknown";
            if (columnIndex == 0) {
                result = "Study";
            } else if (columnIndex == 1) {
                result = "Phase";
            } else if (columnIndex == 2) {
                result = this.scienceName + " Researchers";
            }
            return result;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.studies.size()) {
                try {
                    ScientificStudy study = this.studies.get(row);
                    if (column == 0) {
                        result = study.toString();
                    } else if (column == 1) {
                        result = study.getPhase();
                    } else if (column == 2) {
                        result = this.getScienceResearcherNum(study);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return result;
        }

        private int getScienceResearcherNum(ScientificStudy study) {
            int result = 0;
            if (study.getScience().equals((Object)this.studyScience)) {
                ++result;
            }
            Iterator i = study.getCollaborativeResearchers().values().iterator();
            while (i.hasNext()) {
                if (!((Science)i.next()).equals((Object)this.studyScience)) continue;
                ++result;
            }
            return result;
        }

        void updateTable() {
            ScientificStudyManager manager = Simulation.instance().getScientificStudyManager();
            this.studies = manager.getOngoingStudies();
            Collections.sort(this.studies);
            this.fireTableStructureChanged();
        }

        boolean isFailureCell(int row, int column) {
            boolean result = false;
            ScientificStudy study = this.studies.get(row);
            try {
                if (column == 1) {
                    if (!"Research".equals(study.getPhase())) {
                        result = true;
                    }
                } else if (column == 2 && this.getScienceResearcherNum(study) == 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return result;
        }

        boolean isFailureRow(int row) {
            boolean result = false;
            for (int x = 0; x < this.getColumnCount(); ++x) {
                if (!this.isFailureCell(row, x)) continue;
                result = true;
            }
            return result;
        }
    }
}

