/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.MissionDataBean;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

class TypePanel
extends WizardPanel
implements ItemListener {
    private static final String NAME = "Mission Type";
    private JComboBox typeSelect;
    private JLabel descriptionInfoLabel;
    private JLabel descriptionLabel;
    private JTextField descriptionField;

    TypePanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel typeInfoLabel = new JLabel("Select mission type.");
        typeInfoLabel.setFont(typeInfoLabel.getFont().deriveFont(1));
        typeInfoLabel.setAlignmentX(0.0f);
        this.add(typeInfoLabel);
        JPanel typePane = new JPanel(new FlowLayout(0));
        typePane.setAlignmentX(0.0f);
        this.add(typePane);
        JLabel typeLabel = new JLabel("Type: ");
        typePane.add(typeLabel);
        String[] missionTypes = MissionDataBean.getMissionTypes();
        String[] displayMissionTypes = new String[missionTypes.length + 1];
        displayMissionTypes[0] = "";
        System.arraycopy(missionTypes, 0, displayMissionTypes, 1, missionTypes.length);
        this.typeSelect = new JComboBox<String>(displayMissionTypes);
        this.typeSelect.addItemListener(this);
        this.typeSelect.setMaximumRowCount(this.typeSelect.getItemCount());
        typePane.add(this.typeSelect);
        typePane.setMaximumSize(new Dimension(Short.MAX_VALUE, this.typeSelect.getPreferredSize().height));
        this.add(Box.createVerticalStrut(10));
        this.descriptionInfoLabel = new JLabel("Edit mission description (optional).");
        this.descriptionInfoLabel.setFont(this.descriptionInfoLabel.getFont().deriveFont(1));
        this.descriptionInfoLabel.setAlignmentX(0.0f);
        this.descriptionInfoLabel.setEnabled(false);
        this.add(this.descriptionInfoLabel);
        JPanel descriptionPane = new JPanel(new FlowLayout(0));
        descriptionPane.setAlignmentX(0.0f);
        this.add(descriptionPane);
        this.descriptionLabel = new JLabel("Description: ");
        this.descriptionLabel.setEnabled(false);
        descriptionPane.add(this.descriptionLabel);
        this.descriptionField = new JTextField(20);
        this.descriptionField.setEnabled(false);
        descriptionPane.add(this.descriptionField);
        descriptionPane.setMaximumSize(new Dimension(Short.MAX_VALUE, this.descriptionField.getPreferredSize().height));
        this.add(Box.createVerticalGlue());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String selectedMission = (String)this.typeSelect.getSelectedItem();
        this.descriptionField.setText(MissionDataBean.getMissionDescription(selectedMission));
        boolean enableDescription = this.typeSelect.getSelectedIndex() != 0;
        this.descriptionInfoLabel.setEnabled(enableDescription);
        this.descriptionLabel.setEnabled(enableDescription);
        this.descriptionField.setEnabled(enableDescription);
        this.getWizard().setButtons(enableDescription);
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    boolean commitChanges() {
        this.getWizard().getMissionData().setType((String)this.typeSelect.getSelectedItem());
        this.getWizard().getMissionData().setDescription(this.descriptionField.getText());
        this.getWizard().setFinalWizardPanels();
        return true;
    }

    @Override
    void clearInfo() {
    }

    @Override
    void updatePanel() {
    }
}

