/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.create;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.create.CreateMissionWizard;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableCellRenderer;
import org.mars_sim.msp.ui.swing.tool.mission.create.UnitTableModel;
import org.mars_sim.msp.ui.swing.tool.mission.create.WizardPanel;

class VehiclePanel
extends WizardPanel {
    private static final String NAME = "Rover";
    private VehicleTableModel vehicleTableModel;
    private JTable vehicleTable;
    private JLabel errorMessageLabel;

    VehiclePanel(CreateMissionWizard wizard) {
        super(wizard);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JLabel selectVehicleLabel = new JLabel("Select a rover for the mission.", 0);
        selectVehicleLabel.setFont(selectVehicleLabel.getFont().deriveFont(1));
        selectVehicleLabel.setAlignmentX(0.5f);
        this.add(selectVehicleLabel);
        JPanel vehiclePane = new JPanel(new BorderLayout(0, 0));
        vehiclePane.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        vehiclePane.setAlignmentX(0.5f);
        this.add(vehiclePane);
        JScrollPane vehicleScrollPane = new JScrollPane();
        vehiclePane.add((Component)vehicleScrollPane, "Center");
        this.vehicleTableModel = new VehicleTableModel();
        this.vehicleTable = new JTable(this.vehicleTableModel);
        this.vehicleTable.setDefaultRenderer(Object.class, new UnitTableCellRenderer(this.vehicleTableModel));
        this.vehicleTable.setRowSelectionAllowed(true);
        this.vehicleTable.setSelectionMode(0);
        this.vehicleTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index;
                if (e.getValueIsAdjusting() && (index = VehiclePanel.this.vehicleTable.getSelectedRow()) > -1) {
                    if (VehiclePanel.this.vehicleTableModel.isFailureRow(index)) {
                        VehiclePanel.this.errorMessageLabel.setText("Rover cannot be used on the mission (see red cells).");
                        VehiclePanel.this.getWizard().setButtons(false);
                    } else {
                        VehiclePanel.this.errorMessageLabel.setText(" ");
                        VehiclePanel.this.getWizard().setButtons(true);
                    }
                }
            }
        });
        this.vehicleTable.setPreferredScrollableViewportSize(this.vehicleTable.getPreferredSize());
        vehicleScrollPane.setViewportView(this.vehicleTable);
        this.errorMessageLabel = new JLabel(" ", 0);
        this.errorMessageLabel.setFont(this.errorMessageLabel.getFont().deriveFont(1));
        this.errorMessageLabel.setForeground(Color.RED);
        this.errorMessageLabel.setAlignmentX(0.5f);
        this.add(this.errorMessageLabel);
        this.add(Box.createVerticalGlue());
    }

    @Override
    String getPanelName() {
        return NAME;
    }

    @Override
    boolean commitChanges() {
        int selectedIndex = this.vehicleTable.getSelectedRow();
        Rover selectedVehicle = (Rover)this.vehicleTableModel.getUnit(selectedIndex);
        this.getWizard().getMissionData().setRover(selectedVehicle);
        return true;
    }

    @Override
    void clearInfo() {
        this.vehicleTable.clearSelection();
        this.errorMessageLabel.setText(" ");
    }

    @Override
    void updatePanel() {
        this.vehicleTableModel.updateTable();
        this.vehicleTable.setPreferredScrollableViewportSize(this.vehicleTable.getPreferredSize());
    }

    private class VehicleTableModel
    extends UnitTableModel {
        private VehicleTableModel() {
            this.columns.add("Name");
            this.columns.add("Type");
            this.columns.add("Crew Cap.");
            this.columns.add("Range");
            this.columns.add("Lab");
            this.columns.add("Sick Bay");
            this.columns.add("Cargo Cap.");
            this.columns.add("Current Cargo");
            this.columns.add("Status");
            this.columns.add("Mission");
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = "unknown";
            if (row < this.units.size()) {
                Rover vehicle = (Rover)this.getUnit(row);
                Inventory inv = vehicle.getInventory();
                try {
                    if (column == 0) {
                        result = vehicle.getName();
                    } else if (column == 1) {
                        result = vehicle.getDescription();
                    } else if (column == 2) {
                        result = vehicle.getCrewCapacity();
                    } else if (column == 3) {
                        result = (int)vehicle.getRange();
                    } else if (column == 4) {
                        result = vehicle.hasLab();
                    } else if (column == 5) {
                        result = vehicle.hasSickBay();
                    } else if (column == 6) {
                        result = (int)inv.getGeneralCapacity();
                    } else if (column == 7) {
                        result = (int)inv.getTotalInventoryMass(true);
                    } else if (column == 8) {
                        result = vehicle.getStatus();
                    } else if (column == 9) {
                        Mission mission = Simulation.instance().getMissionManager().getMissionForVehicle((Vehicle)vehicle);
                        result = mission != null ? mission.getDescription() : "None";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        void updateTable() {
            this.units.clear();
            Settlement startingSettlement = VehiclePanel.this.getWizard().getMissionData().getStartingSettlement();
            Collection vehicles = CollectionUtils.sortByName((Collection)startingSettlement.getParkedVehicles());
            for (Vehicle vehicle : vehicles) {
                if (!(vehicle instanceof Rover)) continue;
                this.units.add(vehicle);
            }
            this.fireTableDataChanged();
        }

        @Override
        boolean isFailureCell(int row, int column) {
            Mission mission;
            boolean result = false;
            Rover vehicle = (Rover)this.getUnit(row);
            if (column == 7) {
                if (vehicle.getInventory().getTotalInventoryMass(true) > 0.0) {
                    result = true;
                }
            } else if (column == 8) {
                String type;
                if (!vehicle.getStatus().equals("Parked")) {
                    result = true;
                }
                if ("Rescue/Salvage Vehicle".equals(type = VehiclePanel.this.getWizard().getMissionData().getType()) && vehicle.getStatus().equals("Periodic Maintenance")) {
                    result = false;
                }
            } else if (column == 9 && (mission = Simulation.instance().getMissionManager().getMissionForVehicle((Vehicle)vehicle)) != null) {
                result = true;
            }
            return result;
        }
    }
}

