/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.edit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;

class AddMembersDialog
extends JDialog {
    Mission mission;
    DefaultListModel memberListModel;
    DefaultListModel availableListModel;
    JList availableList;
    JButton addButton;

    public AddMembersDialog(Dialog owner, Mission mission, DefaultListModel memberListModel, Collection<Person> availablePeople) {
        super(owner, "Add Members", true);
        this.mission = mission;
        this.memberListModel = memberListModel;
        this.setLayout(new BorderLayout(5, 5));
        ((JComponent)this.getContentPane()).setBorder(new MarsPanelBorder());
        JLabel headerLabel = new JLabel("Select available people to add to the mission.");
        this.add((Component)headerLabel, "North");
        JPanel availablePeoplePane = new JPanel(new BorderLayout(0, 0));
        this.add((Component)availablePeoplePane, "Center");
        JScrollPane availableScrollPane = new JScrollPane();
        availableScrollPane.setPreferredSize(new Dimension(100, 100));
        availablePeoplePane.add((Component)availableScrollPane, "Center");
        this.availableListModel = new DefaultListModel();
        Iterator<Person> i = availablePeople.iterator();
        while (i.hasNext()) {
            this.availableListModel.addElement(i.next());
        }
        this.availableList = new JList(this.availableListModel);
        this.availableList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AddMembersDialog.this.addButton.setEnabled(AddMembersDialog.this.availableList.getSelectedValues().length > 0);
            }
        });
        availableScrollPane.setViewportView(this.availableList);
        JPanel buttonPane = new JPanel(new FlowLayout(2));
        this.add((Component)buttonPane, "South");
        this.addButton = new JButton("Add");
        this.addButton.setEnabled(this.availableList.getSelectedValues().length > 0);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMembersDialog.this.addPeople();
                AddMembersDialog.this.dispose();
            }
        });
        buttonPane.add(this.addButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMembersDialog.this.dispose();
            }
        });
        buttonPane.add(cancelButton);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void addPeople() {
        int[] selectedIndexes;
        for (int selectedIndexe : selectedIndexes = this.availableList.getSelectedIndices()) {
            if (this.memberListModel.getSize() >= this.mission.getMissionCapacity()) continue;
            this.memberListModel.addElement(this.availableListModel.elementAt(selectedIndexe));
        }
    }
}

