/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.mission.edit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.CollectResourcesMission;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.RoverMission;
import org.mars_sim.msp.core.person.ai.mission.TravelMission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.edit.AddMembersDialog;

public class InfoPanel
extends JPanel {
    static final String ACTION_NONE = "None";
    static final String ACTION_CONTINUE = "End EVA and Continue to Next Site";
    static final String ACTION_HOME = "Return to Home Settlement and End Mission";
    static final String ACTION_NEAREST = "Go to Nearest Settlement and End Mission";
    Mission mission;
    Dialog parent;
    JTextField descriptionField;
    JComboBox actionDropDown;
    DefaultListModel memberListModel;
    JList memberList;
    JButton addMembersButton;
    JButton removeMembersButton;

    InfoPanel(Mission mission, Dialog parent) {
        this.mission = mission;
        this.parent = parent;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new MarsPanelBorder());
        JPanel descriptionPane = new JPanel(new FlowLayout(0));
        descriptionPane.setAlignmentX(0.0f);
        this.add(descriptionPane);
        JLabel descriptionLabel = new JLabel("Description: ");
        descriptionPane.add(descriptionLabel);
        this.descriptionField = new JTextField(mission.getDescription(), 20);
        descriptionPane.add(this.descriptionField);
        JPanel actionPane = new JPanel(new FlowLayout(0));
        actionPane.setAlignmentX(0.0f);
        this.add(actionPane);
        JLabel actionLabel = new JLabel("Action: ");
        actionPane.add(actionLabel);
        this.actionDropDown = new JComboBox<String>(this.getActions(mission));
        this.actionDropDown.setEnabled(this.actionDropDown.getItemCount() > 1);
        actionPane.add(this.actionDropDown);
        JPanel membersPane = new JPanel(new BorderLayout());
        membersPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        membersPane.setAlignmentX(0.0f);
        this.add(membersPane);
        JLabel membersLabel = new JLabel("Members: ");
        membersLabel.setVerticalAlignment(1);
        membersPane.add((Component)membersLabel, "West");
        JPanel memberListPane = new JPanel(new BorderLayout(0, 0));
        membersPane.add((Component)memberListPane, "Center");
        JScrollPane memberScrollPane = new JScrollPane();
        memberScrollPane.setPreferredSize(new Dimension(100, 100));
        memberListPane.add((Component)memberScrollPane, "Center");
        this.memberListModel = new DefaultListModel();
        Iterator i = mission.getPeople().iterator();
        while (i.hasNext()) {
            this.memberListModel.addElement(i.next());
        }
        this.memberList = new JList(this.memberListModel);
        this.memberList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                InfoPanel.this.removeMembersButton.setEnabled(InfoPanel.this.memberList.getSelectedValues().length > 0);
            }
        });
        memberScrollPane.setViewportView(this.memberList);
        JPanel memberButtonPane = new JPanel(new FlowLayout(1));
        memberListPane.add((Component)memberButtonPane, "South");
        this.addMembersButton = new JButton("Add Members");
        this.addMembersButton.setEnabled(this.canAddMembers());
        this.addMembersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoPanel.this.addMembers();
            }
        });
        memberButtonPane.add(this.addMembersButton);
        this.removeMembersButton = new JButton("Remove Members");
        this.removeMembersButton.setEnabled(false);
        this.removeMembersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoPanel.this.removeMembers();
            }
        });
        memberButtonPane.add(this.removeMembersButton);
    }

    private boolean canAddMembers() {
        boolean roomInMission = this.memberListModel.size() < this.mission.getMissionCapacity();
        boolean availablePeople = this.getAvailablePeople().size() > 0;
        return roomInMission && availablePeople;
    }

    private void addMembers() {
        new AddMembersDialog(this.parent, this.mission, this.memberListModel, this.getAvailablePeople());
        this.addMembersButton.setEnabled(this.canAddMembers());
    }

    private void removeMembers() {
        int[] selectedIndexes = this.memberList.getSelectedIndices();
        Object[] selectedPeople = new Object[selectedIndexes.length];
        for (int x = 0; x < selectedIndexes.length; ++x) {
            selectedPeople[x] = this.memberListModel.elementAt(selectedIndexes[x]);
        }
        for (Object aSelectedPeople : selectedPeople) {
            this.memberListModel.removeElement(aSelectedPeople);
        }
        this.addMembersButton.setEnabled(this.canAddMembers());
    }

    private Vector<String> getActions(Mission mission) {
        TravelMission travelMission;
        int nextNavpointIndex;
        CollectResourcesMission collectResourcesMission;
        Vector<String> actions = new Vector<String>();
        actions.add(ACTION_NONE);
        String phase = mission.getPhase();
        if (phase.equals("Collecting Resources") && (collectResourcesMission = (CollectResourcesMission)mission).getNumCollectionSites() > collectResourcesMission.getNumCollectionSitesVisited()) {
            actions.add(ACTION_CONTINUE);
        }
        if (mission instanceof TravelMission && (nextNavpointIndex = (travelMission = (TravelMission)mission).getNextNavpointIndex()) > -1 && nextNavpointIndex < travelMission.getNumberOfNavpoints() - 1 && !mission.getPhase().equals("Embarking")) {
            actions.add(ACTION_HOME);
        }
        if (mission instanceof VehicleMission) {
            VehicleMission vehicleMission = (VehicleMission)mission;
            try {
                Settlement closestSettlement = vehicleMission.findClosestSettlement();
                if (closestSettlement != null && !closestSettlement.equals(vehicleMission.getAssociatedSettlement()) && !mission.getPhase().equals("Embarking")) {
                    actions.add(ACTION_NEAREST);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return actions;
    }

    private Collection<Person> getAvailablePeople() {
        ConcurrentLinkedQueue<Person> result = new ConcurrentLinkedQueue<Person>();
        if (this.mission instanceof RoverMission) {
            Rover rover = ((RoverMission)this.mission).getRover();
            String phase = this.mission.getPhase();
            Collection peopleAtLocation = null;
            if (rover != null) {
                if (phase.equals("Embarking") || phase.equals("Disembarking")) {
                    Settlement settlement = rover.getSettlement();
                    if (settlement != null) {
                        peopleAtLocation = settlement.getInhabitants();
                    }
                } else {
                    peopleAtLocation = rover.getCrew();
                }
            }
            for (Person person : peopleAtLocation) {
                if (this.memberListModel.contains(person)) continue;
                result.add(person);
            }
        }
        try {
            Coordinates missionLocation = this.mission.getCurrentMissionLocation();
            for (Person person : Simulation.instance().getUnitManager().getPeople()) {
                if (!person.getLocationSituation().equals("Outside") || !person.getCoordinates().equals((Object)missionLocation) || this.memberListModel.contains(person)) continue;
                result.add(person);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

