/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorModel;

public class ColumnSelector
extends JDialog {
    private static final String PIE_MESSAGE = "Select a single column to display in the Pie chart";
    private static final String BAR_MESSAGE = "Select a multiple columns to display in the Bar chart";
    private JList columnList = null;
    private int[] columnMappings = null;
    private boolean okPressed = false;

    public ColumnSelector(Frame owner, MonitorModel model, boolean bar) {
        super(owner, model.getName(), true);
        Vector<String> items = new Vector<String>();
        this.columnMappings = new int[model.getColumnCount() - 1];
        for (int i = 1; i < model.getColumnCount(); ++i) {
            Class<?> columnType = model.getColumnClass(i);
            if (bar) {
                if (!Number.class.isAssignableFrom(columnType)) continue;
                this.columnMappings[items.size()] = i;
                items.add(model.getColumnName(i));
                continue;
            }
            if (!this.isCategory(columnType)) continue;
            this.columnMappings[items.size()] = i;
            items.add(model.getColumnName(i));
        }
        JPanel centerPane = new JPanel(new BorderLayout());
        centerPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.columnList = new JList(items);
        if (bar) {
            this.columnList.setSelectionMode(2);
            centerPane.add((Component)new JLabel(BAR_MESSAGE), "North");
        } else {
            centerPane.add((Component)new JLabel(PIE_MESSAGE), "North");
        }
        centerPane.add((Component)new JScrollPane(this.columnList), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ColumnSelector.this.okPressed = true;
                ColumnSelector.this.setVisible(false);
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ColumnSelector.this.setVisible(false);
            }
        });
        buttonPanel.add(cancelButton);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)centerPane, "Center");
        pane.add((Component)buttonPanel, "South");
        this.getContentPane().add(pane);
        this.pack();
    }

    public static int[] createBarSelector(Frame window, MonitorModel model) {
        ColumnSelector select = new ColumnSelector(window, model, true);
        select.setVisible(true);
        return select.getSelectedColumns();
    }

    public static int createPieSelector(Frame window, MonitorModel model) {
        ColumnSelector select = new ColumnSelector(window, model, false);
        select.setVisible(true);
        int[] columns = select.getSelectedColumns();
        if (columns.length > 0) {
            return columns[0];
        }
        return -1;
    }

    public int[] getSelectedColumns() {
        int[] index = null;
        if (this.okPressed) {
            int[] selection = this.columnList.getSelectedIndices();
            index = new int[selection.length];
            for (int i = 0; i < selection.length; ++i) {
                index[i] = this.columnMappings[selection[i]];
            }
        } else {
            index = new int[]{};
        }
        return index;
    }

    private boolean isCategory(Class columnClass) {
        return !Number.class.isAssignableFrom(columnClass) && !Coordinates.class.equals((Object)columnClass);
    }
}

