/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.person.ai.mission.MissionListener;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.MissionManagerListener;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.TravelMission;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorModel;

public class MissionTableModel
extends AbstractTableModel
implements MonitorModel,
MissionManagerListener,
MissionListener {
    private static final int TYPE = 0;
    private static final int DESCRIPTION = 1;
    private static final int PHASE = 2;
    private static final int VEHICLE = 3;
    private static final int STARTING_SETTLEMENT = 4;
    private static final int MEMBER_NUM = 5;
    private static final int NAVPOINT_NUM = 6;
    private static final int TRAVELLED_DISTANCE = 7;
    private static final int REMAINING_DISTANCE = 8;
    private static final int COLUMNCOUNT = 9;
    private static String[] columnNames;
    private static Class[] columnTypes;
    private List<Mission> missionCache;

    public MissionTableModel() {
        columnNames = new String[9];
        columnTypes = new Class[9];
        MissionTableModel.columnNames[0] = "Type";
        MissionTableModel.columnTypes[0] = String.class;
        MissionTableModel.columnNames[1] = "Description";
        MissionTableModel.columnTypes[1] = String.class;
        MissionTableModel.columnNames[2] = "Phase";
        MissionTableModel.columnTypes[2] = String.class;
        MissionTableModel.columnNames[4] = "Starting Settlement";
        MissionTableModel.columnTypes[4] = String.class;
        MissionTableModel.columnNames[3] = "Vehicle";
        MissionTableModel.columnTypes[3] = String.class;
        MissionTableModel.columnNames[5] = "Member Num.";
        MissionTableModel.columnTypes[5] = Integer.class;
        MissionTableModel.columnNames[6] = "Navpoint Num.";
        MissionTableModel.columnTypes[6] = Integer.class;
        MissionTableModel.columnNames[7] = "Travelled Dist. (km)";
        MissionTableModel.columnTypes[7] = Integer.class;
        MissionTableModel.columnNames[8] = "Remaining Dist. (km)";
        MissionTableModel.columnTypes[8] = Integer.class;
        MissionManager manager = Simulation.instance().getMissionManager();
        this.missionCache = manager.getMissions();
        manager.addListener((MissionManagerListener)this);
        Iterator<Mission> i = this.missionCache.iterator();
        while (i.hasNext()) {
            i.next().addMissionListener((MissionListener)this);
        }
    }

    @Override
    public String getName() {
        return "Missions";
    }

    public void addMission(Mission mission) {
        if (!this.missionCache.contains(mission)) {
            this.missionCache.add(mission);
            mission.addMissionListener((MissionListener)this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MissionTableModel.this.fireTableRowsInserted(MissionTableModel.this.missionCache.size() - 1, MissionTableModel.this.missionCache.size() - 1);
                }
            });
        }
    }

    public void removeMission(Mission mission) {
        if (this.missionCache.contains(mission)) {
            int index = this.missionCache.indexOf(mission);
            this.missionCache.remove(mission);
            mission.removeMissionListener((MissionListener)this);
            SwingUtilities.invokeLater(new MissionTableRowDeleter(index));
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < columnTypes.length) {
            return columnTypes[columnIndex];
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < columnNames.length) {
            return columnNames[columnIndex];
        }
        return "Unknown";
    }

    @Override
    public Object getObject(int row) {
        return this.missionCache.get(row);
    }

    @Override
    public boolean getOrdered() {
        return false;
    }

    @Override
    public String getCountString() {
        return this.missionCache.size() + " missions";
    }

    public void missionUpdate(MissionEvent event) {
        int index = this.missionCache.indexOf(event.getSource());
        if (index > -1 && index < this.missionCache.size()) {
            int column1 = -1;
            int column2 = -1;
            String eventType = event.getType();
            if (eventType.equals("name")) {
                column1 = 0;
            } else if (eventType.equals("description")) {
                column1 = 1;
            } else if (eventType.equals("phase")) {
                column1 = 2;
            } else if (eventType.equals("remove member") || eventType.equals("add member")) {
                column1 = 5;
            } else if (eventType.equals("navpoints")) {
                column1 = 6;
            } else if (eventType.equals("vehicle")) {
                column1 = 3;
            } else if (eventType.equals("starting settlement")) {
                column1 = 4;
            } else if (eventType.equals("distance")) {
                column1 = 7;
                column2 = 8;
            }
            if (column1 > -1) {
                SwingUtilities.invokeLater(new MissionTableCellUpdater(index, column1));
            }
            if (column2 > -1) {
                SwingUtilities.invokeLater(new MissionTableCellUpdater(index, column2));
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.missionCache.size();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        if (rowIndex < this.missionCache.size()) {
            Mission mission = this.missionCache.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    result = mission.getName();
                    break;
                }
                case 1: {
                    result = mission.getDescription();
                    break;
                }
                case 2: {
                    result = mission.getPhaseDescription();
                    break;
                }
                case 3: {
                    VehicleMission vehicleMission;
                    result = "";
                    if (!(mission instanceof VehicleMission) || (vehicleMission = (VehicleMission)mission).getVehicle() == null) break;
                    result = vehicleMission.getVehicle().getName();
                    break;
                }
                case 4: {
                    NavPoint nav0;
                    result = "";
                    if (!(mission instanceof TravelMission) || (nav0 = ((TravelMission)mission).getNavpoint(0)) == null || !nav0.isSettlementAtNavpoint()) break;
                    result = nav0.getSettlement().getName();
                    break;
                }
                case 5: {
                    result = mission.getPeopleNumber();
                    break;
                }
                case 6: {
                    if (mission instanceof TravelMission) {
                        TravelMission travelMission = (TravelMission)mission;
                        result = travelMission.getNumberOfNavpoints();
                        break;
                    }
                    result = 0;
                    break;
                }
                case 7: {
                    if (mission instanceof TravelMission) {
                        TravelMission travelMission = (TravelMission)mission;
                        result = (int)travelMission.getTotalDistanceTravelled();
                        break;
                    }
                    result = 0;
                    break;
                }
                case 8: {
                    if (mission instanceof TravelMission) {
                        TravelMission travelMission = (TravelMission)mission;
                        try {
                            result = (int)travelMission.getTotalRemainingDistance();
                        }
                        catch (Exception e) {}
                        break;
                    }
                    result = 0;
                }
            }
        }
        return result;
    }

    @Override
    public void destroy() {
        Object[] missions = this.missionCache.toArray();
        for (int x = 0; x < missions.length; ++x) {
            this.removeMission((Mission)missions[x]);
        }
        Simulation.instance().getMissionManager().removeListener((MissionManagerListener)this);
    }

    private class MissionTableRowDeleter
    implements Runnable {
        private int row;

        private MissionTableRowDeleter(int row) {
            this.row = row;
        }

        @Override
        public void run() {
            if (this.row < MissionTableModel.this.getRowCount()) {
                MissionTableModel.this.fireTableRowsDeleted(this.row, this.row);
            }
        }
    }

    private class MissionTableCellUpdater
    implements Runnable {
        private int row;
        private int column;

        private MissionTableCellUpdater(int row, int column) {
            this.row = row;
            this.column = column;
        }

        @Override
        public void run() {
            if (this.row < MissionTableModel.this.getRowCount() && this.column < MissionTableModel.this.getColumnCount()) {
                MissionTableModel.this.fireTableCellUpdated(this.row, this.column);
            }
        }
    }
}

