/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.ToolWindow;
import org.mars_sim.msp.ui.swing.tool.monitor.BarChartTab;
import org.mars_sim.msp.ui.swing.tool.monitor.ColumnSelector;
import org.mars_sim.msp.ui.swing.tool.monitor.EventTab;
import org.mars_sim.msp.ui.swing.tool.monitor.EventTableModel;
import org.mars_sim.msp.ui.swing.tool.monitor.MissionTab;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorModel;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorTab;
import org.mars_sim.msp.ui.swing.tool.monitor.PersonTableModel;
import org.mars_sim.msp.ui.swing.tool.monitor.PieChartTab;
import org.mars_sim.msp.ui.swing.tool.monitor.SettlementTableModel;
import org.mars_sim.msp.ui.swing.tool.monitor.TradeTab;
import org.mars_sim.msp.ui.swing.tool.monitor.UnitTab;
import org.mars_sim.msp.ui.swing.tool.monitor.UnitTableModel;
import org.mars_sim.msp.ui.swing.tool.monitor.VehicleTableModel;

public class MonitorWindow
extends ToolWindow
implements TableModelListener {
    public static final String NAME = "Monitor Tool";
    private static final int STATUSHEIGHT = 17;
    private JTabbedPane tabsSection;
    private JLabel rowCount;
    private ArrayList<MonitorTab> tabs = new ArrayList();
    private EventTab eventsTab;
    private MonitorTab oldTab = null;
    private JButton mapButton;
    private JButton detailsButton;
    private JButton missionButton;
    private JButton filterButton;

    public MonitorWindow(MainDesktopPane desktop) {
        super(NAME, desktop);
        this.setMaximizable(true);
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.setBorder(new MarsPanelBorder());
        this.setContentPane(mainPane);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        mainPane.add((Component)toolbar, "North");
        JButton pieButton = new JButton(PieChartTab.PIEICON);
        pieButton.setToolTipText("Create a Pie chart of a single column.");
        pieButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorWindow.this.createPieChart();
            }
        });
        toolbar.add(pieButton);
        JButton barButton = new JButton(BarChartTab.BARICON);
        barButton.setToolTipText("Create a Bar chart of multiple columns.");
        barButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorWindow.this.createBarChart();
            }
        });
        toolbar.add(barButton);
        JButton tabRemove = new JButton(ImageLoader.getIcon("TabRemove"));
        tabRemove.setToolTipText("Remove selected tab.");
        tabRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorTab selected = MonitorWindow.this.getSelected();
                if (!selected.getMandatory()) {
                    MonitorWindow.this.removeTab(MonitorWindow.this.getSelected());
                }
            }
        });
        toolbar.add(tabRemove);
        toolbar.addSeparator();
        this.mapButton = new JButton(ImageLoader.getIcon("CenterMap"));
        this.mapButton.setMargin(new Insets(3, 4, 4, 4));
        this.mapButton.setToolTipText("Locate selected unit in Mars Navigator.");
        this.mapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorWindow.this.centerMap();
            }
        });
        toolbar.add(this.mapButton);
        this.detailsButton = new JButton(ImageLoader.getIcon("ShowDetails"));
        this.detailsButton.setToolTipText("Open unit window for selected unit.");
        this.detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorWindow.this.displayDetails();
            }
        });
        toolbar.add(this.detailsButton);
        this.missionButton = new JButton(ImageLoader.getIcon("Mission"));
        this.missionButton.setToolTipText("Open selected mission in mission tool.");
        this.missionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorWindow.this.displayMission();
            }
        });
        toolbar.add(this.missionButton);
        toolbar.addSeparator();
        JButton propsButton = new JButton(ImageLoader.getIcon("Preferences"));
        propsButton.setToolTipText("Change the displayed columns.");
        propsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorWindow.this.displayProps();
            }
        });
        toolbar.add(propsButton);
        toolbar.addSeparator();
        this.filterButton = new JButton(ImageLoader.getIcon("CategoryFilter"));
        this.filterButton.setToolTipText("Filter historical events by category.");
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorWindow.this.filterCategories();
            }
        });
        toolbar.add(this.filterButton);
        this.tabsSection = new JTabbedPane();
        mainPane.add((Component)this.tabsSection, "Center");
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new FlowLayout(0, 1, 1));
        mainPane.add((Component)statusPanel, "South");
        this.rowCount = new JLabel("  ");
        this.rowCount.setHorizontalAlignment(2);
        this.rowCount.setBorder(BorderFactory.createLoweredBevelBorder());
        statusPanel.add(this.rowCount);
        Dimension dims = new Dimension(150, 17);
        this.rowCount.setPreferredSize(dims);
        UnitManager unitManager = Simulation.instance().getUnitManager();
        this.addTab(new UnitTab(new PersonTableModel(unitManager), true));
        this.addTab(new UnitTab(new VehicleTableModel(unitManager), true));
        this.addTab(new UnitTab(new SettlementTableModel(unitManager), true));
        this.addTab(new MissionTab());
        this.eventsTab = new EventTab(new EventTableModel(Simulation.instance().getEventManager()));
        this.addTab(this.eventsTab);
        this.addTab(new TradeTab());
        this.tabsSection.setSelectedIndex(0);
        this.tabChanged();
        this.tabsSection.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MonitorWindow.this.tabChanged();
            }
        });
        this.setSize(new Dimension(600, 300));
    }

    public void displayModel(UnitTableModel model) {
        if (this.containsModel(model)) {
            this.tabsSection.setSelectedIndex(this.getModelIndex(model));
        } else {
            this.addTab(new UnitTab(model, false));
        }
    }

    public boolean containsModel(UnitTableModel model) {
        boolean result = false;
        Iterator<MonitorTab> i = this.tabs.iterator();
        while (i.hasNext()) {
            if (!i.next().getModel().equals(model)) continue;
            result = true;
        }
        return result;
    }

    public int getModelIndex(UnitTableModel model) {
        int result = -1;
        for (MonitorTab tab : this.tabs) {
            if (!tab.getModel().equals(model)) continue;
            result = this.tabs.indexOf(tab);
        }
        return result;
    }

    private void createBarChart() {
        MonitorModel model = this.getSelected().getModel();
        int[] columns = ColumnSelector.createBarSelector(this.desktop.getMainWindow().getFrame(), model);
        if (columns.length > 0) {
            this.addTab(new BarChartTab(model, columns));
        }
    }

    private void createPieChart() {
        MonitorModel model = this.getSelected().getModel();
        int column = ColumnSelector.createPieSelector(this.desktop.getMainWindow().getFrame(), model);
        if (column >= 0) {
            this.addTab(new PieChartTab(model, column));
        }
    }

    private MonitorTab getSelected() {
        MonitorTab selected = null;
        int selectedIdx = this.tabsSection.getSelectedIndex();
        if (selectedIdx != -1 && selectedIdx < this.tabs.size()) {
            selected = this.tabs.get(selectedIdx);
        }
        return selected;
    }

    private void tabChanged() {
        MonitorTab selected = this.getSelected();
        if (selected != null) {
            MonitorModel model;
            String status = selected.getCountString();
            this.rowCount.setText(status);
            if (this.oldTab != null && (model = this.oldTab.getModel()) != null) {
                this.oldTab.getModel().removeTableModelListener(this);
            }
            selected.getModel().addTableModelListener(this);
            this.oldTab = selected;
            this.mapButton.setEnabled(false);
            this.detailsButton.setEnabled(false);
            this.missionButton.setEnabled(false);
            this.filterButton.setEnabled(false);
            if (selected instanceof UnitTab) {
                this.mapButton.setEnabled(true);
                this.detailsButton.setEnabled(true);
            } else if (selected instanceof MissionTab) {
                this.mapButton.setEnabled(true);
                this.missionButton.setEnabled(true);
            } else if (selected instanceof EventTab) {
                this.mapButton.setEnabled(true);
                this.detailsButton.setEnabled(true);
                this.filterButton.setEnabled(true);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        MonitorTab selected;
        if (e.getType() != 0 && (selected = this.getSelected()) != null) {
            String status = selected.getCountString();
            this.rowCount.setText(status);
        }
    }

    private void addTab(MonitorTab newTab) {
        this.tabs.add(newTab);
        this.tabsSection.addTab(newTab.getName(), newTab.getIcon(), newTab);
        this.tabsSection.setSelectedIndex(this.tabs.size() - 1);
        this.tabChanged();
    }

    private void removeTab(MonitorTab oldTab) {
        this.tabs.remove(oldTab);
        this.tabsSection.remove(oldTab);
        oldTab.removeTab();
        if (this.getSelected() == oldTab) {
            this.tabsSection.setSelectedIndex(0);
        }
        this.tabChanged();
    }

    private void centerMap() {
        MonitorTab selected = this.getSelected();
        if (selected != null) {
            selected.centerMap(this.desktop);
        }
    }

    private void displayDetails() {
        MonitorTab selected = this.getSelected();
        if (selected != null) {
            selected.displayDetails(this.desktop);
        }
    }

    private void displayMission() {
        MonitorTab selected = this.getSelected();
        if (selected instanceof MissionTab && selected != null) {
            ((MissionTab)selected).displayMission(this.desktop);
        }
    }

    private void displayProps() {
        MonitorTab selected = this.getSelected();
        if (selected != null) {
            selected.displayProps(this.desktop);
        }
    }

    private void filterCategories() {
        EventTab events = this.eventsTab;
        if (events != null) {
            events.filterCategories(this.desktop);
        }
    }

    @Override
    public void destroy() {
        Iterator<MonitorTab> i = this.tabs.iterator();
        while (i.hasNext()) {
            i.next().removeTab();
        }
        this.tabs.clear();
    }
}

