/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.UnitEvent;
import org.mars_sim.msp.core.UnitListener;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.UnitManagerEvent;
import org.mars_sim.msp.core.UnitManagerListener;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionEvent;
import org.mars_sim.msp.core.person.ai.mission.MissionListener;
import org.mars_sim.msp.core.person.ai.task.TaskManager;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.ui.swing.tool.monitor.UnitTableModel;

public class PersonTableModel
extends UnitTableModel {
    private static final int NAME = 0;
    private static final int GENDER = 1;
    private static final int LOCATION = 2;
    private static final int PERSONALITY = 3;
    private static final int HUNGER = 4;
    private static final int FATIGUE = 5;
    private static final int STRESS = 6;
    private static final int PERFORMANCE = 7;
    private static final int JOB = 8;
    private static final int TASK = 9;
    private static final int MISSION = 10;
    private static final int HEALTH = 11;
    private static final int COLUMNCOUNT = 12;
    private static String[] columnNames = new String[12];
    private static Class[] columnTypes = new Class[12];
    private static final String ALL_PEOPLE = "All People";
    private static final String VEHICLE_CREW = "Vehicle Crew";
    private static final String SETTLEMENT_INHABITANTS = "Settlement Inhabitants";
    private static final String SETTLEMENT_ALL_ASSOCIATED_PEOPLE = "All People Associated with Settlement";
    private static final String MISSION_PEOPLE = "Mission People";
    private String sourceType;
    private Crewable vehicle;
    private Settlement settlement;
    private Mission mission;
    private UnitListener crewListener;
    private UnitListener settlementListener;
    private MissionListener missionListener;
    private UnitManagerListener unitManagerListener;

    public PersonTableModel(UnitManager unitManager) {
        super(ALL_PEOPLE, " people", columnNames, columnTypes);
        this.sourceType = ALL_PEOPLE;
        this.setSource(unitManager.getPeople());
        this.unitManagerListener = new LocalUnitManagerListener();
        unitManager.addUnitManagerListener(this.unitManagerListener);
    }

    public PersonTableModel(Crewable vehicle) {
        super(((Unit)vehicle).getName() + " - People", " people", columnNames, columnTypes);
        this.sourceType = VEHICLE_CREW;
        this.vehicle = vehicle;
        this.setSource(vehicle.getCrew());
        this.crewListener = new LocalCrewListener();
        ((Unit)vehicle).addUnitListener(this.crewListener);
    }

    public PersonTableModel(Settlement settlement, boolean allAssociated) {
        super(settlement.getName() + (allAssociated ? " - All Associated People" : " - People"), allAssociated ? " associated people" : " residents", columnNames, columnTypes);
        this.settlement = settlement;
        if (allAssociated) {
            this.sourceType = SETTLEMENT_ALL_ASSOCIATED_PEOPLE;
            this.setSource(settlement.getAllAssociatedPeople());
            this.settlementListener = new AssociatedSettlementListener();
            settlement.addUnitListener(this.settlementListener);
        } else {
            this.sourceType = SETTLEMENT_INHABITANTS;
            this.setSource(settlement.getInhabitants());
            this.settlementListener = new InhabitantSettlementListener();
            settlement.addUnitListener(this.settlementListener);
        }
    }

    public PersonTableModel(Mission mission) {
        super(mission.getName() + " - People", " mission members", columnNames, columnTypes);
        this.sourceType = MISSION_PEOPLE;
        this.mission = mission;
        this.setSource(mission.getPeople());
        this.missionListener = new LocalMissionListener();
        mission.addMissionListener(this.missionListener);
    }

    private void setSource(Collection<Person> source) {
        Iterator<Person> iter = source.iterator();
        while (iter.hasNext()) {
            this.addUnit((Unit)iter.next());
        }
    }

    public void unitUpdate(UnitEvent event) {
        SwingUtilities.invokeLater(new PersonTableUpdater(event, this));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        if (rowIndex < this.getUnitNumber()) {
            Person person = (Person)this.getUnit(rowIndex);
            switch (columnIndex) {
                case 0: {
                    result = person.getName();
                    break;
                }
                case 1: {
                    String genderStr = person.getGender().substring(0, 1).toUpperCase() + person.getGender().substring(1);
                    result = genderStr;
                    break;
                }
                case 3: {
                    result = person.getMind().getPersonalityType().getTypeString();
                    break;
                }
                case 4: {
                    double hunger = person.getPhysicalCondition().getHunger();
                    result = new Float(hunger).intValue();
                    break;
                }
                case 5: {
                    double fatigue = person.getPhysicalCondition().getFatigue();
                    result = new Float(fatigue).intValue();
                    break;
                }
                case 6: {
                    double stress = person.getPhysicalCondition().getStress();
                    result = new Double(stress).intValue();
                    break;
                }
                case 7: {
                    double performance = person.getPhysicalCondition().getPerformanceFactor();
                    result = new Float(performance * 100.0).intValue();
                    break;
                }
                case 11: {
                    result = person.getPhysicalCondition().getHealthSituation();
                    break;
                }
                case 2: {
                    String locationSituation = person.getLocationSituation();
                    if (locationSituation.equals("In Settlement")) {
                        if (person.getSettlement() == null) break;
                        result = person.getSettlement().getName();
                        break;
                    }
                    if (locationSituation.equals("In Vehicle")) {
                        if (person.getVehicle() == null) break;
                        result = person.getVehicle().getName();
                        break;
                    }
                    result = locationSituation;
                    break;
                }
                case 8: {
                    if (person.getPhysicalCondition().isDead()) {
                        result = person.getPhysicalCondition().getDeathDetails().getJob();
                        break;
                    }
                    if (person.getMind().getJob() != null) {
                        result = person.getMind().getJob().getName();
                        break;
                    }
                    result = null;
                    break;
                }
                case 9: {
                    TaskManager mgr = person.getMind().getTaskManager();
                    result = mgr != null ? mgr.getTaskDescription() : null;
                    break;
                }
                case 10: {
                    Mission mission = person.getMind().getMission();
                    if (mission == null) break;
                    result = mission.getDescription();
                }
            }
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.sourceType.equals(ALL_PEOPLE)) {
            UnitManager unitManager = Simulation.instance().getUnitManager();
            unitManager.removeUnitManagerListener(this.unitManagerListener);
            this.unitManagerListener = null;
        } else if (this.sourceType.equals(VEHICLE_CREW)) {
            ((Unit)this.vehicle).removeUnitListener(this.crewListener);
            this.crewListener = null;
            this.vehicle = null;
        } else if (this.sourceType.equals(MISSION_PEOPLE)) {
            this.mission.removeMissionListener(this.missionListener);
            this.missionListener = null;
            this.mission = null;
        } else {
            this.settlement.removeUnitListener(this.settlementListener);
            this.settlementListener = null;
            this.settlement = null;
        }
    }

    @Override
    public boolean equals(Object o) {
        boolean result = super.equals(o);
        if (o instanceof PersonTableModel) {
            PersonTableModel oModel = (PersonTableModel)o;
            if (!this.sourceType.equals(oModel.sourceType)) {
                result = false;
            }
        }
        return result;
    }

    static {
        PersonTableModel.columnNames[0] = "Name";
        PersonTableModel.columnTypes[0] = String.class;
        PersonTableModel.columnNames[1] = "Gender";
        PersonTableModel.columnTypes[1] = String.class;
        PersonTableModel.columnNames[3] = "Personality";
        PersonTableModel.columnTypes[3] = String.class;
        PersonTableModel.columnNames[4] = "Hunger";
        PersonTableModel.columnTypes[4] = Integer.class;
        PersonTableModel.columnNames[5] = "Fatigue";
        PersonTableModel.columnTypes[5] = Integer.class;
        PersonTableModel.columnNames[6] = "Stress %";
        PersonTableModel.columnTypes[6] = Integer.class;
        PersonTableModel.columnNames[7] = "Performance %";
        PersonTableModel.columnTypes[7] = Integer.class;
        PersonTableModel.columnNames[2] = "Location";
        PersonTableModel.columnTypes[2] = String.class;
        PersonTableModel.columnNames[8] = "Job";
        PersonTableModel.columnTypes[8] = String.class;
        PersonTableModel.columnNames[10] = "Mission";
        PersonTableModel.columnTypes[10] = String.class;
        PersonTableModel.columnNames[9] = "Task";
        PersonTableModel.columnTypes[9] = String.class;
        PersonTableModel.columnNames[11] = "Health";
        PersonTableModel.columnTypes[11] = String.class;
    }

    private class AssociatedSettlementListener
    implements UnitListener {
        private AssociatedSettlementListener() {
        }

        public void unitUpdate(UnitEvent event) {
            String eventType = event.getType();
            if (eventType.equals("add associated person")) {
                PersonTableModel.this.addUnit((Unit)event.getTarget());
            } else if (eventType.equals("remove associated person")) {
                PersonTableModel.this.removeUnit((Unit)event.getTarget());
            }
        }
    }

    private class InhabitantSettlementListener
    implements UnitListener {
        private InhabitantSettlementListener() {
        }

        public void unitUpdate(UnitEvent event) {
            String eventType = event.getType();
            if (eventType.equals("inventory storing unit")) {
                if (event.getTarget() instanceof Person) {
                    PersonTableModel.this.addUnit((Unit)event.getTarget());
                }
            } else if (eventType.equals("inventory retrieving unit") && event.getTarget() instanceof Person) {
                PersonTableModel.this.removeUnit((Unit)event.getTarget());
            }
        }
    }

    private class LocalUnitManagerListener
    implements UnitManagerListener {
        private LocalUnitManagerListener() {
        }

        public void unitManagerUpdate(UnitManagerEvent event) {
            Unit unit = event.getUnit();
            String eventType = event.getEventType();
            if (unit instanceof Person) {
                if (eventType.equals("add unit")) {
                    if (!PersonTableModel.this.containsUnit(unit)) {
                        PersonTableModel.this.addUnit(unit);
                    }
                } else if (eventType.equals("remove unit") && PersonTableModel.this.containsUnit(unit)) {
                    PersonTableModel.this.removeUnit(unit);
                }
            }
        }
    }

    private class LocalMissionListener
    implements MissionListener {
        private LocalMissionListener() {
        }

        public void missionUpdate(MissionEvent event) {
            String eventType = event.getType();
            if (eventType.equals("remove member")) {
                PersonTableModel.this.addUnit((Unit)event.getTarget());
            } else if (eventType.equals("add member")) {
                PersonTableModel.this.removeUnit((Unit)event.getTarget());
            }
        }
    }

    private class LocalCrewListener
    implements UnitListener {
        private LocalCrewListener() {
        }

        public void unitUpdate(UnitEvent event) {
            String eventType = event.getType();
            if (eventType.equals("inventory storing unit")) {
                if (event.getTarget() instanceof Person) {
                    PersonTableModel.this.addUnit((Unit)event.getTarget());
                }
            } else if (eventType.equals("inventory retrieving unit") && event.getTarget() instanceof Person) {
                PersonTableModel.this.removeUnit((Unit)event.getTarget());
            }
        }
    }

    private static class PersonTableUpdater
    implements Runnable {
        static final Map<String, Integer> EVENT_COLUMN_MAPPING;
        private final UnitEvent event;
        private final UnitTableModel tableModel;

        private PersonTableUpdater(UnitEvent event, UnitTableModel tableModel) {
            this.event = event;
            this.tableModel = tableModel;
        }

        @Override
        public void run() {
            String eventType = this.event.getType();
            Integer column = EVENT_COLUMN_MAPPING.get(eventType);
            if (column != null && column > -1) {
                Unit unit = (Unit)this.event.getSource();
                this.tableModel.fireTableCellUpdated(this.tableModel.getUnitIndex(unit), column);
            }
        }

        static {
            HashMap<String, Integer> m = new HashMap<String, Integer>();
            m.put("name", 0);
            m.put("location", 2);
            m.put("hunger event", 4);
            m.put("fatigue event", 5);
            m.put("stress event", 6);
            m.put("performance event", 7);
            m.put("job event", 8);
            m.put("task", 9);
            m.put("mission event", 10);
            m.put("illness event", 11);
            m.put("death event", 11);
            EVENT_COLUMN_MAPPING = Collections.unmodifiableMap(m);
        }
    }
}

