/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.tool.monitor;

import java.awt.Component;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.AbstractDataset;
import org.jfree.data.DatasetChangeListener;
import org.jfree.data.PieDataset;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.tool.monitor.ColumnSelector;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorModel;
import org.mars_sim.msp.ui.swing.tool.monitor.MonitorTab;

class PieChartTab
extends MonitorTab {
    public static final Icon PIEICON = ImageLoader.getIcon("PieChart");
    private static final long MIN_TIME_BETWEEN_UPDATES = 1000L;
    private static final String NONECAT = "None";
    private TablePieDataset pieModel = null;
    private JFreeChart chart = null;
    private ChartPanel chartpanel = null;

    public PieChartTab(MonitorModel model, int column) {
        super(model, false, PIEICON);
        String title = model.getName() + " - " + model.getColumnName(column);
        this.setName(title);
        this.pieModel = new TablePieDataset(model, column);
        this.chart = ChartFactory.createPieChart(null, (PieDataset)this.pieModel, (boolean)true, (boolean)true, (boolean)false);
        this.chart.setBackgroundPaint((Paint)this.getBackground());
        this.pieModel.calculate();
        PiePlot plot = (PiePlot)this.chart.getPlot();
        plot.setCircular(false);
        plot.setRadius(0.6);
        plot.setSectionLabelType(3);
        this.pieModel.addChangeListener((DatasetChangeListener)plot);
        this.chartpanel = new ChartPanel(this.chart, true);
        this.add((Component)this.chartpanel, "Center");
    }

    @Override
    public void displayProps(MainDesktopPane desktop) {
        int column = ColumnSelector.createPieSelector(desktop.getMainWindow().getFrame(), this.getModel());
        if (column >= 0) {
            this.setColumn(column);
        }
    }

    @Override
    protected List getSelection() {
        return Collections.EMPTY_LIST;
    }

    private void setColumn(int column) {
        this.pieModel.setColumn(column);
        String title = this.getModel().getName() + " - " + this.getModel().getColumnName(column);
        this.setName(title);
    }

    @Override
    public void removeTab() {
        this.chart = null;
        this.pieModel.setModel(null);
        this.pieModel = null;
    }

    static class TablePieDataset
    extends AbstractDataset
    implements PieDataset,
    TableModelListener {
        private TableModel model;
        private int column;
        private Map<Comparable, Integer> dataMap;
        private long lastUpdateTime;

        public TablePieDataset(TableModel model, int column) {
            this.column = column;
            this.dataMap = Collections.synchronizedMap(new LinkedHashMap(model.getRowCount()));
            this.setModel(model);
        }

        void calculate() {
            long time = System.nanoTime() / 1000000L;
            if (time - this.lastUpdateTime > 1000L) {
                this.lastUpdateTime = time;
                int rows = this.model.getRowCount();
                Map<Comparable, Integer> tempMap = Collections.synchronizedMap(new LinkedHashMap<Comparable, Integer>(this.dataMap));
                Iterator<Comparable> iter = tempMap.keySet().iterator();
                while (iter.hasNext()) {
                    tempMap.put(iter.next(), 0);
                }
                for (int i = 0; i < rows; ++i) {
                    Object category = (Comparable)this.model.getValueAt(i, this.column);
                    if (category == null) {
                        category = PieChartTab.NONECAT;
                    } else if (!(category instanceof String)) {
                        category = category.toString();
                    }
                    if (((String)category).trim().length() == 0) {
                        category = PieChartTab.NONECAT;
                    }
                    Integer value = tempMap.get(category);
                    int count = 1;
                    if (value != null) {
                        count = value + 1;
                    }
                    tempMap.put((Comparable)category, count);
                }
                if (!this.dataMap.equals(tempMap)) {
                    this.dataMap.clear();
                    this.dataMap = tempMap;
                    this.fireDatasetChanged();
                } else {
                    tempMap.clear();
                }
            }
        }

        public void setColumn(int column) {
            this.column = column;
            this.calculate();
        }

        public void setModel(TableModel newModel) {
            if (this.model != null) {
                this.model.removeTableModelListener(this);
            }
            this.model = newModel;
            if (this.model != null) {
                this.model.addTableModelListener(this);
                this.calculate();
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.calculate();
        }

        public int getIndex(Comparable key) {
            int result = -1;
            Set<Comparable> keys = this.dataMap.keySet();
            if (keys.contains(key)) {
                int count = 0;
                Iterator<Comparable> i = keys.iterator();
                while (i.hasNext()) {
                    if (key == i.next()) {
                        result = count;
                        continue;
                    }
                    ++count;
                }
            }
            return result;
        }

        public Number getValue(Comparable key) {
            return this.dataMap.get(key);
        }

        public int getItemCount() {
            return this.dataMap.size();
        }

        public Number getValue(int item) {
            Number result = null;
            Object[] keys = this.dataMap.keySet().toArray();
            if (item < keys.length) {
                result = this.dataMap.get(keys[item]);
            }
            return result;
        }

        public Comparable getKey(int index) {
            Comparable result = null;
            Object[] keys = this.dataMap.keySet().toArray();
            if (index < keys.length) {
                result = (Comparable)keys[index];
            }
            return result;
        }

        public List<Comparable> getKeys() {
            ArrayList<Comparable> result = new ArrayList<Comparable>(this.dataMap.size());
            Iterator<Comparable> i = this.dataMap.keySet().iterator();
            while (i.hasNext()) {
                result.add(i.next());
            }
            return result;
        }
    }
}

